/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import android.text.TextUtils;
import com.helpshift.analytics.dto.AnalyticsEventDTO;
import com.helpshift.cif.dto.CustomIssueFieldDTO;
import com.helpshift.common.exception.ParseException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Jsonifier;
import com.helpshift.meta.dto.BreadCrumbDTO;
import com.helpshift.meta.dto.DebugLogDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AndroidJsonifier
implements Jsonifier {
    @Override
    public String jsonify(Map<String, Object> map) {
        try {
            JSONObject jsonObject = new JSONObject();
            for (String key : map.keySet()) {
                jsonObject.put(key, map.get(key));
            }
            return jsonObject.toString();
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Exception while calling jsonify on map");
        }
    }

    @Override
    public Object jsonifyToObject(Map<String, Object> map) {
        try {
            JSONObject jsonObject = new JSONObject();
            for (String key : map.keySet()) {
                jsonObject.put(key, map.get(key));
            }
            return jsonObject;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Exception while calling jsonify on map");
        }
    }

    @Override
    public String jsonify(Collection data) {
        JSONArray jsonArray = new JSONArray(data);
        return jsonArray.toString();
    }

    @Override
    public Object jsonifyListToJsonArray(List<String> data) {
        JSONArray jsonArray = new JSONArray();
        for (String key : data) {
            jsonArray.put((Object)key);
        }
        return jsonArray;
    }

    @Override
    public String jsonifyAnalyticsDTOList(List<AnalyticsEventDTO> analyticsEventDTOList) {
        if (analyticsEventDTOList == null) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        try {
            for (AnalyticsEventDTO analyticsEventDTO : analyticsEventDTOList) {
                jsonArray.put((Object)this.jsonifyAnalyticsDTO(analyticsEventDTO));
            }
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Exception while forming analytics string");
        }
        return jsonArray.toString();
    }

    @Override
    public Object jsonifyBreadCrumbDTOList(List<BreadCrumbDTO> breadCrumbsDTOList) {
        JSONArray jsonArray = new JSONArray();
        if (breadCrumbsDTOList != null) {
            try {
                for (BreadCrumbDTO breadCrumbDTO : breadCrumbsDTOList) {
                    jsonArray.put((Object)this.jsonifyBreadCrumbDTO(breadCrumbDTO));
                }
            }
            catch (JSONException e) {
                throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Exception while forming breadcrumb string");
            }
        }
        return jsonArray;
    }

    @Override
    public Object jsonifyDebugLogDTOList(List<DebugLogDTO> debugLogDTOs) {
        JSONArray jsonArray = new JSONArray();
        if (debugLogDTOs != null) {
            try {
                for (DebugLogDTO DebugLogDTO2 : debugLogDTOs) {
                    jsonArray.put((Object)this.jsonifyDebugLogDTO(DebugLogDTO2));
                }
            }
            catch (JSONException e) {
                throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Exception while forming debugLog string");
            }
        }
        return jsonArray;
    }

    @Override
    public String removeKeyFromJsonObjString(String jsonObjString, String key) {
        String result;
        try {
            JSONObject object = new JSONObject(jsonObjString);
            object.remove(key);
            result = object.toString();
        }
        catch (JSONException e) {
            result = jsonObjString;
        }
        return result;
    }

    @Override
    public Object jsonifyCustomMetaMap(Map<String, Serializable> customMetaMap) {
        try {
            JSONObject jsonObject = new JSONObject();
            for (String key : customMetaMap.keySet()) {
                Object value = customMetaMap.get(key);
                if (value instanceof String[]) {
                    String[] tmpValue = (String[])value;
                    value = this.jsonifyListToJsonArray(new ArrayList<String>(Arrays.asList(tmpValue)));
                }
                jsonObject.put(key, value);
            }
            return jsonObject;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Exception while forming custom meta string");
        }
    }

    @Override
    public Object jsonifyCustomIssueFieldDTOList(List<CustomIssueFieldDTO> customIssueFieldDTOs) {
        JSONObject jsonObject = new JSONObject();
        for (CustomIssueFieldDTO customIssueFieldDTO : customIssueFieldDTOs) {
            try {
                JSONArray jsonArray = new JSONArray();
                jsonArray.put((Object)customIssueFieldDTO.type);
                for (String value : customIssueFieldDTO.values) {
                    jsonArray.put((Object)value);
                }
                jsonObject.put(customIssueFieldDTO.key, (Object)jsonArray);
            }
            catch (JSONException e) {
                throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Exception while forming custom issue field string");
            }
        }
        return jsonObject;
    }

    private JSONObject jsonifyDebugLogDTO(DebugLogDTO debugLogDTO) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        if (debugLogDTO.msg != null) {
            jsonObject.put("message", (Object)debugLogDTO.msg);
        }
        jsonObject.put("level", (Object)debugLogDTO.level);
        jsonObject.put("tag", (Object)debugLogDTO.tag);
        if (!TextUtils.isEmpty((CharSequence)debugLogDTO.throwable)) {
            jsonObject.put("exception", (Object)debugLogDTO.throwable);
        }
        return jsonObject;
    }

    private JSONObject jsonifyBreadCrumbDTO(BreadCrumbDTO breadCrumbDTO) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("action", (Object)breadCrumbDTO.action);
        jsonObject.put("datetime", (Object)breadCrumbDTO.dateTime);
        return jsonObject;
    }

    private JSONObject jsonifyAnalyticsDTO(AnalyticsEventDTO analyticsEventDTO) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ts", (Object)analyticsEventDTO.timeStamp);
        jsonObject.put("t", (Object)analyticsEventDTO.type.key);
        if (analyticsEventDTO.data != null) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.putAll(analyticsEventDTO.data);
            jsonObject.put("d", this.jsonifyToObject(dataMap));
        }
        return jsonObject;
    }
}

