/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import com.helpshift.common.platform.KVStore;
import com.helpshift.common.platform.network.NetworkRequestDAO;
import com.helpshift.util.HSLogger;
import java.util.HashMap;

public class AndroidNetworkRequestDAO
implements NetworkRequestDAO {
    private KVStore kvStore;
    private static final String KEY_SERVER_TIME_DELTA = "server_time_delta";
    private static final String KEY_ROUTE_ETAG_MAP = "route_etag_map";

    public AndroidNetworkRequestDAO(KVStore kvStore) {
        this.kvStore = kvStore;
    }

    @Override
    public void storeServerTimeDelta(float timeDelta) {
        this.kvStore.setFloat(KEY_SERVER_TIME_DELTA, Float.valueOf(timeDelta));
        HSLogger.updateTimeStampDelta(timeDelta);
    }

    @Override
    public float getServerTimeDelta() {
        return this.kvStore.getFloat(KEY_SERVER_TIME_DELTA, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void storeETag(String route, String eTag) {
        Object fromKVStore = this.kvStore.getSerializable(KEY_ROUTE_ETAG_MAP);
        HashMap<String, String> mapToStore = fromKVStore == null ? new HashMap<String, String>() : (HashMap<String, String>)fromKVStore;
        mapToStore.put(route, eTag);
        this.kvStore.setSerializable(KEY_ROUTE_ETAG_MAP, mapToStore);
    }

    @Override
    public String getETag(String route) {
        Object fromKVStore = this.kvStore.getSerializable(KEY_ROUTE_ETAG_MAP);
        if (fromKVStore == null) {
            return null;
        }
        HashMap routeEtagMap = (HashMap)fromKVStore;
        return (String)routeEtagMap.get(route);
    }
}

