/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import com.helpshift.account.response.CreateProfileResponse;
import com.helpshift.auth.dto.WebSocketAuthData;
import com.helpshift.common.exception.ParseException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.configuration.response.PeriodicReview;
import com.helpshift.configuration.response.RootServerConfig;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.message.AcceptedAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminMessageDM;
import com.helpshift.conversation.activeconversation.message.AttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.ConfirmationAcceptedMessageDM;
import com.helpshift.conversation.activeconversation.message.ConfirmationRejectedMessageDM;
import com.helpshift.conversation.activeconversation.message.FollowupAcceptedMessageDM;
import com.helpshift.conversation.activeconversation.message.FollowupRejectedMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.RequestAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestForReopenMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.ScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.UserMessageDM;
import com.helpshift.conversation.dto.ConversationInbox;
import com.helpshift.conversation.dto.ConversationStatus;
import com.helpshift.conversation.dto.WSPingMessage;
import com.helpshift.conversation.dto.WSTypingActionMessage;
import com.helpshift.conversation.dto.WebSocketMessage;
import com.helpshift.util.HSLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AndroidResponseParser
implements ResponseParser {
    private static final String TAG = "Helpshift_AResponseParser";

    AndroidResponseParser() {
    }

    @Override
    public CreateProfileResponse parseCreateProfileResponse(String response) {
        try {
            JSONObject responseObject = new JSONObject(response);
            return new CreateProfileResponse(responseObject.getString("id"), responseObject.getString("name"));
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while creating profile");
        }
    }

    @Override
    public RootServerConfig parseConfigResponse(String response) {
        try {
            JSONObject config = new JSONObject(response);
            return new RootServerConfig(config.optBoolean("rne", false), config.optBoolean("pfe", true), config.optBoolean("san", true), config.optBoolean("csat", false), config.optBoolean("dia", false), this.parseDisableHelpshiftBrandingValue(config.optJSONObject("t")), config.optInt("dbgl", 100), config.optInt("bcl", 100), config.optString("rurl", ""), this.parsePeriodicReview(config.getJSONObject("pr")));
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while fetching config");
        }
    }

    private boolean parseDisableHelpshiftBrandingValue(JSONObject jsonObject) {
        boolean disableHelpshiftBranding = false;
        if (jsonObject != null) {
            String hl = jsonObject.optString("hl", "true");
            disableHelpshiftBranding = !hl.equals("true");
        }
        return disableHelpshiftBranding;
    }

    @Override
    public ConversationDM parseReadableConversation(String conversationResponse) {
        try {
            JSONObject resObj = new JSONObject(conversationResponse);
            List<MessageDM> messageDMs = this.parseMessageDMs(resObj.getJSONArray("messages"));
            String messageCursor = null;
            for (int i = messageDMs.size() - 1; i >= 0; --i) {
                MessageDM messageDM = messageDMs.get(i);
                if (messageDM instanceof AdminAttachmentMessageDM || messageDM instanceof AdminImageAttachmentMessageDM) continue;
                messageCursor = messageDM.createdAt;
                break;
            }
            ConversationDM conversationDM = new ConversationDM(resObj.getString("id"), resObj.getString("title"), ConversationStatus.fromInt(resObj.getInt("status")), resObj.getString("created_at"), resObj.getString("updated_at"), resObj.getString("publish_id"), messageCursor, resObj.optBoolean("show-agent-name", true));
            conversationDM.setMessageDMs(messageDMs);
            return conversationDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception in reading conversation");
        }
    }

    @Override
    public UserMessageDM parseReadableUserMessage(String responseString) {
        try {
            JSONObject messageObj = new JSONObject(responseString);
            UserMessageDM messageDM = new UserMessageDM(messageObj.getString("body"), messageObj.getString("created_at"), messageObj.getJSONObject("author").getString("name"));
            messageDM.serverId = messageObj.getString("id");
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading user text message");
        }
    }

    private List<MessageDM> parseMessageDMs(JSONArray messagesObj) {
        ArrayList<MessageDM> messageDMs = new ArrayList<MessageDM>();
        for (int i = 0; i < messagesObj.length(); ++i) {
            try {
                JSONObject messageObj = messagesObj.getJSONObject(i);
                String type = messageObj.getString("type");
                String origin = messageObj.getString("origin");
                if (type.equals("txt") && origin.equals("mobile")) {
                    messageDMs.add(this.parseReadableUserMessage(messageObj.toString()));
                    continue;
                }
                if (type.equals("txt") && origin.equals("admin")) {
                    messageDMs.addAll(this.parseAdminMessageDM(messageObj));
                    continue;
                }
                if (type.equals("rar") && origin.equals("admin")) {
                    messageDMs.add(this.parseRequestAppReviewMessageDM(messageObj));
                    continue;
                }
                if (type.equals("ar") && origin.equals("mobile")) {
                    messageDMs.add(this.parseAcceptedAppReviewMessageDM(messageObj.toString()));
                    continue;
                }
                if (type.equals("ncr") && origin.equals("mobile")) {
                    messageDMs.add(this.parseConfirmationRejectedMessageDM(messageObj.toString()));
                    continue;
                }
                if (type.equals("ca") && origin.equals("mobile")) {
                    messageDMs.add(this.parseConfirmationAcceptedMessageDM(messageObj.toString()));
                    continue;
                }
                if (type.equals("rsc") && origin.equals("admin")) {
                    messageDMs.add(this.parseRequestScreenshotMessageDM(messageObj));
                    continue;
                }
                if (type.equals("sc") && origin.equals("mobile")) {
                    messageDMs.add(this.parseScreenshotMessageDM(messageObj));
                    continue;
                }
                if (type.equals("rfr") && origin.equals("admin")) {
                    messageDMs.add(this.parseRequestForReopenMessageDM(messageObj));
                    continue;
                }
                if (type.equals("ra") && origin.equals("mobile")) {
                    messageDMs.add(this.parseFollowupAcceptedMessageDM(messageObj));
                    continue;
                }
                if (!type.equals("rj") || !origin.equals("mobile")) continue;
                messageDMs.add(this.parseFollowupRejectedMessageDM(messageObj));
                continue;
            }
            catch (RootAPIException | JSONException ex) {
                HSLogger.e(TAG, "Exception while parsing messages: ", ex);
            }
        }
        return messageDMs;
    }

    private FollowupRejectedMessageDM parseFollowupRejectedMessageDM(JSONObject messageObj) {
        try {
            FollowupRejectedMessageDM messageDM = new FollowupRejectedMessageDM(messageObj.getString("body"), messageObj.getString("created_at"), messageObj.getJSONObject("author").getString("name"), messageObj.getJSONObject("meta").getString("refers"));
            messageDM.serverId = messageObj.getString("id");
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading follow-up rejected message");
        }
    }

    private FollowupAcceptedMessageDM parseFollowupAcceptedMessageDM(JSONObject messageObj) {
        try {
            FollowupAcceptedMessageDM messageDM = new FollowupAcceptedMessageDM(messageObj.getString("body"), messageObj.getString("created_at"), messageObj.getJSONObject("author").getString("name"), messageObj.getJSONObject("meta").getString("refers"));
            messageDM.serverId = messageObj.getString("id");
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading follow-up accepted message");
        }
    }

    private RequestForReopenMessageDM parseRequestForReopenMessageDM(JSONObject messageObj) {
        try {
            RequestForReopenMessageDM messageDM = new RequestForReopenMessageDM(messageObj.getString("id"), messageObj.getString("body"), messageObj.getString("created_at"), messageObj.getJSONObject("author").getString("name"));
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading reopen message");
        }
    }

    private List<MessageDM> parseAdminMessageDM(JSONObject messageObj) {
        try {
            ArrayList<MessageDM> result = new ArrayList<MessageDM>();
            JSONArray attachments = messageObj.getJSONObject("meta").optJSONArray("attachments");
            AdminMessageDM messageDM = new AdminMessageDM(messageObj.getString("id"), messageObj.getString("body"), messageObj.getString("created_at"), messageObj.getJSONObject("author").getString("name"));
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            result.add(messageDM);
            if (attachments != null) {
                result.addAll(this.parseAdminAttachmentEntities(messageObj, attachments));
            }
            return result;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading admin text message");
        }
    }

    private List<MessageDM> parseAdminAttachmentEntities(JSONObject messageObj, JSONArray attachments) {
        try {
            ArrayList<MessageDM> result = new ArrayList<MessageDM>();
            for (int i = 0; i < attachments.length(); ++i) {
                AttachmentMessageDM messageDM;
                JSONObject attachment = attachments.getJSONObject(i);
                String messageId = messageObj.getString("id") + "_" + i;
                String createdAt = messageObj.getString("created_at");
                createdAt = HSDateFormatSpec.addMilliSeconds(HSDateFormatSpec.STORAGE_TIME_FORMAT, createdAt, i + 1);
                int deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
                if (attachment.optBoolean("image")) {
                    messageDM = new AdminImageAttachmentMessageDM(messageId, messageObj.getString("body"), createdAt, messageObj.getJSONObject("author").getString("name"), attachment.getString("url"), attachment.getString("file-name"), attachment.getString("thumbnail"), attachment.getString("content-type"), attachment.getInt("size"));
                    ((AdminImageAttachmentMessageDM)messageDM).deliveryState = deliveryState;
                    result.add(messageDM);
                    continue;
                }
                messageDM = new AdminAttachmentMessageDM(messageId, messageObj.getString("body"), createdAt, messageObj.getJSONObject("author").getString("name"), attachment.getInt("size"), attachment.getString("content-type"), attachment.getString("url"), attachment.getString("file-name"));
                messageDM.deliveryState = deliveryState;
                result.add(messageDM);
            }
            return result;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading admin attachment message");
        }
    }

    private RequestAppReviewMessageDM parseRequestAppReviewMessageDM(JSONObject messageObj) {
        try {
            boolean isAnswered = false;
            JSONObject responseObj = messageObj.getJSONObject("meta").optJSONObject("response");
            if (responseObj != null) {
                isAnswered = responseObj.optBoolean("state");
            }
            boolean isInvisible = messageObj.optBoolean("invisible") || isAnswered;
            RequestAppReviewMessageDM messageDM = new RequestAppReviewMessageDM(messageObj.getString("id"), messageObj.getString("body"), messageObj.getString("created_at"), messageObj.getJSONObject("author").getString("name"), isInvisible);
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading request review message");
        }
    }

    @Override
    public AcceptedAppReviewMessageDM parseAcceptedAppReviewMessageDM(String response) {
        try {
            JSONObject messageObj = new JSONObject(response);
            AcceptedAppReviewMessageDM messageDM = new AcceptedAppReviewMessageDM(messageObj.getString("body"), messageObj.getString("created_at"), messageObj.getJSONObject("author").getString("name"), messageObj.getJSONObject("meta").getString("refers"));
            messageDM.serverId = messageObj.getString("id");
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading accepted review message");
        }
    }

    @Override
    public ConfirmationRejectedMessageDM parseConfirmationRejectedMessageDM(String response) {
        try {
            JSONObject messageObj = new JSONObject(response);
            ConfirmationRejectedMessageDM messageDM = new ConfirmationRejectedMessageDM(messageObj.getString("body"), messageObj.getString("created_at"), messageObj.getJSONObject("author").getString("name"));
            messageDM.serverId = messageObj.getString("id");
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading confirmation rejected message");
        }
    }

    @Override
    public ConfirmationAcceptedMessageDM parseConfirmationAcceptedMessageDM(String response) {
        try {
            JSONObject messageObj = new JSONObject(response);
            ConfirmationAcceptedMessageDM messageDM = new ConfirmationAcceptedMessageDM(messageObj.getString("body"), messageObj.getString("created_at"), messageObj.getJSONObject("author").getString("name"));
            messageDM.serverId = messageObj.getString("id");
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading confirmation accepted message");
        }
    }

    private RequestScreenshotMessageDM parseRequestScreenshotMessageDM(JSONObject messageObj) {
        try {
            boolean isAnswered = false;
            JSONObject responseObj = messageObj.getJSONObject("meta").optJSONObject("response");
            if (responseObj != null) {
                isAnswered = responseObj.getBoolean("state");
            }
            RequestScreenshotMessageDM messageDM = new RequestScreenshotMessageDM(messageObj.getString("id"), messageObj.getString("body"), messageObj.getString("created_at"), messageObj.getJSONObject("author").getString("name"), isAnswered);
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading request screenshot message");
        }
    }

    private ScreenshotMessageDM parseScreenshotMessageDM(JSONObject messageObj) {
        try {
            JSONObject attachment = messageObj.getJSONObject("meta").getJSONArray("attachments").getJSONObject(0);
            ScreenshotMessageDM messageDM = new ScreenshotMessageDM(messageObj.getString("body"), messageObj.getString("created_at"), messageObj.getJSONObject("author").getString("name"), attachment.getString("content-type"), attachment.optString("thumbnail", ""), attachment.getString("file-name"), attachment.getString("url"), attachment.getInt("size"));
            messageDM.serverId = messageObj.getString("id");
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading screenshot message");
        }
    }

    @Override
    public ScreenshotMessageDM parseScreenshotMessageDM(String response) {
        try {
            JSONObject responseObj = new JSONObject(response);
            return this.parseScreenshotMessageDM(responseObj);
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading reopen message");
        }
    }

    @Override
    public ConversationInbox parseConversationInbox(String response) {
        try {
            JSONObject responseObj = new JSONObject(response);
            ArrayList<ConversationDM> conversations = new ArrayList<ConversationDM>();
            JSONArray conversationObjs = responseObj.getJSONArray("issues");
            for (int i = 0; i < conversationObjs.length(); ++i) {
                conversations.add(this.parseReadableConversation(conversationObjs.getJSONObject(i).toString()));
            }
            return new ConversationInbox(responseObj.getString("timestamp"), conversations);
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading conversation inbox");
        }
    }

    @Override
    public FollowupRejectedMessageDM parseFollowupRejectedMessage(String response) {
        try {
            JSONObject responseObj = new JSONObject(response);
            return this.parseFollowupRejectedMessageDM(responseObj);
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading follow-up rejected message");
        }
    }

    @Override
    public FollowupAcceptedMessageDM parseFollowupAcceptedMessage(String response) {
        try {
            JSONObject responseObj = new JSONObject(response);
            return this.parseFollowupAcceptedMessageDM(responseObj);
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading follow-up accepted message");
        }
    }

    @Override
    public WebSocketAuthData parseAuthToken(String response) {
        WebSocketAuthData returnAuthData = null;
        try {
            JSONObject responseObj = new JSONObject(response);
            String authToken = responseObj.getString("token");
            String webSocketRoute = responseObj.getString("endpoint");
            returnAuthData = new WebSocketAuthData(authToken, webSocketRoute);
        }
        catch (JSONException e) {
            HSLogger.e(TAG, "Exception in parsing auth token", e);
        }
        return returnAuthData;
    }

    @Override
    public WebSocketMessage parseWebSocketMessage(String response) {
        WebSocketMessage returnMessage = null;
        try {
            JSONArray array = new JSONArray(response);
            int messageType = array.getInt(0);
            switch (messageType) {
                case 107: {
                    long pingWaitTime = TimeUnit.SECONDS.toMillis(array.getLong(1));
                    returnMessage = new WSPingMessage(pingWaitTime);
                    break;
                }
                case 100: {
                    JSONArray actionArray = array.getJSONArray(2);
                    for (int i = 0; i < actionArray.length(); ++i) {
                        JSONObject message = actionArray.getJSONObject(i);
                        JSONObject messageData = new JSONObject(message.getString("m"));
                        String stream = messageData.getString("stream");
                        if (!"agent_type_activity".equals(stream)) continue;
                        String action = messageData.getString("action");
                        if ("start".equals(action)) {
                            long typingActionTimeout = TimeUnit.SECONDS.toMillis(messageData.getLong("ttl"));
                            returnMessage = new WSTypingActionMessage(true, typingActionTimeout);
                            continue;
                        }
                        if (!"stop".equals(action)) continue;
                        returnMessage = new WSTypingActionMessage(false, 0L);
                    }
                    break;
                }
            }
        }
        catch (JSONException e) {
            HSLogger.e(TAG, "Exception in parsing web-socket message", e);
        }
        return returnMessage;
    }

    private PeriodicReview parsePeriodicReview(JSONObject periodicReviewConfig) throws JSONException {
        return new PeriodicReview(periodicReviewConfig.optBoolean("s"), periodicReviewConfig.optInt("i"), periodicReviewConfig.optString("t", ""));
    }

    private int convertDeliveryStateToInt(String mdState) {
        switch (mdState) {
            case "unread": {
                return 0;
            }
            case "read": {
                return 1;
            }
            case "sent": {
                return 2;
            }
        }
        return 0;
    }
}

