/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import android.content.Context;
import android.os.Environment;
import com.helpshift.android.commons.downloader.DownloadConfig;
import com.helpshift.android.commons.downloader.DownloadManager;
import com.helpshift.android.commons.downloader.contracts.OnDownloadFinishListener;
import com.helpshift.android.commons.downloader.contracts.OnProgressChangedListener;
import com.helpshift.common.domain.HSThreadFactory;
import com.helpshift.common.platform.KVStore;
import com.helpshift.common.platform.SupportDownloaderKVStorage;
import com.helpshift.downloader.SupportDownloadStateChangeListener;
import com.helpshift.downloader.SupportDownloader;
import com.helpshift.util.ApplicationUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AndroidSupportDownloader
implements SupportDownloader {
    private static final int KEEP_ALIVE_TIME = 1;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private static final int CORE_POOL_SIZE = 5;
    private static final int MAXIMUM_POOL_SIZE = 5;
    private final DownloadManager downloadManager;
    private Context context;
    private Map<String, Set<SupportDownloadStateChangeListener>> callbackManager;

    public AndroidSupportDownloader(Context context, KVStore kvStore) {
        this.context = context;
        this.callbackManager = new HashMap<String, Set<SupportDownloadStateChangeListener>>();
        SupportDownloaderKVStorage storage = new SupportDownloaderKVStorage(kvStore);
        LinkedBlockingQueue<Runnable> downloadRunnableQueue = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor downloadExecutor = new ThreadPoolExecutor(5, 5, 1L, KEEP_ALIVE_TIME_UNIT, downloadRunnableQueue, new HSThreadFactory("sp-dwnld"));
        this.downloadManager = new DownloadManager(context, storage, downloadExecutor);
    }

    private String getStoragePath() {
        String result = null;
        if (ApplicationUtil.isPermissionGranted(this.context, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            result = Environment.DIRECTORY_DOWNLOADS;
        }
        return result;
    }

    @Override
    public void startDownload(String url, SupportDownloader.StorageDirType storageDirType, SupportDownloadStateChangeListener stateChangeListener) {
        this.addCallback(url, stateChangeListener);
        String externalStorageDownloadDirPath = this.getStoragePath();
        boolean isNoMedia = false;
        switch (storageDirType) {
            case INTERNAL_ONLY: {
                externalStorageDownloadDirPath = null;
                isNoMedia = true;
                break;
            }
            case EXTERNAL_ONLY: {
                if (externalStorageDownloadDirPath != null) break;
                stateChangeListener.onFailure(url);
                return;
            }
            case EXTERNAL_OR_INTERNAL: {
                if (externalStorageDownloadDirPath != null) break;
                isNoMedia = true;
            }
        }
        DownloadConfig downloadConfig = new DownloadConfig.Builder().setUseCache(true).setWriteToFile(true).setIsNoMedia(isNoMedia).setExternalStorageDirectoryPath(externalStorageDownloadDirPath).create();
        this.downloadManager.startDownload(url, downloadConfig, new OnDownloadFinishListener(){

            @Override
            public void onDownloadFinish(boolean success, String url, Object responseObject) {
                String filePath = responseObject.toString();
                if (success) {
                    AndroidSupportDownloader.this.handleDownloadSuccess(url, filePath);
                } else {
                    AndroidSupportDownloader.this.handleDownloadFailure(url);
                }
            }
        }, new OnProgressChangedListener(){

            @Override
            public void onProgressChanged(String url, int progress) {
                AndroidSupportDownloader.this.handleProgressChange(url, progress);
            }
        });
    }

    void handleDownloadSuccess(String url, String filePath) {
        for (SupportDownloadStateChangeListener callback : this.getCallbacks(url)) {
            callback.onSuccess(url, filePath);
        }
        this.removeCallbacks(url);
    }

    void handleProgressChange(String url, int progress) {
        for (SupportDownloadStateChangeListener callback : this.getCallbacks(url)) {
            callback.onProgressChange(url, progress);
        }
    }

    void handleDownloadFailure(String url) {
        for (SupportDownloadStateChangeListener callback : this.getCallbacks(url)) {
            callback.onFailure(url);
        }
        this.removeCallbacks(url);
    }

    private synchronized void addCallback(String key, SupportDownloadStateChangeListener stateChangeListener) {
        if (stateChangeListener == null) {
            return;
        }
        Set<SupportDownloadStateChangeListener> callbacks = this.callbackManager.get(key);
        if (callbacks == null) {
            callbacks = new HashSet<SupportDownloadStateChangeListener>();
        }
        callbacks.add(stateChangeListener);
        this.callbackManager.put(key, callbacks);
    }

    private synchronized void removeCallbacks(String key) {
        this.callbackManager.remove(key);
    }

    private synchronized Set<SupportDownloadStateChangeListener> getCallbacks(String key) {
        Set<SupportDownloadStateChangeListener> callbacks = this.callbackManager.get(key);
        HashSet<Object> result = callbacks == null ? new HashSet() : new HashSet<SupportDownloadStateChangeListener>(callbacks);
        return result;
    }
}

