/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import com.helpshift.account.dao.AccountManagerDAO;
import com.helpshift.account.dao.ProfileDAO;
import com.helpshift.analytics.AnalyticsEventDAO;
import com.helpshift.cif.dao.CustomIssueFieldDAO;
import com.helpshift.common.domain.Threader;
import com.helpshift.common.platform.Device;
import com.helpshift.common.platform.Jsonifier;
import com.helpshift.common.platform.KVStore;
import com.helpshift.common.platform.network.HTTPTransport;
import com.helpshift.common.platform.network.NetworkRequestDAO;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.conversation.dao.ConversationDAO;
import com.helpshift.conversation.dao.ConversationInboxDAO;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.downloader.SupportDownloader;
import com.helpshift.faq.dao.FaqEventDAO;
import com.helpshift.faq.domainmodel.FAQSearchDM;
import com.helpshift.meta.dao.MetaDataDAO;
import com.helpshift.providers.ICampaignsDataProvider;

public interface Platform {
    public String getAPIKey();

    public String getDomain();

    public String getAppId();

    public Device getDevice();

    public ConversationInboxDAO getConversationInboxDAO();

    public ConversationDAO getConversationDAO();

    public MetaDataDAO getMetaDataDAO();

    public AnalyticsEventDAO getAnalyticsEventDAO();

    public CustomIssueFieldDAO getCustomIssueFieldDAO();

    public ResponseParser getResponseParser();

    public HTTPTransport getHTTPTransport();

    public FAQSearchDM getFAQSearchDM();

    public KVStore getKVStore();

    public Jsonifier getJsonifier();

    public AccountManagerDAO getAccountManagerDAO();

    public ProfileDAO getProfileDAO();

    public NetworkRequestDAO getNetworkRequestDAO();

    public FaqEventDAO getFaqEventDAO();

    public boolean isCurrentThreadUIThread();

    public Threader getUIThreader();

    public SupportDownloader getDownloader();

    public String compressAndStoreScreenshot(String var1, String var2);

    public void compressAndCopyScreenshot(ImagePickerFile var1, String var2);

    public int getMinimumConversationDescriptionLength();

    public void showNotification(Long var1, String var2, int var3, String var4, String var5);

    public void clearNotifications(String var1);

    public ICampaignsDataProvider getCampaignDataProvider();

    public boolean isOnline();
}

