/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.poller;

import com.helpshift.common.poller.Delay;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class ExponentialBackoff {
    public static final long STOP = -100L;
    private long currentBaseIntervalMillis;
    private int attempts;
    private final long baseIntervalMillis;
    private final long maxIntervalMillis;
    private final float randomness;
    private final float multiplier;
    private final int maxAttempts;
    private final Random random;

    ExponentialBackoff(Builder builder) {
        this.baseIntervalMillis = builder.baseIntervalMillis;
        this.maxIntervalMillis = builder.maxIntervalMillis;
        this.randomness = builder.randomness;
        this.multiplier = builder.multiplier;
        this.maxAttempts = builder.maxAttempts;
        this.random = new Random();
        this.reset();
    }

    public void reset() {
        this.currentBaseIntervalMillis = this.baseIntervalMillis;
        this.attempts = 0;
    }

    public long nextIntervalMillis() {
        if (this.attempts >= this.maxAttempts) {
            return -100L;
        }
        ++this.attempts;
        float low = (float)this.currentBaseIntervalMillis * (1.0f - this.randomness);
        float high = (float)this.currentBaseIntervalMillis * (1.0f + this.randomness);
        if (this.currentBaseIntervalMillis <= this.maxIntervalMillis) {
            this.currentBaseIntervalMillis = Math.min((long)((float)this.currentBaseIntervalMillis * this.multiplier), this.maxIntervalMillis);
        }
        return (long)(low + this.random.nextFloat() * (high - low));
    }

    public static class Builder {
        public static final String ERROR_BASE_INTERVAL_RANGE = "Base interval can't be negative or zero";
        public static final String ERROR_MAX_INTERVAL_RANGE = "Max interval can't be negative or zero";
        public static final String ERROR_MAX_INTERVAL_LESS_THAN_BASE_INTERVAL = "Max interval can't be less than base interval";
        public static final String ERROR_RANDOMNESS_RANGE = "Randomness must be between 0 and 1 (both inclusive)";
        public static final String ERROR_MULTIPLIER_RANGE = "Multiplier can't be less than 1";
        public static final String ERROR_MAX_ATTEMPTS_RANGE = "Max attempts can't be negative or zero";
        long baseIntervalMillis = TimeUnit.SECONDS.toMillis(10L);
        long maxIntervalMillis = TimeUnit.SECONDS.toMillis(60L);
        float randomness = 0.5f;
        float multiplier = 2.0f;
        int maxAttempts = Integer.MAX_VALUE;

        public Builder setBaseInterval(Delay baseInterval) {
            this.baseIntervalMillis = baseInterval.timeUnit.toMillis(baseInterval.delay);
            return this;
        }

        public Builder setMaxInterval(Delay maxInterval) {
            this.maxIntervalMillis = maxInterval.timeUnit.toMillis(maxInterval.delay);
            return this;
        }

        public Builder setRandomness(float randomness) {
            this.randomness = randomness;
            return this;
        }

        public Builder setMultiplier(float multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        public Builder setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        void validate() {
            if (this.baseIntervalMillis <= 0L) {
                throw new IllegalArgumentException(ERROR_BASE_INTERVAL_RANGE);
            }
            if (this.maxIntervalMillis <= 0L) {
                throw new IllegalArgumentException(ERROR_MAX_INTERVAL_RANGE);
            }
            if (this.maxIntervalMillis < this.baseIntervalMillis) {
                throw new IllegalArgumentException(ERROR_MAX_INTERVAL_LESS_THAN_BASE_INTERVAL);
            }
            if (this.randomness < 0.0f || this.randomness > 1.0f) {
                throw new IllegalArgumentException(ERROR_RANDOMNESS_RANGE);
            }
            if (this.multiplier < 1.0f) {
                throw new IllegalArgumentException(ERROR_MULTIPLIER_RANGE);
            }
            if (this.maxAttempts <= 0) {
                throw new IllegalArgumentException(ERROR_MAX_ATTEMPTS_RANGE);
            }
        }

        public ExponentialBackoff build() throws IllegalArgumentException {
            this.validate();
            return new ExponentialBackoff(this);
        }
    }
}

