/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.poller;

import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.common.poller.Delay;
import com.helpshift.common.poller.ExponentialBackoff;

public class HttpBackoff {
    private final ExponentialBackoff exponentialBackoff;
    private final RetryPolicy retryPolicy;

    HttpBackoff(Builder builder) {
        this.exponentialBackoff = new ExponentialBackoff(builder.exponentialBackoffBuilder);
        this.retryPolicy = builder.retryPolicy;
    }

    public void reset() {
        this.exponentialBackoff.reset();
    }

    public long nextIntervalMillis(int statusCode) {
        long nextIntervalMillis = this.exponentialBackoff.nextIntervalMillis();
        if (this.retryPolicy.shouldRetry(statusCode)) {
            return nextIntervalMillis;
        }
        return -100L;
    }

    public static interface RetryPolicy {
        public static final RetryPolicy FAILURE = new RetryPolicy(){

            @Override
            public boolean shouldRetry(int statusCode) {
                return !NetworkErrorCodes.NOT_RETRIABLE_STATUS_CODES.contains(statusCode);
            }
        };
        public static final RetryPolicy ALWAYS = new RetryPolicy(){

            @Override
            public boolean shouldRetry(int statusCode) {
                return true;
            }
        };
        public static final RetryPolicy NEVER = new RetryPolicy(){

            @Override
            public boolean shouldRetry(int statusCode) {
                return false;
            }
        };

        public boolean shouldRetry(int var1);
    }

    public static class Builder {
        final ExponentialBackoff.Builder exponentialBackoffBuilder = new ExponentialBackoff.Builder();
        RetryPolicy retryPolicy = RetryPolicy.ALWAYS;

        public Builder setRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder setBaseInterval(Delay baseInterval) {
            this.exponentialBackoffBuilder.setBaseInterval(baseInterval);
            return this;
        }

        public Builder setMaxInterval(Delay maxInterval) {
            this.exponentialBackoffBuilder.setMaxInterval(maxInterval);
            return this;
        }

        public Builder setRandomness(float randomness) {
            this.exponentialBackoffBuilder.setRandomness(randomness);
            return this;
        }

        public Builder setMultiplier(float multiplier) {
            this.exponentialBackoffBuilder.setMultiplier(multiplier);
            return this;
        }

        public Builder setMaxAttempts(int maxAttempts) {
            this.exponentialBackoffBuilder.setMaxAttempts(maxAttempts);
            return this;
        }

        public HttpBackoff build() throws IllegalArgumentException {
            this.exponentialBackoffBuilder.validate();
            return new HttpBackoff(this);
        }
    }
}

