/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.util;

import com.helpshift.common.platform.Platform;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class HSDateFormatSpec {
    public static final String STORAGE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DISPLAY_TIME_PATTERN = "dd-MMM-yyyy HH:mm";
    public static final SimpleDateFormat STORAGE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public static Date getCurrentAdjustedTime(Platform platform) {
        float serverTimeDelta = platform.getNetworkRequestDAO().getServerTimeDelta();
        long currentTimeMillis = System.currentTimeMillis();
        if (serverTimeDelta != 0.0f) {
            currentTimeMillis = (long)((float)currentTimeMillis + serverTimeDelta * 1000.0f);
        }
        return new Date(currentTimeMillis);
    }

    public static String getCurrentAdjustedTimeForStorage(Platform platform) {
        return STORAGE_TIME_FORMAT.format(HSDateFormatSpec.getCurrentAdjustedTime(platform));
    }

    public static String addMilliSeconds(SimpleDateFormat dateFormat, String inputDate, int milliSeconds) {
        try {
            Date date = dateFormat.parse(inputDate);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            date = new Date(calendar.getTimeInMillis() + (long)milliSeconds);
            return dateFormat.format(date);
        }
        catch (ParseException parseException) {
            return inputDate;
        }
    }

    public static float calculateTimeDelta(String serverTime) {
        DecimalFormat tsSecFormatter = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
        String deviceTime = tsSecFormatter.format((double)System.currentTimeMillis() / 1000.0);
        Double timeStamp = Double.parseDouble(serverTime) * 1000.0;
        Date serverDate = new Date((long)timeStamp.doubleValue());
        return (float)((double)(serverDate.getTime() / 1000L) - Double.parseDouble(deviceTime));
    }

    static {
        STORAGE_TIME_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

