/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.util;

import com.helpshift.common.util.ListObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class HSObservableList<T>
extends ArrayList<T> {
    private ListObserver observer;

    public HSObservableList(List<T> elements) {
        super(elements);
    }

    public HSObservableList() {
    }

    public void setObserver(ListObserver observer) {
        this.observer = observer;
    }

    @Override
    public boolean add(T t) {
        boolean result = super.add(t);
        if (result && this.observer != null) {
            this.observer.add(this.indexOf(t), 1);
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = super.addAll(c);
        if (result && this.observer != null) {
            this.observer.add(this.indexOf(c.iterator().next()), c.size());
        }
        return result;
    }

    public T setAndNotifyObserver(int index, T messageDM) {
        T t = this.set(index, messageDM);
        if (t != null && this.observer != null) {
            this.observer.update(index, 1);
        }
        return t;
    }

    public void sortWithComparator(Comparator<T> comparator) {
        ArrayList preSort = new ArrayList(this);
        Collections.sort(this, comparator);
        HashSet<Integer> changedPositions = new HashSet<Integer>();
        for (Object t : preSort) {
            int toPosition;
            int fromPosition = preSort.indexOf(t);
            if (fromPosition == (toPosition = this.indexOf(t))) continue;
            changedPositions.add(fromPosition);
            changedPositions.add(toPosition);
        }
        if (this.observer != null && !changedPositions.isEmpty()) {
            int min = (Integer)Collections.min(changedPositions);
            int max = (Integer)Collections.max(changedPositions);
            this.observer.update(min, max - min + 1);
        }
    }
}

