/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.configuration.domainmodel;

import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.ETagNetwork;
import com.helpshift.common.domain.network.GETNetwork;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.platform.KVStore;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.configuration.dto.RootApiConfig;
import com.helpshift.configuration.dto.RootInstallConfig;
import com.helpshift.configuration.response.PeriodicReview;
import com.helpshift.configuration.response.RootServerConfig;
import com.helpshift.util.HSLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;

public class SDKConfigurationDM
extends Observable {
    private final Domain domain;
    private final Platform platform;
    private final ResponseParser responseParser;
    private final KVStore kvStore;
    public static final String REQUIRE_NAME_AND_EMAIL = "requireNameAndEmail";
    public static final String PROFILE_FORM_ENABLE = "profileFormEnable";
    public static final String SHOW_AGENT_NAME = "showAgentName";
    public static final String CUSTOMER_SATISFACTION_SURVEY = "customerSatisfactionSurvey";
    public static final String DEBUG_LOG_LIMIT = "debugLogLimit";
    public static final String BREADCRUMB_LIMIT = "breadcrumbLimit";
    public static final String DISABLE_IN_APP_CONVERSATION = "disableInAppConversation";
    private static final String HELPSHIFT_BRANDING_DISABLE_AGENT = "disableHelpshiftBrandingAgent";
    public static final String REVIEW_URL = "reviewUrl";
    private static final String PERIODIC_REVIEW_ENABLED = "periodicReviewEnabled";
    private static final String PERIODIC_REVIEW_INTERVAL = "periodicReviewInterval";
    private static final String PERIODIC_REVIEW_TYPE = "periodicReviewType";
    public static final String API_KEY = "apiKey";
    public static final String DOMAIN_NAME = "domainName";
    public static final String PLATFORM_ID = "platformId";
    public static final String SDK_TYPE = "sdkType";
    public static final String PLUGIN_VERSION = "pluginVersion";
    public static final String RUNTIME_VERSION = "runtimeVersion";
    public static final String FONT_PATH = "fontPath";
    public static final String NOTIFICATION_SOUND_ID = "notificationSoundId";
    public static final String NOTIFICATION_ICON_ID = "notificationIconId";
    public static final String SUPPORT_NOTIFICATION_CHANNEL_ID = "supportNotificationChannelId";
    public static final String NOTIFICATION_LARGE_ICON_ID = "notificationLargeIconId";
    public static final String NOTIFICATION_MUTE_ENABLE = "notificationMute";
    public static final String ENABLE_IN_APP_NOTIFICATION = "enableInAppNotification";
    private static final String HELPSHIFT_BRANDING_DISABLE_INSTALL = "disableHelpshiftBranding";
    public static final String INBOX_POLLING_ENABLE = "inboxPollingEnable";
    public static final String DISABLE_ANIMATION = "disableAnimations";
    public static final String DEFAULT_FALLBACK_LANGUAGE_ENABLE = "defaultFallbackLanguageEnable";
    public static final String DISABLE_ERROR_LOGGING = "disableErrorLogging";
    public static final String ENABLE_FULL_PRIVACY = "fullPrivacy";
    public static final String HIDE_NAME_AND_EMAIL = "hideNameAndEmail";
    public static final String REQUIRE_EMAIL = "requireEmail";
    public static final String SHOW_SEARCH_ON_NEW_CONVERSATION = "showSearchOnNewConversation";
    public static final String CONVERSATION_PRE_FILL_TEXT = "conversationPrefillText";
    public static final String ENABLE_CONTACT_US = "enableContactUs";
    public static final String GOTO_CONVERSATION_AFTER_CONTACT_US = "gotoConversationAfterContactUs";
    public static final String SHOW_CONVERSATION_RESOLUTION_QUESTION = "showConversationResolutionQuestion";
    public static final String SHOW_CONVERSATION_INFO_SCREEN = "showConversationInfoScreen";
    public static final String ENABLE_TYPING_INDICATOR = "enableTypingIndicator";
    public static final String APP_REVIEWED = "app_reviewed";
    public static final String SDK_LANGUAGE = "sdkLanguage";
    private static final String TAG = "Helpshift_SDKConfigDM";

    public SDKConfigurationDM(Domain domain, Platform platform) {
        this.domain = domain;
        this.platform = platform;
        this.responseParser = platform.getResponseParser();
        this.kvStore = platform.getKVStore();
    }

    public void fetchServerConfig() {
        String route = "/config/";
        Network network = new GETNetwork(route, this.domain, this.platform);
        network = new TSCorrectedNetwork(network, this.platform);
        network = new ETagNetwork(network, this.platform, route);
        network = new GuardOKNetwork(network);
        Response response = network.makeRequest(new HashMap<String, String>());
        if (response.responseString == null) {
            HSLogger.d(TAG, "SDK config data fetched but nothing to update.");
        } else {
            HSLogger.d(TAG, "SDK config data updated successfully");
            RootServerConfig serverConfig = this.responseParser.parseConfigResponse(response.responseString);
            this.updateServerConfig(serverConfig);
        }
    }

    public void updateServerConfig(RootServerConfig serverConfig) {
        this.kvStore.setBoolean(REQUIRE_NAME_AND_EMAIL, serverConfig.requireNameAndEmail);
        this.kvStore.setBoolean(PROFILE_FORM_ENABLE, serverConfig.profileFormEnable);
        this.kvStore.setBoolean(SHOW_AGENT_NAME, serverConfig.showAgentName);
        this.kvStore.setBoolean(CUSTOMER_SATISFACTION_SURVEY, serverConfig.customerSatisfactionSurvey);
        this.kvStore.setBoolean(DISABLE_IN_APP_CONVERSATION, serverConfig.disableInAppConversation);
        this.kvStore.setBoolean(HELPSHIFT_BRANDING_DISABLE_AGENT, serverConfig.disableHelpshiftBranding);
        this.kvStore.setInt(DEBUG_LOG_LIMIT, serverConfig.debugLogLimit);
        this.kvStore.setInt(BREADCRUMB_LIMIT, serverConfig.breadcrumbLimit);
        this.kvStore.setString(REVIEW_URL, serverConfig.reviewUrl);
        PeriodicReview periodicReview = serverConfig.periodicReview;
        if (periodicReview == null) {
            periodicReview = new PeriodicReview(false, 0, null);
        }
        this.kvStore.setBoolean(PERIODIC_REVIEW_ENABLED, periodicReview.isEnabled);
        this.kvStore.setInt(PERIODIC_REVIEW_INTERVAL, periodicReview.interval);
        this.kvStore.setString(PERIODIC_REVIEW_TYPE, periodicReview.type);
        this.setChanged();
        this.notifyObservers();
    }

    public boolean getBoolean(String key) {
        boolean defaultValue;
        switch (key) {
            case "profileFormEnable": 
            case "showAgentName": 
            case "enableInAppNotification": 
            case "defaultFallbackLanguageEnable": 
            case "showConversationResolutionQuestion": {
                defaultValue = true;
                break;
            }
            default: {
                defaultValue = false;
            }
        }
        return this.kvStore.getBoolean(key, defaultValue);
    }

    public Integer getInt(String key) {
        Integer defaultValue;
        switch (key) {
            case "debugLogLimit": 
            case "breadcrumbLimit": {
                defaultValue = 100;
                break;
            }
            default: {
                defaultValue = null;
            }
        }
        return this.kvStore.getInt(key, defaultValue);
    }

    public String getString(String key) {
        String defaultValue;
        switch (key) {
            case "reviewUrl": 
            case "sdkLanguage": {
                defaultValue = "";
                break;
            }
            case "sdkType": {
                defaultValue = "android";
                break;
            }
            default: {
                defaultValue = null;
            }
        }
        return this.kvStore.getString(key, defaultValue);
    }

    public PeriodicReview getPeriodicReview() {
        boolean enabled = this.kvStore.getBoolean(PERIODIC_REVIEW_ENABLED, false);
        int interval = this.kvStore.getInt(PERIODIC_REVIEW_INTERVAL, 0);
        String type = this.kvStore.getString(PERIODIC_REVIEW_TYPE, "");
        return new PeriodicReview(enabled, interval, type);
    }

    public void updateInstallConfig(Map<String, Object> installConfig) {
        RootInstallConfig rootInstallConfig = new RootInstallConfig.RootInstallConfigBuilder().applyMap(installConfig).build();
        this.updateInstallConfig(rootInstallConfig);
    }

    public void updateInstallConfig(RootInstallConfig rootInstallConfig) {
        if (rootInstallConfig.enableInAppNotification != null) {
            this.kvStore.setBoolean(ENABLE_IN_APP_NOTIFICATION, rootInstallConfig.enableInAppNotification);
        }
        if (rootInstallConfig.enableInboxPolling != null) {
            this.kvStore.setBoolean(INBOX_POLLING_ENABLE, rootInstallConfig.enableInboxPolling);
        }
        if (rootInstallConfig.enableDefaultFallbackLanguage != null) {
            this.kvStore.setBoolean(DEFAULT_FALLBACK_LANGUAGE_ENABLE, rootInstallConfig.enableDefaultFallbackLanguage);
        }
        if (rootInstallConfig.enableNotificationMute != null) {
            this.kvStore.setBoolean(NOTIFICATION_MUTE_ENABLE, rootInstallConfig.enableNotificationMute);
        }
        if (rootInstallConfig.disableAnimations != null) {
            this.kvStore.setBoolean(DISABLE_ANIMATION, rootInstallConfig.disableAnimations);
        }
        if (rootInstallConfig.disableHelpshiftBranding != null) {
            this.kvStore.setBoolean(HELPSHIFT_BRANDING_DISABLE_INSTALL, rootInstallConfig.disableHelpshiftBranding);
        }
        if (rootInstallConfig.disableErrorLogging != null) {
            this.kvStore.setBoolean(DISABLE_ERROR_LOGGING, rootInstallConfig.disableErrorLogging);
        }
        if (rootInstallConfig.notificationSound != null) {
            this.kvStore.setInt(NOTIFICATION_SOUND_ID, rootInstallConfig.notificationSound);
        }
        if (rootInstallConfig.notificationIcon != null) {
            this.kvStore.setInt(NOTIFICATION_ICON_ID, rootInstallConfig.notificationIcon);
        }
        if (rootInstallConfig.largeNotificationIcon != null) {
            this.kvStore.setInt(NOTIFICATION_LARGE_ICON_ID, rootInstallConfig.largeNotificationIcon);
        }
        if (rootInstallConfig.sdkType != null) {
            this.kvStore.setString(SDK_TYPE, rootInstallConfig.sdkType);
        }
        if (rootInstallConfig.pluginVersion != null) {
            this.kvStore.setString(PLUGIN_VERSION, rootInstallConfig.pluginVersion);
        }
        if (rootInstallConfig.runtimeVersion != null) {
            this.kvStore.setString(RUNTIME_VERSION, rootInstallConfig.runtimeVersion);
        }
        this.kvStore.setString(SUPPORT_NOTIFICATION_CHANNEL_ID, rootInstallConfig.supportNotificationChannelId);
        this.kvStore.setString(FONT_PATH, rootInstallConfig.fontPath);
    }

    public void setInstallCredentials(String apiKey, String domainName, String platformId) {
        this.kvStore.setString(API_KEY, apiKey);
        this.kvStore.setString(DOMAIN_NAME, domainName);
        this.kvStore.setString(PLATFORM_ID, platformId);
    }

    public boolean isHelpshiftBrandingDisabled() {
        return this.kvStore.getBoolean(HELPSHIFT_BRANDING_DISABLE_INSTALL, false) != false || this.kvStore.getBoolean(HELPSHIFT_BRANDING_DISABLE_AGENT, false) != false;
    }

    public void updateApiConfig(Map<String, Object> apiConfig) {
        RootApiConfig rootApiConfig = new RootApiConfig.RootApiConfigBuilder().applyMap(apiConfig).build();
        this.updateApiConfig(rootApiConfig);
    }

    public void updateApiConfig(RootApiConfig rootApiConfig) {
        if (rootApiConfig.enableFullPrivacy != null) {
            this.kvStore.setBoolean(ENABLE_FULL_PRIVACY, rootApiConfig.enableFullPrivacy);
        }
        if (rootApiConfig.hideNameAndEmail != null) {
            this.kvStore.setBoolean(HIDE_NAME_AND_EMAIL, rootApiConfig.hideNameAndEmail);
        }
        if (rootApiConfig.requireEmail != null) {
            this.kvStore.setBoolean(REQUIRE_EMAIL, rootApiConfig.requireEmail);
        }
        if (rootApiConfig.showSearchOnNewConversation != null) {
            this.kvStore.setBoolean(SHOW_SEARCH_ON_NEW_CONVERSATION, rootApiConfig.showSearchOnNewConversation);
        }
        if (rootApiConfig.gotoConversationAfterContactUs != null) {
            this.kvStore.setBoolean(GOTO_CONVERSATION_AFTER_CONTACT_US, rootApiConfig.gotoConversationAfterContactUs);
        }
        if (rootApiConfig.showConversationResolutionQuestion != null) {
            this.kvStore.setBoolean(SHOW_CONVERSATION_RESOLUTION_QUESTION, rootApiConfig.showConversationResolutionQuestion);
        }
        if (rootApiConfig.enableContactUs != null) {
            this.kvStore.setInt(ENABLE_CONTACT_US, rootApiConfig.enableContactUs.getValue());
        }
        if (rootApiConfig.showConversationInfoScreen != null) {
            this.kvStore.setBoolean(SHOW_CONVERSATION_INFO_SCREEN, rootApiConfig.showConversationInfoScreen);
        }
        if (rootApiConfig.enableTypingIndicator != null) {
            this.kvStore.setBoolean(ENABLE_TYPING_INDICATOR, rootApiConfig.enableTypingIndicator);
        }
        this.kvStore.setString(CONVERSATION_PRE_FILL_TEXT, rootApiConfig.conversationPrefillText);
    }

    public RootApiConfig.EnableContactUs getEnableContactUs() {
        return RootApiConfig.EnableContactUs.fromInt(this.kvStore.getInt(ENABLE_CONTACT_US, 0));
    }

    public void setAppReviewed(boolean reviewed) {
        this.kvStore.setBoolean(APP_REVIEWED, reviewed);
    }

    public void setSdkLanguage(String sdkLanguage) {
        this.kvStore.setString(SDK_LANGUAGE, sdkLanguage);
    }

    public boolean shouldCreateConversationAnonymously() {
        return this.getBoolean(ENABLE_FULL_PRIVACY) || (!this.getBoolean(REQUIRE_NAME_AND_EMAIL) || !this.getBoolean(HIDE_NAME_AND_EMAIL)) && !this.getBoolean(PROFILE_FORM_ENABLE);
    }

    public int getMinimumConversationDescriptionLength() {
        return this.platform.getMinimumConversationDescriptionLength();
    }
}

