/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.controllers;

import android.os.Handler;
import android.os.HandlerThread;
import com.helpshift.app.LifecycleListener;
import com.helpshift.common.poller.Delay;
import com.helpshift.common.poller.HttpBackoff;
import com.helpshift.controllers.DataSyncCompletionListener;
import com.helpshift.listeners.SyncListener;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.specifications.DecayingIntervalSyncSpecification;
import com.helpshift.specifications.SyncSpecification;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.TimeUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class SyncController
implements LifecycleListener,
DataSyncCompletionListener {
    private static final String TAG = "Helpshift_SyncControl";
    static final String COUNT = "count";
    static final String SYNC_TIME = "sync_time";
    static final String FULL_SYNC_TIME = "full_sync_time";
    private final TimeUtil timeUtil;
    private final KeyValueStorage keyValueStorage;
    private final LinkedBlockingQueue<SyncListener> syncListeners = new LinkedBlockingQueue();
    static final long FULL_SYNC_TIME_THRESHOLD = 86400000L;
    private final Map<String, SyncSpecification> syncSpecificationMap = new HashMap<String, SyncSpecification>();
    private AtomicBoolean isBatcherScheduled = new AtomicBoolean(false);
    private static final long REALTIME_SYNC_BATCHER_DELAY_MS = 60000L;
    private static final int MAX_RETRY_ATTEMPTS = 10;
    Set<String> dataTypesWithChangedData;
    private Handler handler;
    private Runnable batcherJob;
    private HttpBackoff retryBackoff;

    public SyncController(KeyValueStorage keyValueStorage, TimeUtil timeUtil, SyncSpecification ... syncSpecifications) {
        this.keyValueStorage = keyValueStorage;
        this.timeUtil = timeUtil;
        HelpshiftContext.getMainLifecycleCallback().addLifecycleListener(this);
        for (SyncSpecification syncSpecification : syncSpecifications) {
            this.syncSpecificationMap.put(syncSpecification.getDataType(), syncSpecification);
        }
    }

    private Runnable getBatcherJob() {
        if (this.batcherJob == null) {
            this.batcherJob = new Runnable(){

                @Override
                public void run() {
                    if (SyncController.this.dataTypesWithChangedData != null) {
                        SyncController.this.triggerSync(false, SyncController.this.dataTypesWithChangedData.toArray(new String[SyncController.this.dataTypesWithChangedData.size()]));
                    }
                    SyncController.this.cleanUpBatcherJob();
                }
            };
        }
        return this.batcherJob;
    }

    public void addSpecification(SyncSpecification syncSpecification) {
        this.syncSpecificationMap.put(syncSpecification.getDataType(), syncSpecification);
    }

    public void addSyncListeners(SyncListener ... listeners) {
        for (SyncListener listener : listeners) {
            if (!this.syncSpecificationMap.containsKey(listener.getDataType())) continue;
            this.syncListeners.add(listener);
        }
    }

    void triggerSync(boolean checkSyncSpecification, String ... dataTypes) {
        for (String dataType : dataTypes) {
            HSLogger.d(TAG, "Triggering sync for  type : " + dataType);
            if (this.isFullSyncSatisfied(dataType)) {
                this.dispatchSync(dataType, true);
                continue;
            }
            if (checkSyncSpecification) {
                SyncSpecification specification = this.syncSpecificationMap.get(dataType);
                if (specification == null || !specification.isSatisfied(this.getDataChangeCount(dataType), this.getElapsedTimeSinceLastSync(dataType))) continue;
                this.dispatchSync(dataType, false);
                continue;
            }
            this.dispatchSync(dataType, false);
        }
    }

    private void dispatchSync(String dataType, boolean isFullSync) {
        HSLogger.d(TAG, "Dispatching sync for type :" + dataType + ", isFullSync : " + isFullSync);
        SyncListener syncListener = this.getSyncListener(dataType);
        if (syncListener != null) {
            if (isFullSync) {
                syncListener.fullSync();
            } else {
                syncListener.sync();
            }
        }
    }

    private SyncListener getSyncListener(String dataType) {
        SyncListener syncListener = null;
        for (SyncListener listener : this.syncListeners) {
            if (!listener.getDataType().equals(dataType)) continue;
            syncListener = listener;
            break;
        }
        return syncListener;
    }

    public void scheduleSync(String dataType, long delay) {
        HSLogger.d(TAG, "Scheduling sync : " + dataType + ", Delay : " + delay);
        if (this.isDataTypeAllowedForImmediateSync(dataType)) {
            if (this.isBatcherScheduled.compareAndSet(false, true)) {
                this.startBatcherThread();
                this.handler.postDelayed(this.getBatcherJob(), delay);
            }
            this.addDataTypeWithChangedData(dataType);
        }
    }

    private void onDataChanged(String dataType) {
        this.scheduleSync(dataType, 60000L);
    }

    public void incrementDataChangeCount(String dataType, int count) {
        if (count <= 0) {
            return;
        }
        HashMap<String, String> information = this.getSyncInformation(dataType);
        int previousCount = Integer.valueOf(information.get(COUNT));
        information.put(COUNT, Integer.toString(previousCount + count));
        this.keyValueStorage.set(dataType, information);
        this.onDataChanged(dataType);
    }

    public void setDataChangeCount(String dataType, int count) {
        HashMap<String, String> information = this.getSyncInformation(dataType);
        int previousCount = Integer.valueOf(information.get(COUNT));
        information.put(COUNT, Integer.toString(count));
        this.keyValueStorage.set(dataType, information);
        if (previousCount != count && count > 0) {
            this.onDataChanged(dataType);
        }
    }

    public void dataSynced(String dataType, boolean isFullSync) {
        HSLogger.d(TAG, "Data sync complete : " + dataType + ", Full sync : " + isFullSync);
        String currentElapsedTime = Long.toString(this.timeUtil.elapsedTimeMillis());
        HashMap<String, String> information = this.getSyncInformation(dataType);
        information.put(COUNT, Integer.toString(0));
        information.put(SYNC_TIME, currentElapsedTime);
        if (isFullSync) {
            information.put(FULL_SYNC_TIME, currentElapsedTime);
        }
        this.keyValueStorage.set(dataType, information);
        if (this.retryBackoff != null) {
            this.retryBackoff.reset();
        }
    }

    public void dataSyncFailed(String dataType, NetworkError networkError) {
        HSLogger.w(TAG, "Data sync failed : " + dataType + ", Error : " + networkError.getMessage());
        SyncSpecification specification = this.syncSpecificationMap.get(dataType);
        if (specification != null) {
            switch (dataType) {
                case "data_type_switch_user": 
                case "data_type_analytics_event": {
                    if (!(specification instanceof DecayingIntervalSyncSpecification)) break;
                    ((DecayingIntervalSyncSpecification)specification).decayElapsedTimeThreshold();
                }
            }
        }
        if (this.retryBackoff == null) {
            this.retryBackoff = new HttpBackoff.Builder().setBaseInterval(Delay.of(5L, TimeUnit.SECONDS)).setMaxAttempts(10).setRetryPolicy(HttpBackoff.RetryPolicy.FAILURE).build();
        }
        long delay = -100L;
        Integer statusCode = networkError.getReason();
        if (statusCode != null) {
            delay = this.retryBackoff.nextIntervalMillis(statusCode);
        }
        if (delay != -100L) {
            this.scheduleSync(dataType, delay);
        }
    }

    private int getDataChangeCount(String dataType) {
        return Integer.valueOf(this.getSyncInformation(dataType).get(COUNT));
    }

    private long getElapsedTimeSinceLastSync(String dataType) {
        return this.timeUtil.elapsedTimeMillis() - Long.valueOf(this.getSyncInformation(dataType).get(SYNC_TIME));
    }

    private long getElapsedTimeSinceFullSync(String dataType) {
        return this.timeUtil.elapsedTimeMillis() - Long.valueOf(this.getSyncInformation(dataType).get(FULL_SYNC_TIME));
    }

    private HashMap<String, String> getSyncInformation(String dataType) {
        HashMap<String, String> information = (HashMap<String, String>)this.keyValueStorage.get(dataType);
        boolean isInfoChange = false;
        if (information == null) {
            information = new HashMap<String, String>();
            information.put(COUNT, Integer.toString(0));
            information.put(SYNC_TIME, Long.toString(0L));
            information.put(FULL_SYNC_TIME, Long.toString(0L));
            isInfoChange = true;
        } else if (this.timeUtil.elapsedTimeMillis() < Long.valueOf((String)information.get(SYNC_TIME))) {
            information.put(SYNC_TIME, Long.toString(0L));
            information.put(FULL_SYNC_TIME, Long.toString(0L));
            isInfoChange = true;
        }
        if (!information.containsKey(FULL_SYNC_TIME)) {
            information.put(FULL_SYNC_TIME, Long.toString(0L));
            isInfoChange = true;
        }
        if (isInfoChange) {
            this.keyValueStorage.set(dataType, information);
        }
        return information;
    }

    public boolean isFullSyncSatisfied(String dataType) {
        SyncListener syncListener = this.getSyncListener(dataType);
        return syncListener != null && syncListener.isFullSyncEnabled() && this.getElapsedTimeSinceFullSync(dataType) > 86400000L;
    }

    @Override
    public void switchUserComplete(String userId) {
        this.retryForDependentDataTypes(this.getSyncListener("data_type_switch_user"));
    }

    @Override
    public void firstDeviceSyncComplete() {
        this.retryForDependentDataTypes(this.getSyncListener("data_type_device"));
    }

    private void retryForDependentDataTypes(SyncListener syncListener) {
        Set<String> dependentSyncDataTypes;
        if (syncListener != null && (dependentSyncDataTypes = syncListener.getDependentChildDataTypes()) != null) {
            for (String dependentDataType : dependentSyncDataTypes) {
                this.triggerSync(false, dependentDataType);
            }
        }
    }

    public Set<String> getDataTypesWithChangedData() {
        return this.dataTypesWithChangedData;
    }

    private void addDataTypeWithChangedData(String dataType) {
        if (this.dataTypesWithChangedData == null) {
            this.dataTypesWithChangedData = new HashSet<String>();
        }
        this.dataTypesWithChangedData.add(dataType);
    }

    @Override
    public void onForeground() {
        this.triggerSync(true, "data_type_switch_user", "data_type_user", "data_type_analytics_event");
    }

    @Override
    public void onBackground() {
        this.cancelBatcherJob();
        this.triggerSync(true, "data_type_switch_user", "data_type_device", "data_type_user", "data_type_session", "data_type_analytics_event");
    }

    private void startBatcherThread() {
        if (this.handler == null) {
            HandlerThread batcherThread = new HandlerThread("HS-cm-agg-sync");
            batcherThread.start();
            this.handler = new Handler(batcherThread.getLooper());
        }
    }

    void cleanUpBatcherJob() {
        this.isBatcherScheduled.compareAndSet(true, false);
        if (this.dataTypesWithChangedData != null) {
            this.dataTypesWithChangedData.clear();
        }
    }

    private void cancelBatcherJob() {
        this.cleanUpBatcherJob();
        if (this.handler != null && this.batcherJob != null) {
            this.handler.removeCallbacks(this.getBatcherJob());
        }
    }

    private boolean isDataTypeAllowedForImmediateSync(String dataType) {
        return dataType.equals("data_type_user") || dataType.equals("data_type_analytics_event") || dataType.equals("data_type_device") && InfoModelFactory.getInstance().sdkInfoModel.getDevicePropertiesSyncImmediately() != false || dataType.equals("data_type_switch_user");
    }

    public static class DataTypes {
        public static final String DEVICE = "data_type_device";
        public static final String USER = "data_type_user";
        public static final String SESSION = "data_type_session";
        public static final String SWITCH_USER = "data_type_switch_user";
        public static final String ANALYTICS_EVENT = "data_type_analytics_event";
    }
}

