/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation;

import com.helpshift.account.domainmodel.ProfileDM;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Poller;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.util.HSLogger;
import java.util.Observable;
import java.util.Observer;

public class ConversationInboxPoller
implements Observer {
    private final ProfileDM profileDM;
    private final SDKConfigurationDM sdkConfigurationDM;
    public final Poller poller;
    private ConversationInboxPollerState pollerState;
    private static final String TAG = "Helpshift_ConvPoller";

    public ConversationInboxPoller(ProfileDM profileDM, SDKConfigurationDM sdkConfigurationDM, Poller poller) {
        this.profileDM = profileDM;
        this.sdkConfigurationDM = sdkConfigurationDM;
        this.poller = poller;
        profileDM.addObserver(this);
    }

    public void refreshPollerOnAppForeground() {
        if (this.pollerState == ConversationInboxPollerState.CHAT) {
            this.startChatPoller();
        } else if (this.pollerState == ConversationInboxPollerState.SDK) {
            this.startSDKPoller();
        } else {
            this.startOrStopInAppPoller();
        }
    }

    public void startOrStopInAppPoller() {
        if (!(StringUtils.isEmpty(this.profileDM.serverId) || this.profileDM.isPushTokenSynced || this.sdkConfigurationDM.getBoolean("disableInAppConversation"))) {
            HSLogger.d(TAG, "Listening for in-app conversation updates");
            this.poller.start(Poller.ActivePollingInterval.CONSERVATIVE);
        } else {
            this.stop();
        }
        this.pollerState = ConversationInboxPollerState.IN_APP;
    }

    public void startSDKPoller() {
        if (!StringUtils.isEmpty(this.profileDM.serverId)) {
            HSLogger.d(TAG, "Listening for in-sdk conversation updates");
            this.poller.start(Poller.ActivePollingInterval.CONSERVATIVE);
            this.pollerState = ConversationInboxPollerState.SDK;
        }
    }

    public void startChatPoller() {
        if (!StringUtils.isEmpty(this.profileDM.serverId)) {
            HSLogger.d(TAG, "Listening for in-chat conversation updates");
            this.poller.start(Poller.ActivePollingInterval.AGGRESSIVE);
            this.pollerState = ConversationInboxPollerState.CHAT;
        }
    }

    public void stop() {
        HSLogger.d(TAG, "Stopped listening for in-app conversation updates");
        this.poller.stop();
    }

    @Override
    public void update(Observable observable, Object o) {
        if (this.pollerState == ConversationInboxPollerState.CHAT || this.pollerState == ConversationInboxPollerState.SDK) {
            return;
        }
        this.startOrStopInAppPoller();
    }

    private static enum ConversationInboxPollerState {
        IN_APP,
        SDK,
        CHAT;

    }
}

