/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation;

import com.helpshift.account.domainmodel.ProfileDM;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.AutoRetryFailedEventDM;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.network.FailedAPICallNetworkDecorator;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.MetaCorrectedNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.common.util.HSObservableList;
import com.helpshift.common.util.ListObserver;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.conversation.activeconversation.LiveUpdateDM;
import com.helpshift.conversation.activeconversation.message.AcceptedAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminMessageDM;
import com.helpshift.conversation.activeconversation.message.AttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AutoRetriableMessageDM;
import com.helpshift.conversation.activeconversation.message.ConfirmationAcceptedMessageDM;
import com.helpshift.conversation.activeconversation.message.ConfirmationRejectedMessageDM;
import com.helpshift.conversation.activeconversation.message.FollowupAcceptedMessageDM;
import com.helpshift.conversation.activeconversation.message.FollowupRejectedMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.activeconversation.message.RequestAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestForReopenMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.ScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.UserMessageDM;
import com.helpshift.conversation.dao.ConversationDAO;
import com.helpshift.conversation.dto.ConversationStatus;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.conversation.states.ConversationCSATState;
import com.helpshift.conversation.viewmodel.ConversationVMCallback;
import com.helpshift.meta.MetaDataDM;
import com.helpshift.meta.dto.UserInfo;
import com.helpshift.util.HSLogger;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public class ConversationDM
implements Observer,
LiveUpdateDM.TypingIndicatorListener {
    public Long localId;
    public String serverId;
    public String title;
    public ConversationStatus status;
    public String createdAt;
    public String updatedAt;
    public HSObservableList<MessageDM> messageDMs = new HSObservableList();
    private final Map<String, MessageDM> unansweredRequestForReopenMessageDMs = new HashMap<String, MessageDM>();
    private final List<MessageDM> acceptedRequestForReopenMessageDMs = new ArrayList<MessageDM>();
    public String publishId;
    public boolean showAgentName;
    public ConversationVMCallback conversationVMCallback;
    public String messageCursor;
    public boolean shouldIncrementMessageCount;
    public boolean isConversationEndedDelegateSent;
    public ConversationCSATState csatState = ConversationCSATState.NONE;
    public int csatRating;
    public String csatFeedback;
    public boolean isStartNewConversationClicked;
    public long profileLocalId;
    Platform platform;
    Domain domain;
    ProfileDM profileDM;
    private ResponseParser responseParser;
    private ConversationDAO conversationDAO;
    private MetaDataDM metaDataDM;
    private SDKConfigurationDM sdkConfigurationDM;
    private LiveUpdateDM liveUpdateDM;
    private boolean enableMessageClickOnResolutionRejected;
    private Comparator<MessageDM> sortMessagesComparator;
    private static final String TAG = "Helpshift_ConvDM";

    public ConversationDM(String serverId, String title, ConversationStatus status, String createdAt, String updatedAt, String publishId, String messageCursor, boolean showAgentName) {
        this.serverId = serverId;
        this.title = title;
        this.createdAt = createdAt;
        this.status = status;
        this.updatedAt = updatedAt;
        this.publishId = publishId;
        this.messageCursor = messageCursor;
        this.showAgentName = showAgentName;
    }

    public ConversationDM(Platform platform, Domain domain, ProfileDM profileDM, LiveUpdateDM liveUpdateDM) {
        this.setDependencies(platform, domain, profileDM);
        this.setLiveUpdateDM(liveUpdateDM);
    }

    public void setDependencies(Platform platform, Domain domain, ProfileDM profileDM) {
        this.platform = platform;
        this.domain = domain;
        this.profileDM = profileDM;
        this.responseParser = platform.getResponseParser();
        this.conversationDAO = platform.getConversationDAO();
        this.metaDataDM = domain.getMetaDataDM();
        this.sdkConfigurationDM = domain.getSDKConfigurationDM();
        this.profileLocalId = profileDM.localId;
    }

    public void setLiveUpdateDM(LiveUpdateDM liveUpdateDM) {
        this.liveUpdateDM = liveUpdateDM;
    }

    public void registerMessagesObserver(ListObserver observer) {
        this.messageDMs.setObserver(observer);
        for (MessageDM messageDM : this.messageDMs) {
            messageDM.addObserver(this);
        }
    }

    public void createConversation(String description, String name, String email, String uid, String did) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("profile-id", this.profileDM.serverId);
        data.put("message-text", description);
        data.put("uid", uid);
        data.put("did", did);
        UserInfo userInfo = new UserInfo(name, email);
        data.put("meta", this.metaDataDM.getMetaInfo(this.profileDM.getUserIdentifier(), this.profileDM.pushToken, userInfo).toString());
        Object customIssueFields = this.domain.getCustomIssueFieldDM().getCustomIssueFieldData();
        if (customIssueFields != null) {
            data.put("custom_fields", customIssueFields.toString());
        }
        Network startConversationNetwork = new POSTNetwork("/issues/", this.domain, this.platform);
        startConversationNetwork = new TSCorrectedNetwork(startConversationNetwork, this.platform);
        startConversationNetwork = new MetaCorrectedNetwork(startConversationNetwork, this.platform);
        startConversationNetwork = new GuardOKNetwork(startConversationNetwork);
        Response response = startConversationNetwork.makeRequest(data);
        ConversationDM conversation = this.responseParser.parseReadableConversation(response.responseString);
        this.serverId = conversation.serverId;
        this.title = conversation.title;
        this.status = conversation.status;
        this.createdAt = conversation.createdAt;
        this.updatedAt = conversation.updatedAt;
        this.messageDMs = conversation.messageDMs;
        this.publishId = conversation.publishId;
        this.showAgentName = conversation.showAgentName;
        this.conversationDAO.insertOrUpdateConversation(this);
    }

    public void retryMessage(MessageDM messageDM) {
        if (messageDM instanceof UserMessageDM) {
            this.sendTextMessage((UserMessageDM)messageDM);
        } else if (messageDM instanceof ScreenshotMessageDM) {
            this.sendScreenshotMessageInternal((ScreenshotMessageDM)messageDM, false);
        }
    }

    public void sendTextMessage(String reply) {
        String createdAt = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
        UserMessageDM userMessageDM = new UserMessageDM(reply, createdAt, "mobile");
        userMessageDM.conversationLocalId = this.localId;
        userMessageDM.updateState(this.shouldEnableMessagesClick());
        this.addMessageToDbAndUI(userMessageDM);
        this.sendTextMessage(userMessageDM);
    }

    private void sendTextMessage(UserMessageDM userMessageDM) {
        try {
            userMessageDM.send(this.profileDM.serverId, this.serverId);
            if (this.status == ConversationStatus.RESOLUTION_REJECTED) {
                this.updateConversationStatus(ConversationStatus.IN_PROGRESS);
            }
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.CONVERSATION_ARCHIVED) {
                this.updateConversationStatus(ConversationStatus.ARCHIVED);
            }
            throw e;
        }
    }

    public void handleAppReviewRequestClick(final RequestAppReviewMessageDM requestAppReviewMessageDM) {
        final AcceptedAppReviewMessageDM acceptedAppReviewMessageDM = requestAppReviewMessageDM.handleRequestReviewClick(this.domain, this.platform);
        if (acceptedAppReviewMessageDM != null) {
            this.sendMessageWithAutoRetry(new F(){

                @Override
                public void f() {
                    try {
                        acceptedAppReviewMessageDM.send(ConversationDM.this.profileDM.serverId, ConversationDM.this.serverId);
                        requestAppReviewMessageDM.handleAcceptedReviewSuccess(ConversationDM.this.platform);
                        ConversationDM.this.addMessageToUI(acceptedAppReviewMessageDM);
                    }
                    catch (RootAPIException e) {
                        if (e.exceptionType == NetworkException.CONVERSATION_ARCHIVED) {
                            ConversationDM.this.updateConversationStatus(ConversationStatus.ARCHIVED);
                        }
                        requestAppReviewMessageDM.setIsReviewButtonClickable(true);
                        throw e;
                    }
                }
            });
        }
    }

    public void initializeConversationStatusForUI() {
        if (this.status == ConversationStatus.RESOLUTION_REQUESTED && !this.sdkConfigurationDM.getBoolean("showConversationResolutionQuestion")) {
            this.markConversationResolutionStatus(true);
        }
    }

    public void updateConversationStatus(ConversationStatus newStatus) {
        if (this.status == newStatus) {
            return;
        }
        HSLogger.d(TAG, "Changing conversation status from: " + (Object)((Object)this.status) + ", new status: " + (Object)((Object)newStatus) + ", for: " + this.serverId);
        this.status = newStatus;
        boolean updateConversationOnUIAndDB = true;
        switch (this.status) {
            case ARCHIVED: {
                ArrayList<UserMessageDM> unsentUserMessages = new ArrayList<UserMessageDM>();
                List<MessageDM> allMessages = this.conversationDAO.readMessages(this.localId);
                for (MessageDM message : allMessages) {
                    if (!(message instanceof UserMessageDM) || message.serverId != null) continue;
                    unsentUserMessages.add((UserMessageDM)message);
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (UserMessageDM message : unsentUserMessages) {
                    stringBuilder.append(message.body);
                    stringBuilder.append("\n");
                }
                this.platform.getConversationInboxDAO().saveConversationArchivalPrefillText(this.profileDM.localId, stringBuilder.toString());
                this.sendConversationEndedDelegate();
                break;
            }
            case RESOLUTION_REQUESTED: {
                if (this.sdkConfigurationDM.getBoolean("showConversationResolutionQuestion")) break;
                updateConversationOnUIAndDB = false;
                this.markConversationResolutionStatus(true);
                break;
            }
            case RESOLUTION_ACCEPTED: {
                this.sendConversationEndedDelegate();
            }
        }
        if (updateConversationOnUIAndDB) {
            this.updateMessagesOnConversationStatusUpdate();
            if (this.conversationVMCallback != null) {
                this.conversationVMCallback.onConversationStatusChange(newStatus);
            }
            this.conversationDAO.insertOrUpdateConversationWithoutMessages(this);
        }
    }

    public void dropCustomMetaData() {
        this.metaDataDM.setCustomMetaDataCallable(null);
        this.metaDataDM.clearCustomMetaData();
    }

    public void setLocalId(long localId) {
        this.localId = localId;
        for (MessageDM messageDM : this.messageDMs) {
            messageDM.conversationLocalId = localId;
        }
    }

    public void sendConversationEndedDelegate() {
        if (!this.isConversationEndedDelegateSent) {
            this.domain.getDelegate().conversationEnded();
            this.isConversationEndedDelegateSent = true;
            this.conversationDAO.insertOrUpdateConversationWithoutMessages(this);
        }
    }

    public void initializeMessagesForUI() {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                Iterator iterator = ConversationDM.this.messageDMs.iterator();
                while (iterator.hasNext()) {
                    MessageDM messageDM = (MessageDM)iterator.next();
                    if (messageDM.isUISupportedMessage()) {
                        messageDM.setDependencies(ConversationDM.this.domain, ConversationDM.this.platform);
                        messageDM.shouldShowAgentNameForConversation = ConversationDM.this.showAgentName;
                        if (messageDM instanceof AdminImageAttachmentMessageDM) {
                            ((AdminImageAttachmentMessageDM)messageDM).downloadThumbnailImage(ConversationDM.this.platform);
                        }
                        ConversationDM.this.updateMessageOnConversationUpdate(messageDM, ConversationDM.this.shouldEnableMessagesClick());
                        continue;
                    }
                    ConversationDM.this.filterAcceptedRequestForReopenMessageDMs(messageDM);
                    iterator.remove();
                }
                ConversationDM.this.populateAcceptedRequestForReopenMessageDMs();
                ConversationDM.this.sortMessageDMs();
            }
        });
    }

    public void setCSATData(int csatRating, ConversationCSATState csatState, String csatFeedback) {
        this.csatRating = csatRating;
        this.csatState = csatState;
        this.csatFeedback = csatFeedback;
    }

    public boolean shouldOpen() {
        boolean shouldOpen = false;
        switch (this.status) {
            case RESOLUTION_REQUESTED: 
            case NEW: 
            case IN_PROGRESS: {
                shouldOpen = true;
                break;
            }
            case ARCHIVED: 
            case RESOLUTION_ACCEPTED: 
            case RESOLUTION_REJECTED: {
                shouldOpen = !this.isStartNewConversationClicked;
                break;
            }
            case REJECTED: {
                shouldOpen = false;
            }
        }
        return shouldOpen;
    }

    @Override
    public void update(Observable observable, Object arg) {
        if (observable instanceof MessageDM) {
            final MessageDM messageDM = (MessageDM)observable;
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    int index = ConversationDM.this.messageDMs.indexOf(messageDM);
                    ConversationDM.this.messageDMs.setAndNotifyObserver(index, messageDM);
                }
            });
        }
    }

    private void updateMessagesOnConversationStatusUpdate() {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                boolean isClickable = ConversationDM.this.shouldEnableMessagesClick();
                for (MessageDM messageDM : ConversationDM.this.messageDMs) {
                    ConversationDM.this.updateMessageOnConversationUpdate(messageDM, isClickable);
                }
            }
        });
    }

    void updateMessageOnConversationUpdate(MessageDM messageDM, boolean isClickable) {
        if (messageDM instanceof UserMessageDM) {
            UserMessageDM userMessageDM = (UserMessageDM)messageDM;
            userMessageDM.updateState(isClickable);
        } else if (messageDM instanceof ScreenshotMessageDM) {
            ScreenshotMessageDM screenshotMessageDM = (ScreenshotMessageDM)messageDM;
            screenshotMessageDM.updateState(isClickable);
            screenshotMessageDM.checkAndReDownloadImageIfNotExist(this.platform);
        } else if (messageDM instanceof RequestScreenshotMessageDM) {
            RequestScreenshotMessageDM requestScreenshotMessageDM = (RequestScreenshotMessageDM)messageDM;
            requestScreenshotMessageDM.setAttachmentButtonClickable(isClickable);
        }
    }

    boolean shouldEnableMessagesClick() {
        boolean result = false;
        switch (this.status) {
            case NEW: 
            case IN_PROGRESS: 
            case REJECTED: {
                result = true;
                break;
            }
            case ARCHIVED: 
            case RESOLUTION_REQUESTED: 
            case RESOLUTION_ACCEPTED: {
                result = false;
                break;
            }
            case RESOLUTION_REJECTED: {
                result = this.enableMessageClickOnResolutionRejected;
            }
        }
        return result;
    }

    private void addMessageToDbAndUI(MessageDM messageDM) {
        this.conversationDAO.insertOrUpdateMessage(messageDM);
        this.addMessageToUI(messageDM);
    }

    void addMessageToUI(final MessageDM messageDM) {
        messageDM.setDependencies(this.domain, this.platform);
        if (messageDM.isUISupportedMessage()) {
            messageDM.addObserver(this);
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    ConversationDM.this.messageDMs.add(messageDM);
                    ConversationDM.this.sortMessageDMs();
                }
            });
        }
    }

    public void sendScreenshot(ImagePickerFile imagePickerFile, final String refersId) {
        String createdAt = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
        ScreenshotMessageDM screenshotMessageDM = new ScreenshotMessageDM(null, createdAt, "mobile", null, null, null, null, 0);
        screenshotMessageDM.fileName = imagePickerFile.originalFileName;
        screenshotMessageDM.filePath = imagePickerFile.filePath;
        screenshotMessageDM.setRefersMessageId(refersId);
        screenshotMessageDM.updateState(this.shouldEnableMessagesClick());
        screenshotMessageDM.conversationLocalId = this.localId;
        this.addMessageToDbAndUI(screenshotMessageDM);
        if (refersId != null) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    for (MessageDM messageDM : ConversationDM.this.messageDMs) {
                        if (messageDM.serverId == null || !messageDM.serverId.equals(refersId) || messageDM.messageType != MessageType.REQUESTED_SCREENSHOT) continue;
                        RequestScreenshotMessageDM requestScreenshotMessageDM = (RequestScreenshotMessageDM)messageDM;
                        requestScreenshotMessageDM.setIsAnswered(ConversationDM.this.platform, true);
                        break;
                    }
                }
            });
        }
        this.sendScreenshotMessageInternal(screenshotMessageDM, !imagePickerFile.isFileCompressionAndCopyingDone);
    }

    private void sendScreenshotMessageInternal(ScreenshotMessageDM screenshotMessageDM, boolean shouldCompressImage) {
        try {
            screenshotMessageDM.uploadImage(this.profileDM.serverId, this.serverId, shouldCompressImage);
            if (this.status == ConversationStatus.RESOLUTION_REJECTED) {
                this.updateConversationStatus(ConversationStatus.IN_PROGRESS);
            }
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.CONVERSATION_ARCHIVED) {
                this.updateConversationStatus(ConversationStatus.ARCHIVED);
            }
            throw e;
        }
    }

    public void onAdminAttachmentMessageClicked(AttachmentMessageDM message) {
        switch (message.messageType) {
            case ADMIN_IMAGE_ATTACHMENT: {
                AdminImageAttachmentMessageDM imageAttachmentMessageDM = (AdminImageAttachmentMessageDM)message;
                imageAttachmentMessageDM.handleClick(this.platform, this.conversationVMCallback);
                break;
            }
            case ADMIN_ATTACHMENT: {
                AdminAttachmentMessageDM attachmentMessageDM = (AdminAttachmentMessageDM)message;
                attachmentMessageDM.handleClick(this.platform, this.conversationVMCallback);
            }
        }
    }

    void updateUIMessageDMs(final List<MessageDM> updatedMessageDMs) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                HashMap<String, MessageDM> updatedMessagesLookup = new HashMap<String, MessageDM>();
                for (MessageDM updatedMessageDM : updatedMessageDMs) {
                    updatedMessagesLookup.put(updatedMessageDM.serverId, updatedMessageDM);
                }
                for (MessageDM messageDM : ConversationDM.this.messageDMs) {
                    String messageServerId = messageDM.serverId;
                    if (!updatedMessagesLookup.containsKey(messageServerId)) continue;
                    messageDM.mergeAndNotify((MessageDM)updatedMessagesLookup.remove(messageServerId));
                }
                ArrayList newMessages = new ArrayList(updatedMessagesLookup.values());
                for (MessageDM newMessage : newMessages) {
                    if (newMessage.isUISupportedMessage()) {
                        newMessage.setDependencies(ConversationDM.this.domain, ConversationDM.this.platform);
                        newMessage.shouldShowAgentNameForConversation = ConversationDM.this.showAgentName;
                        switch (newMessage.messageType) {
                            case ADMIN_TEXT: {
                                AdminMessageDM adminMessageDM = (AdminMessageDM)newMessage;
                                adminMessageDM.conversationLocalId = ConversationDM.this.localId;
                                newMessage.addObserver(ConversationDM.this);
                                ConversationDM.this.messageDMs.add(adminMessageDM);
                                break;
                            }
                            case ADMIN_ATTACHMENT: 
                            case REQUESTED_SCREENSHOT: 
                            case REQUESTED_APP_REVIEW: {
                                newMessage.conversationLocalId = ConversationDM.this.localId;
                                newMessage.addObserver(ConversationDM.this);
                                ConversationDM.this.messageDMs.add(newMessage);
                                break;
                            }
                            case ADMIN_IMAGE_ATTACHMENT: {
                                newMessage.conversationLocalId = ConversationDM.this.localId;
                                newMessage.addObserver(ConversationDM.this);
                                ConversationDM.this.messageDMs.add(newMessage);
                                ((AdminImageAttachmentMessageDM)newMessage).downloadThumbnailImage(ConversationDM.this.platform);
                            }
                        }
                        continue;
                    }
                    ConversationDM.this.filterAcceptedRequestForReopenMessageDMs(newMessage);
                }
                ConversationDM.this.populateAcceptedRequestForReopenMessageDMs();
                ConversationDM.this.sortMessageDMs();
            }
        });
    }

    void filterAcceptedRequestForReopenMessageDMs(MessageDM messageDM) {
        String referredMessageId;
        if (messageDM instanceof RequestForReopenMessageDM) {
            this.unansweredRequestForReopenMessageDMs.put(messageDM.serverId, messageDM);
        } else if (messageDM instanceof FollowupAcceptedMessageDM && this.unansweredRequestForReopenMessageDMs.containsKey(referredMessageId = ((FollowupAcceptedMessageDM)messageDM).referredMessageId)) {
            MessageDM acceptedRequestForReopenMessageDM = this.unansweredRequestForReopenMessageDMs.remove(referredMessageId);
            acceptedRequestForReopenMessageDM.setDependencies(this.domain, this.platform);
            acceptedRequestForReopenMessageDM.shouldShowAgentNameForConversation = this.showAgentName;
            ((RequestForReopenMessageDM)acceptedRequestForReopenMessageDM).isAnswered = true;
            this.conversationDAO.insertOrUpdateMessage(acceptedRequestForReopenMessageDM);
            this.acceptedRequestForReopenMessageDMs.add(acceptedRequestForReopenMessageDM);
        }
    }

    void populateAcceptedRequestForReopenMessageDMs() {
        this.messageDMs.addAll((Collection<MessageDM>)this.acceptedRequestForReopenMessageDMs);
        this.acceptedRequestForReopenMessageDMs.clear();
    }

    void sortMessageDMs() {
        if (this.sortMessagesComparator == null) {
            this.sortMessagesComparator = new Comparator<MessageDM>(){

                @Override
                public int compare(MessageDM m1, MessageDM m2) {
                    try {
                        Date m1Date = HSDateFormatSpec.STORAGE_TIME_FORMAT.parse(m1.createdAt);
                        Date m2Date = HSDateFormatSpec.STORAGE_TIME_FORMAT.parse(m2.createdAt);
                        if (m1Date.after(m2Date)) {
                            return 1;
                        }
                        if (m1Date.before(m2Date)) {
                            return -1;
                        }
                        return 0;
                    }
                    catch (ParseException e) {
                        return 0;
                    }
                }
            };
        }
        this.messageDMs.sortWithComparator(this.sortMessagesComparator);
    }

    public void setMessageDMs(List<MessageDM> messageDMs) {
        this.messageDMs = new HSObservableList<MessageDM>(messageDMs);
        if (this.status == ConversationStatus.RESOLUTION_REQUESTED && messageDMs != null && messageDMs.size() > 0) {
            MessageDM lastMessage = null;
            for (int last = messageDMs.size() - 1; last >= 0 && ((lastMessage = messageDMs.get(last)) instanceof FollowupRejectedMessageDM || lastMessage instanceof RequestForReopenMessageDM); --last) {
            }
            if (lastMessage instanceof ConfirmationAcceptedMessageDM) {
                this.status = ConversationStatus.RESOLUTION_ACCEPTED;
            } else if (lastMessage instanceof ConfirmationRejectedMessageDM) {
                this.status = ConversationStatus.RESOLUTION_REJECTED;
            }
        }
    }

    public void markConversationResolutionStatus(boolean accepted) {
        String createdAt = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
        if (accepted) {
            String body = "Accepted the solution";
            final ConfirmationAcceptedMessageDM messageDM = new ConfirmationAcceptedMessageDM(body, createdAt, "mobile");
            messageDM.setDependencies(this.domain, this.platform);
            messageDM.conversationLocalId = this.localId;
            this.conversationDAO.insertOrUpdateMessage(messageDM);
            this.sendMessageWithAutoRetry(new F(){

                @Override
                public void f() {
                    try {
                        messageDM.send(ConversationDM.this.profileDM.serverId, ConversationDM.this.serverId);
                    }
                    catch (RootAPIException e) {
                        if (e.exceptionType == NetworkException.CONVERSATION_ARCHIVED) {
                            ConversationDM.this.updateConversationStatus(ConversationStatus.ARCHIVED);
                        }
                        throw e;
                    }
                }
            });
            this.updateConversationStatus(ConversationStatus.RESOLUTION_ACCEPTED);
            this.domain.getAnalyticsEventDM().pushEvent(AnalyticsEventType.RESOLUTION_ACCEPTED, this.serverId);
            this.domain.getDelegate().userRepliedToConversation("User accepted the solution");
        } else {
            String body = "Did not accept the solution";
            final ConfirmationRejectedMessageDM messageDM = new ConfirmationRejectedMessageDM(body, createdAt, "mobile");
            messageDM.conversationLocalId = this.localId;
            this.addMessageToDbAndUI(messageDM);
            this.sendMessageWithAutoRetry(new F(){

                @Override
                public void f() {
                    try {
                        messageDM.send(ConversationDM.this.profileDM.serverId, ConversationDM.this.serverId);
                    }
                    catch (RootAPIException e) {
                        if (e.exceptionType == NetworkException.CONVERSATION_ARCHIVED) {
                            ConversationDM.this.updateConversationStatus(ConversationStatus.ARCHIVED);
                        }
                        throw e;
                    }
                }
            });
            this.updateConversationStatus(ConversationStatus.RESOLUTION_REJECTED);
            this.domain.getAnalyticsEventDM().pushEvent(AnalyticsEventType.RESOLUTION_REJECTED, this.serverId);
            this.domain.getDelegate().userRepliedToConversation("User rejected the solution");
        }
    }

    public void merge(ConversationDM serverConversation, boolean isActive) {
        String serverMessageCursor;
        ConversationStatus serverConversationStatus = serverConversation.status;
        ConversationStatus newStatus = this.status;
        switch (serverConversationStatus) {
            case RESOLUTION_REQUESTED: {
                if (this.status == ConversationStatus.RESOLUTION_ACCEPTED || this.status == ConversationStatus.RESOLUTION_REJECTED) break;
                newStatus = serverConversationStatus;
                break;
            }
            default: {
                newStatus = serverConversationStatus;
            }
        }
        if ((serverMessageCursor = serverConversation.messageCursor) != null) {
            this.messageCursor = serverMessageCursor;
        }
        this.title = serverConversation.title;
        this.showAgentName = serverConversation.showAgentName;
        this.publishId = serverConversation.publishId;
        this.createdAt = serverConversation.createdAt;
        this.updatedAt = serverConversation.updatedAt;
        if (isActive) {
            this.updateUIMessageDMs(serverConversation.messageDMs);
            this.updateConversationStatus(newStatus);
        } else {
            this.status = newStatus;
            List<MessageDM> messagesFromDB = this.conversationDAO.readMessages(this.localId);
            HashMap<String, MessageDM> localMessagesLookup = new HashMap<String, MessageDM>();
            ArrayList<MessageDM> mergedMessages = new ArrayList<MessageDM>();
            for (MessageDM localMessage : messagesFromDB) {
                localMessagesLookup.put(localMessage.serverId, localMessage);
            }
            for (MessageDM serverMessage : serverConversation.messageDMs) {
                String serverId1 = serverMessage.serverId;
                if (localMessagesLookup.containsKey(serverId1)) {
                    MessageDM localMessageDM = (MessageDM)localMessagesLookup.get(serverId1);
                    localMessageDM.merge(serverMessage);
                    mergedMessages.add(localMessageDM);
                    continue;
                }
                serverMessage.conversationLocalId = this.localId;
                mergedMessages.add(serverMessage);
            }
            this.messageDMs = new HSObservableList(mergedMessages);
        }
    }

    public void markMessagesAsSeen(String chatLaunchSource) {
        List<MessageDM> allMessages = this.conversationDAO.readMessages(this.localId);
        final ArrayList<MessageDM> unseenMessages = new ArrayList<MessageDM>();
        for (MessageDM messageDM : allMessages) {
            if (messageDM.deliveryState == 1) continue;
            switch (messageDM.messageType) {
                case ADMIN_IMAGE_ATTACHMENT: 
                case ADMIN_ATTACHMENT: 
                case ADMIN_TEXT: 
                case REQUESTED_SCREENSHOT: 
                case REQUESTED_APP_REVIEW: 
                case REQUEST_FOR_REOPEN: {
                    unseenMessages.add(messageDM);
                }
            }
        }
        if (unseenMessages.size() > 0) {
            String readAt = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
            for (MessageDM messageDMFromDB : unseenMessages) {
                messageDMFromDB.readAt = readAt;
                messageDMFromDB.deliveryState = 1;
                messageDMFromDB.chatLaunchSource = chatLaunchSource;
                messageDMFromDB.seenAtMessageCursor = this.messageCursor;
            }
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    HashMap<Long, MessageDM> uiMessageDMsMap = new HashMap<Long, MessageDM>();
                    for (MessageDM messageDM : ConversationDM.this.messageDMs) {
                        if (messageDM.localId == null) continue;
                        uiMessageDMsMap.put(messageDM.localId, messageDM);
                    }
                    for (MessageDM messageDMFromDB : unseenMessages) {
                        MessageDM uiMessageDM = (MessageDM)uiMessageDMsMap.get(messageDMFromDB.localId);
                        if (uiMessageDM == null) continue;
                        uiMessageDM.readAt = messageDMFromDB.readAt;
                        messageDMFromDB.deliveryState = 1;
                        uiMessageDM.chatLaunchSource = messageDMFromDB.chatLaunchSource;
                        uiMessageDM.seenAtMessageCursor = messageDMFromDB.seenAtMessageCursor;
                    }
                }
            });
            this.platform.getConversationDAO().insertOrUpdateMessages(unseenMessages);
            this.markMessagesAsSeen(unseenMessages);
        }
    }

    private void markMessagesAsSeen(List<MessageDM> messages) {
        String readAt = messages.get((int)0).readAt;
        String chatLaunchSource = messages.get((int)0).chatLaunchSource;
        String seenAtMessageCursor = messages.get((int)0).seenAtMessageCursor;
        ArrayList<String> messageIds = new ArrayList<String>();
        block5: for (MessageDM messageDM : messages) {
            switch (messageDM.messageType) {
                case ADMIN_IMAGE_ATTACHMENT: 
                case ADMIN_ATTACHMENT: {
                    continue block5;
                }
            }
            messageIds.add(messageDM.serverId);
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("message-ids", this.platform.getJsonifier().jsonify(messageIds));
        data.put("source", chatLaunchSource);
        data.put("read-at", readAt);
        data.put("profile-id", this.profileDM.serverId);
        data.put("mc", seenAtMessageCursor);
        String route = "/issues/" + this.serverId + "/messages-seen/";
        POSTNetwork postNetwork = new POSTNetwork(route, this.domain, this.platform);
        TSCorrectedNetwork tsCorrectedNetwork = new TSCorrectedNetwork(postNetwork, this.platform);
        Network network = new FailedAPICallNetworkDecorator(tsCorrectedNetwork);
        network = new GuardOKNetwork(network);
        network.makeRequest(data);
        for (MessageDM message : messages) {
            message.isMessageSeenSynced = true;
        }
        this.platform.getConversationDAO().insertOrUpdateMessages(messages);
    }

    public void setEnableMessageClickOnResolutionRejected(boolean isEnable) {
        this.enableMessageClickOnResolutionRejected = isEnable;
        if (this.status == ConversationStatus.RESOLUTION_REJECTED) {
            this.updateMessagesOnConversationStatusUpdate();
        }
    }

    public boolean shouldShowCSATInFooter() {
        return this.csatState == ConversationCSATState.NONE && this.sdkConfigurationDM.getBoolean("customerSatisfactionSurvey");
    }

    public void sendCSATSurvey(int rating, String feedback) {
        int HighestRating = 5;
        if (rating > HighestRating) {
            rating = HighestRating;
        } else if (rating < 0) {
            rating = 0;
        }
        this.csatRating = rating;
        if (feedback != null) {
            feedback = feedback.trim();
        }
        this.csatFeedback = feedback;
        this.setCSATState(ConversationCSATState.SUBMITTED_NOT_SYNCED);
        this.conversationDAO.insertOrUpdateConversationWithoutMessages(this);
        this.sendMessageWithAutoRetry(new F(){

            @Override
            public void f() {
                ConversationDM.this.sendCSATSurveyInternal();
            }
        });
        this.domain.getDelegate().userCompletedCustomerSatisfactionSurvey(this.csatRating, this.csatFeedback);
    }

    public void sendCSATSurveyInternal() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("rating", String.valueOf(this.csatRating));
        data.put("feedback", this.csatFeedback);
        String url = "/issues/" + this.serverId + "/customer-survey/";
        POSTNetwork postNetwork = new POSTNetwork(url, this.domain, this.platform);
        TSCorrectedNetwork tsCorrectedNetwork = new TSCorrectedNetwork(postNetwork, this.platform);
        FailedAPICallNetworkDecorator failedAPICallNetworkDecorator = new FailedAPICallNetworkDecorator(tsCorrectedNetwork);
        new GuardOKNetwork(failedAPICallNetworkDecorator).makeRequest(data);
        this.setCSATState(ConversationCSATState.SUBMITTED_SYNCED);
        this.conversationDAO.insertOrUpdateConversationWithoutMessages(this);
    }

    private void setCSATState(ConversationCSATState state) {
        if (this.csatState != state) {
            HSLogger.d(TAG, "Update CSAT state : Conversation : " + this.serverId + ", state : " + state.toString());
        }
        this.csatState = state;
    }

    public boolean checkForReOpen(int conversationViewState, String openConversationId) {
        MessageDM lastMessageDM;
        boolean isConversationStatusChange = false;
        if (this.messageDMs != null && this.messageDMs.size() > 0 && (lastMessageDM = (MessageDM)this.messageDMs.get(this.messageDMs.size() - 1)) instanceof RequestForReopenMessageDM) {
            if (conversationViewState == 1) {
                this.sendReOpenRejectedMessage(1, null, lastMessageDM.serverId);
            } else if (conversationViewState == 2) {
                this.sendReOpenRejectedMessage(3, null, lastMessageDM.serverId);
            } else if (openConversationId != null && !openConversationId.equals(this.serverId)) {
                this.sendReOpenRejectedMessage(2, openConversationId, lastMessageDM.serverId);
            } else {
                this.status = ConversationStatus.IN_PROGRESS;
                this.isConversationEndedDelegateSent = false;
                this.conversationDAO.insertOrUpdateConversationWithoutMessages(this);
                String createdAt = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
                final FollowupAcceptedMessageDM followupAcceptedMessageDM = new FollowupAcceptedMessageDM(null, createdAt, "mobile", lastMessageDM.serverId);
                followupAcceptedMessageDM.setDependencies(this.domain, this.platform);
                this.platform.getConversationDAO().insertOrUpdateMessage(followupAcceptedMessageDM);
                RequestForReopenMessageDM requestForReopenMessageDM = (RequestForReopenMessageDM)lastMessageDM;
                requestForReopenMessageDM.isAnswered = true;
                this.platform.getConversationDAO().insertOrUpdateMessage(requestForReopenMessageDM);
                this.sendMessageWithAutoRetry(new F(){

                    @Override
                    public void f() {
                        followupAcceptedMessageDM.send(ConversationDM.this.profileDM.serverId, ConversationDM.this.serverId);
                    }
                });
                isConversationStatusChange = true;
            }
        }
        return isConversationStatusChange;
    }

    private void sendMessageWithAutoRetry(final F f) {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                block2: {
                    try {
                        f.f();
                    }
                    catch (RootAPIException e) {
                        if (e.exceptionType == NetworkException.NON_RETRIABLE) break block2;
                        ConversationDM.this.domain.getAutoRetryFailedEventDM().scheduleRetryTaskForEventType(AutoRetryFailedEventDM.EventType.CONVERSATION, e.getServerStatusCode());
                        throw e;
                    }
                }
            }
        });
    }

    private void sendReOpenRejectedMessage(int reason, String openConversationId, String referId) {
        String createdAt = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
        final FollowupRejectedMessageDM followupRejectedMessageDM = new FollowupRejectedMessageDM(null, createdAt, "mobile", referId);
        followupRejectedMessageDM.reason = reason;
        followupRejectedMessageDM.openConversationId = openConversationId;
        followupRejectedMessageDM.setDependencies(this.domain, this.platform);
        this.platform.getConversationDAO().insertOrUpdateMessage(followupRejectedMessageDM);
        this.sendMessageWithAutoRetry(new F(){

            @Override
            public void f() {
                followupRejectedMessageDM.send(ConversationDM.this.profileDM.serverId, ConversationDM.this.serverId);
            }
        });
    }

    public void setStartNewConversationButtonClicked(boolean isStartNewConversationClicked, boolean updateInDb) {
        this.isStartNewConversationClicked = isStartNewConversationClicked;
        if (updateInDb) {
            this.conversationDAO.insertOrUpdateConversationWithoutMessages(this);
        }
    }

    public void setShouldIncrementMessageCount(boolean val, boolean updateInDb) {
        if (this.shouldIncrementMessageCount != val) {
            this.shouldIncrementMessageCount = val;
            if (updateInDb) {
                this.conversationDAO.insertOrUpdateConversationWithoutMessages(this);
            }
        }
    }

    public int getUnSeenMessageCount() {
        if (!this.shouldOpen()) {
            return 0;
        }
        List<MessageDM> messageDMs = this.conversationDAO.readMessages(this.localId);
        int unreadMessageCount = 0;
        if (messageDMs != null) {
            for (MessageDM messageDM : messageDMs) {
                if (!messageDM.isUISupportedMessage() || messageDM.deliveryState == 1) continue;
                switch (messageDM.messageType) {
                    case ADMIN_IMAGE_ATTACHMENT: 
                    case ADMIN_ATTACHMENT: 
                    case ADMIN_TEXT: 
                    case REQUESTED_SCREENSHOT: 
                    case REQUESTED_APP_REVIEW: 
                    case REQUEST_FOR_REOPEN: {
                        ++unreadMessageCount;
                    }
                }
            }
        }
        if (this.shouldIncrementMessageCount) {
            ++unreadMessageCount;
        }
        return unreadMessageCount;
    }

    public void retryMessages(boolean isActive) {
        List<MessageDM> allMessages = this.conversationDAO.readMessages(this.localId);
        ArrayList<AutoRetriableMessageDM> failedMessages = new ArrayList<AutoRetriableMessageDM>();
        ArrayList<MessageDM> failedMessageSeens = new ArrayList<MessageDM>();
        HashMap<String, RequestAppReviewMessageDM> rarMessagesMap = new HashMap<String, RequestAppReviewMessageDM>();
        for (MessageDM message : allMessages) {
            if (StringUtils.isEmpty(message.serverId) && message instanceof AutoRetriableMessageDM) {
                failedMessages.add((AutoRetriableMessageDM)message);
            }
            if (!StringUtils.isEmpty(message.readAt) && !message.isMessageSeenSynced) {
                failedMessageSeens.add(message);
            }
            if (!(message instanceof RequestAppReviewMessageDM)) continue;
            rarMessagesMap.put(message.serverId, (RequestAppReviewMessageDM)message);
        }
        for (AutoRetriableMessageDM failedMessage : failedMessages) {
            if (this.status == ConversationStatus.ARCHIVED) {
                return;
            }
            try {
                failedMessage.setDependencies(this.domain, this.platform);
                failedMessage.send(this.profileDM.serverId, this.serverId);
                if (!(failedMessage instanceof AcceptedAppReviewMessageDM)) continue;
                ArrayList<MessageDM> uiMessages = new ArrayList<MessageDM>();
                AcceptedAppReviewMessageDM acceptedAppReviewMessageDM = (AcceptedAppReviewMessageDM)failedMessage;
                String referredMessageId = acceptedAppReviewMessageDM.referredMessageId;
                if (rarMessagesMap.containsKey(referredMessageId)) {
                    RequestAppReviewMessageDM rarMessage = (RequestAppReviewMessageDM)rarMessagesMap.get(referredMessageId);
                    rarMessage.handleAcceptedReviewSuccess(this.platform);
                    uiMessages.add(rarMessage);
                }
                if (!isActive) continue;
                uiMessages.add(failedMessage);
                this.addMessageToUI(acceptedAppReviewMessageDM);
                this.updateUIMessageDMs(uiMessages);
            }
            catch (RootAPIException e) {
                if (e.exceptionType == NetworkException.CONVERSATION_ARCHIVED) {
                    this.updateConversationStatus(ConversationStatus.ARCHIVED);
                    continue;
                }
                if (e.exceptionType == NetworkException.NON_RETRIABLE) continue;
                throw e;
            }
        }
        HashMap<String, ArrayList<MessageDM>> readAtMessagesMap = new HashMap<String, ArrayList<MessageDM>>();
        for (MessageDM message : failedMessageSeens) {
            String readAt = message.readAt;
            ArrayList<MessageDM> readAtMessages = (ArrayList<MessageDM>)readAtMessagesMap.get(readAt);
            if (readAtMessages == null) {
                readAtMessages = new ArrayList<MessageDM>();
            }
            readAtMessages.add(message);
            readAtMessagesMap.put(readAt, readAtMessages);
        }
        for (String readAt : readAtMessagesMap.keySet()) {
            try {
                this.markMessagesAsSeen((List)readAtMessagesMap.get(readAt));
            }
            catch (RootAPIException e) {
                if (e.exceptionType == NetworkException.NON_RETRIABLE) continue;
                throw e;
            }
        }
    }

    @Override
    public void onAgentTypingUpdate(boolean isAgentTyping) {
        if (this.conversationVMCallback != null) {
            this.conversationVMCallback.onAgentTypingUpdate(isAgentTyping);
        }
    }

    public void checkAndIncrementMessageCount(ConversationStatus oldStatus) {
        if (this.isVisibleOnUI()) {
            this.setShouldIncrementMessageCount(false, true);
        } else if (!(oldStatus != ConversationStatus.NEW && oldStatus != ConversationStatus.IN_PROGRESS || this.status != ConversationStatus.RESOLUTION_REQUESTED && this.status != ConversationStatus.RESOLUTION_ACCEPTED && this.status != ConversationStatus.RESOLUTION_REJECTED)) {
            this.setShouldIncrementMessageCount(true, true);
        } else if (this.status == ConversationStatus.NEW || this.status == ConversationStatus.IN_PROGRESS) {
            this.setShouldIncrementMessageCount(false, true);
        }
    }

    public void deleteCachedScreenshotFiles() {
        List<MessageDM> messageDMs = this.conversationDAO.readMessages(this.localId);
        ArrayList<MessageDM> updatedMessageDMs = new ArrayList<MessageDM>();
        for (MessageDM messageDM : messageDMs) {
            ScreenshotMessageDM screenshotMessageDM;
            String filePath;
            if (!(messageDM instanceof ScreenshotMessageDM) || (filePath = (screenshotMessageDM = (ScreenshotMessageDM)messageDM).getFilePath()) == null) continue;
            try {
                File file = new File(filePath);
                if (!file.delete()) continue;
                screenshotMessageDM.filePath = null;
                updatedMessageDMs.add(screenshotMessageDM);
            }
            catch (Exception exception) {}
        }
        this.conversationDAO.insertOrUpdateMessages(updatedMessageDMs);
    }

    public boolean isVisibleOnUI() {
        if (this.conversationVMCallback != null) {
            return this.conversationVMCallback.isVisibleOnUI();
        }
        return false;
    }

    public String getConversationLaunchSource() {
        if (this.conversationVMCallback == null) {
            return null;
        }
        return this.conversationVMCallback.getConversationLaunchSource();
    }

    public void startLiveUpdates() {
        if (this.sdkConfigurationDM.getBoolean("enableTypingIndicator") && this.liveUpdateDM != null) {
            this.liveUpdateDM.registerListener(this, this.publishId, this.profileDM.serverId);
        }
    }

    public void stopLiveUpdates() {
        if (this.liveUpdateDM != null) {
            this.liveUpdateDM.unregisterListener();
        }
    }

    public boolean isAgentTyping() {
        return this.sdkConfigurationDM.getBoolean("enableTypingIndicator") && this.liveUpdateDM != null && this.liveUpdateDM.isAgentTyping();
    }
}

