/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation;

import com.helpshift.auth.dto.WebSocketAuthData;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.platform.Device;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.websockets.HSWebSocket;
import com.helpshift.common.platform.network.websockets.IHSWebSocketListener;
import com.helpshift.conversation.dto.WSPingMessage;
import com.helpshift.conversation.dto.WSTypingActionMessage;
import com.helpshift.conversation.dto.WebSocketMessage;
import com.helpshift.util.HSLogger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class LiveUpdateDM
implements IHSWebSocketListener {
    private static final String TAG = "Helpshift_LiveUpdateDM";
    final long NETWORK_PROPOGATION_DELAY = TimeUnit.SECONDS.toMillis(3L);
    public static final int MESSAGE_TYPE_PING = 107;
    public static final int MESSAGE_TYPE_EVENT = 100;
    private final String MESSAGE_TYPE_PONG = "[110]";
    private final String SDK_VERSION_HEADER_KEY = "hs-sdk-ver";
    final String sdkVersionHeaderValue;
    AtomicInteger pingCount;
    HSWebSocket webSocket;
    boolean shouldDisconnectOnConnect;
    boolean isConnecting;
    boolean isTokenRefreshed;
    TypingIndicatorListener listener;
    Domain domain;
    Platform platform;
    private String profileServerId;
    private String publishId;
    AtomicInteger startTypingId;
    boolean isAgentTyping;
    F disconnectWebSocketF = new F(){

        @Override
        public void f() {
            if (LiveUpdateDM.this.webSocket != null) {
                if (LiveUpdateDM.this.isConnecting) {
                    LiveUpdateDM.this.shouldDisconnectOnConnect = true;
                } else {
                    try {
                        HSLogger.d(LiveUpdateDM.TAG, "Disconnecting web-socket");
                        LiveUpdateDM.this.webSocket.disconnect();
                    }
                    catch (Exception e) {
                        HSLogger.e(LiveUpdateDM.TAG, "Exception in disconnecting web-socket", e);
                    }
                    LiveUpdateDM.this.webSocket = null;
                }
            }
        }
    };
    boolean socketConnected;
    private F refreshAuthTokenAndConnectF = new F(){

        @Override
        public void f() {
            if (LiveUpdateDM.this.listener != null) {
                LiveUpdateDM.this.domain.getWebSocketAuthDM().refreshAuthToken();
                LiveUpdateDM.this.isTokenRefreshed = true;
                new ConnectWebSocketF(LiveUpdateDM.this.pingCount.incrementAndGet()).f();
            }
        }
    };

    public LiveUpdateDM(Domain domain, Platform platform) {
        this.domain = domain;
        this.platform = platform;
        this.pingCount = new AtomicInteger(-1);
        this.startTypingId = new AtomicInteger(-1);
        Device device = platform.getDevice();
        this.sdkVersionHeaderValue = device.getPlatformName().toLowerCase() + "-" + device.getSDKVersion();
    }

    boolean isAgentTyping() {
        return this.isAgentTyping;
    }

    synchronized void registerListener(TypingIndicatorListener listener, String publishId, String profileServerId) {
        if (this.listener == null) {
            this.publishId = publishId;
            this.listener = listener;
            this.profileServerId = profileServerId;
            this.isTokenRefreshed = false;
            this.shouldDisconnectOnConnect = false;
            this.domain.runParallel(new ConnectWebSocketF(this.pingCount.incrementAndGet()));
        }
    }

    synchronized void unregisterListener() {
        if (this.listener != null) {
            this.isAgentTyping = false;
            this.notifyListener();
            this.startTypingId.incrementAndGet();
            this.pingCount.incrementAndGet();
            this.listener = null;
        }
        this.domain.runParallel(this.disconnectWebSocketF);
    }

    @Override
    public void onConnected(HSWebSocket webSocket) {
        HSLogger.d(TAG, "web-socket connected");
        this.isConnecting = false;
        this.socketConnected = true;
        if (this.shouldDisconnectOnConnect) {
            this.disconnectWebSocketF.f();
        } else if (this.listener != null) {
            HSLogger.d(TAG, "Subscribing to conversation topic");
            String topic = this.getTopicRequest();
            webSocket.sendMessage(topic);
            this.domain.runDelayedInParallel(new PingTimeoutF(this.pingCount.incrementAndGet()), TimeUnit.SECONDS.toMillis(60L));
        } else {
            this.disconnectWebSocketF.f();
        }
    }

    @Override
    public void onDisconnected() {
        HSLogger.d(TAG, "web-socket disconnected");
        this.socketConnected = false;
        this.shouldDisconnectOnConnect = false;
    }

    @Override
    public void onMessage(HSWebSocket webSocket, String message) {
        this.domain.runParallel(new HandleWebSocketMessageF(message));
    }

    @Override
    public void onError(HSWebSocket webSocket, String error) {
        HSLogger.d(TAG, "Error in web-socket connection: " + error);
        this.isConnecting = false;
        if (this.listener != null) {
            if (this.getErrorCode(error) == 403) {
                if (!this.isTokenRefreshed) {
                    this.domain.runParallel(this.refreshAuthTokenAndConnectF);
                }
            } else {
                this.scheduleConnectionRetry();
            }
        }
    }

    private int getErrorCode(String error) {
        String errorCode;
        String[] status;
        String[] statusLineString = error.split("The status line is: ");
        if (2 == statusLineString.length && (status = statusLineString[1].split(" +")).length >= 2 && "403".equals(errorCode = status[1])) {
            return 403;
        }
        return -1;
    }

    private String getTopicRequest() {
        return "[104, [\"" + this.profileServerId + ".agent_type_act.issue." + this.publishId + "\"]]";
    }

    String getWebSocketPath(WebSocketAuthData authData) {
        String appId = this.platform.getAppId();
        String[] domainWords = this.platform.getDomain().split("\\.");
        String domainName = "";
        if (domainWords.length == 3) {
            domainName = domainWords[0];
        }
        String encodedAuthToken = "";
        try {
            encodedAuthToken = URLEncoder.encode(authData.authToken, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            HSLogger.e(TAG, "Exception in encoding authToken", e);
        }
        if (StringUtils.isEmpty(encodedAuthToken) || StringUtils.isEmpty(authData.webSocketRoute)) {
            return null;
        }
        return authData.webSocketRoute + "/subscribe/websocket/?origin_v3=" + encodedAuthToken + "&platform_id=" + appId + "&domain=" + domainName;
    }

    void scheduleConnectionRetry() {
        this.domain.runDelayedInParallel(new ConnectWebSocketF(this.pingCount.incrementAndGet()), TimeUnit.SECONDS.toMillis(10L));
    }

    void notifyListener() {
        if (this.listener != null) {
            this.listener.onAgentTypingUpdate(this.isAgentTyping);
        }
    }

    private class HandleWebSocketMessageF
    extends F {
        private final String message;

        HandleWebSocketMessageF(String message) {
            this.message = message;
        }

        @Override
        public void f() {
            WebSocketMessage wsMessage = LiveUpdateDM.this.platform.getResponseParser().parseWebSocketMessage(this.message);
            if (wsMessage instanceof WSPingMessage) {
                long pingDelay = ((WSPingMessage)wsMessage).pingWaitTimeMillis + LiveUpdateDM.this.NETWORK_PROPOGATION_DELAY;
                LiveUpdateDM.this.domain.runDelayedInParallel(new PingTimeoutF(LiveUpdateDM.this.pingCount.incrementAndGet()), pingDelay);
                if (LiveUpdateDM.this.webSocket != null) {
                    LiveUpdateDM.this.webSocket.sendMessage("[110]");
                }
            } else if (LiveUpdateDM.this.listener != null && wsMessage instanceof WSTypingActionMessage) {
                WSTypingActionMessage typingMessage = (WSTypingActionMessage)wsMessage;
                if (typingMessage.isAgentTyping) {
                    LiveUpdateDM.this.isAgentTyping = true;
                    long delay = ((WSTypingActionMessage)wsMessage).typingActionTimeoutMillis + LiveUpdateDM.this.NETWORK_PROPOGATION_DELAY;
                    LiveUpdateDM.this.domain.runDelayedInParallel(new StartTypingTimeoutF(LiveUpdateDM.this.startTypingId.incrementAndGet()), delay);
                } else {
                    LiveUpdateDM.this.isAgentTyping = false;
                }
                LiveUpdateDM.this.notifyListener();
            }
        }
    }

    private class PingTimeoutF
    extends F {
        int pingId;

        PingTimeoutF(int pingCount) {
            this.pingId = pingCount;
        }

        @Override
        public void f() {
            if (this.pingId == LiveUpdateDM.this.pingCount.get() && LiveUpdateDM.this.listener != null) {
                HSLogger.d(LiveUpdateDM.TAG, "Ping timed out, resetting connection");
                LiveUpdateDM.this.disconnectWebSocketF.f();
                new ConnectWebSocketF(LiveUpdateDM.this.pingCount.incrementAndGet()).f();
            }
        }
    }

    private class StartTypingTimeoutF
    extends F {
        int id;

        StartTypingTimeoutF(int id2) {
            this.id = id2;
        }

        @Override
        public void f() {
            if (this.id == LiveUpdateDM.this.startTypingId.get() && LiveUpdateDM.this.listener != null) {
                HSLogger.d(LiveUpdateDM.TAG, "Start Typing action timed out, disabling TAI");
                LiveUpdateDM.this.isAgentTyping = false;
                LiveUpdateDM.this.notifyListener();
            }
        }
    }

    private class ConnectWebSocketF
    extends F {
        private final int id;

        ConnectWebSocketF(int id2) {
            this.id = id2;
        }

        @Override
        public void f() {
            if (LiveUpdateDM.this.listener != null && this.id == LiveUpdateDM.this.pingCount.get()) {
                if (LiveUpdateDM.this.socketConnected || LiveUpdateDM.this.isConnecting) {
                    return;
                }
                WebSocketAuthData authData = LiveUpdateDM.this.domain.getWebSocketAuthDM().getAuthToken();
                if (authData == null) {
                    LiveUpdateDM.this.scheduleConnectionRetry();
                    return;
                }
                HSLogger.d(LiveUpdateDM.TAG, "Connecting web-socket");
                try {
                    LiveUpdateDM.this.webSocket = new HSWebSocket.Builder(LiveUpdateDM.this.getWebSocketPath(authData)).setConnectionTimeout((int)TimeUnit.SECONDS.toMillis(60L)).addExtension("permessage-deflate").addExtension("client_no_context_takeover").addExtension("server_no_context_takeover").addProtocol("dirigent-pubsub-v1").addHeader("hs-sdk-ver", LiveUpdateDM.this.sdkVersionHeaderValue).setWebSocketListener(LiveUpdateDM.this).build();
                    LiveUpdateDM.this.isConnecting = true;
                    LiveUpdateDM.this.webSocket.connect();
                }
                catch (Exception e) {
                    HSLogger.e(LiveUpdateDM.TAG, "Exception in connecting web-socket", e);
                    LiveUpdateDM.this.scheduleConnectionRetry();
                }
            }
        }
    }

    static interface TypingIndicatorListener {
        public void onAgentTypingUpdate(boolean var1);
    }
}

