/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.common.StringUtils;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.conversation.activeconversation.message.AutoRetriableMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import java.util.HashMap;

public class AcceptedAppReviewMessageDM
extends AutoRetriableMessageDM {
    public String referredMessageId;

    public AcceptedAppReviewMessageDM(String body, String createdAt, String authorName, String referredMessageId) {
        super(body, createdAt, authorName, false, MessageType.ACCEPTED_APP_REVIEW);
        this.referredMessageId = referredMessageId;
    }

    @Override
    public void merge(MessageDM serverMessageDM) {
        super.merge(serverMessageDM);
        if (serverMessageDM instanceof AcceptedAppReviewMessageDM) {
            AcceptedAppReviewMessageDM appReviewMessage = (AcceptedAppReviewMessageDM)serverMessageDM;
            this.referredMessageId = appReviewMessage.referredMessageId;
        }
    }

    @Override
    public boolean isUISupportedMessage() {
        return !StringUtils.isEmpty(this.serverId);
    }

    @Override
    public void send(String profileServerId, String conversationServerId) throws RootAPIException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("profile-id", profileServerId);
        data.put("message-text", this.body);
        data.put("type", "ar");
        data.put("refers", this.referredMessageId);
        Response response = this.getSendMessageNetwork(conversationServerId).makeRequest(data);
        ResponseParser responseParser = this.platform.getResponseParser();
        AcceptedAppReviewMessageDM responseMessageDM = responseParser.parseAcceptedAppReviewMessageDM(response.responseString);
        this.merge(responseMessageDM);
        this.serverId = responseMessageDM.serverId;
        this.platform.getConversationDAO().insertOrUpdateMessage(this);
    }
}

