/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.common.platform.Platform;
import com.helpshift.conversation.activeconversation.message.AttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.viewmodel.ConversationVMCallback;
import com.helpshift.downloader.SupportDownloadStateChangeListener;
import com.helpshift.downloader.SupportDownloader;

public class AdminAttachmentMessageDM
extends AttachmentMessageDM {
    int downloadProgress = 0;
    public AdminGenericAttachmentState state;

    public AdminAttachmentMessageDM(String serverId, String body, String createdAt, String authorName, int size, String contentType, String attachmentUrl, String fileName) {
        super(body, createdAt, authorName, size, contentType, attachmentUrl, fileName, true, MessageType.ADMIN_ATTACHMENT);
        this.serverId = serverId;
        this.updateState();
    }

    public void updateState() {
        this.state = this.checkAndGetFilePath() != null ? AdminGenericAttachmentState.DOWNLOADED : AdminGenericAttachmentState.DOWNLOAD_NOT_STARTED;
    }

    @Override
    public String getFormattedFileSize() {
        double downloadedBytes;
        if (this.state == AdminGenericAttachmentState.DOWNLOADING && this.downloadProgress > 0 && (downloadedBytes = (double)(this.size * this.downloadProgress) / 100.0) < (double)this.size) {
            return this.getFormattedFileSize(downloadedBytes) + "/" + super.getFormattedFileSize();
        }
        return super.getFormattedFileSize();
    }

    public boolean isWriteStoragePermissionRequired() {
        return this.state == AdminGenericAttachmentState.DOWNLOAD_NOT_STARTED;
    }

    void setState(AdminGenericAttachmentState state) {
        this.state = state;
        this.notifyUpdated();
    }

    public void handleClick(final Platform platform, final ConversationVMCallback callback) {
        if (this.state == AdminGenericAttachmentState.DOWNLOADED) {
            if (callback != null) {
                callback.launchAttachment(this.checkAndGetFilePath(), this.contentType);
            }
        } else if (this.state == AdminGenericAttachmentState.DOWNLOAD_NOT_STARTED) {
            this.setState(AdminGenericAttachmentState.DOWNLOADING);
            platform.getDownloader().startDownload(this.attachmentUrl, SupportDownloader.StorageDirType.EXTERNAL_ONLY, new SupportDownloadStateChangeListener(){

                @Override
                public void onFailure(String url) {
                    AdminAttachmentMessageDM.this.setState(AdminGenericAttachmentState.DOWNLOAD_NOT_STARTED);
                }

                @Override
                public void onSuccess(String url, String filePath) {
                    AdminAttachmentMessageDM.this.filePath = filePath;
                    platform.getConversationDAO().insertOrUpdateMessage(AdminAttachmentMessageDM.this);
                    AdminAttachmentMessageDM.this.setState(AdminGenericAttachmentState.DOWNLOADED);
                    if (callback != null) {
                        callback.launchAttachment(filePath, AdminAttachmentMessageDM.this.contentType);
                    }
                }

                @Override
                public void onProgressChange(String url, int progress) {
                    AdminAttachmentMessageDM.this.downloadProgress = progress;
                    AdminAttachmentMessageDM.this.notifyUpdated();
                }
            });
        }
    }

    public String checkAndGetFilePath() {
        if (!this.doesFilePathExistAndCanRead(this.filePath)) {
            this.filePath = null;
            this.state = AdminGenericAttachmentState.DOWNLOAD_NOT_STARTED;
        }
        return this.filePath;
    }

    @Override
    public boolean isUISupportedMessage() {
        return true;
    }

    public static enum AdminGenericAttachmentState {
        DOWNLOAD_NOT_STARTED,
        DOWNLOADING,
        DOWNLOADED;

    }
}

