/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.common.platform.Platform;
import com.helpshift.conversation.activeconversation.message.ImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.viewmodel.ConversationVMCallback;
import com.helpshift.downloader.SupportDownloadStateChangeListener;
import com.helpshift.downloader.SupportDownloader;

public class AdminImageAttachmentMessageDM
extends ImageAttachmentMessageDM {
    public AdminImageAttachmentState state;

    public AdminImageAttachmentMessageDM(String serverId, String body, String createdAt, String authorName, String attachmentUrl, String fileName, String thumbnailUrl, String contentType, int size) {
        super(body, createdAt, authorName, attachmentUrl, fileName, thumbnailUrl, contentType, size, true, MessageType.ADMIN_IMAGE_ATTACHMENT);
        this.serverId = serverId;
        this.updateState();
    }

    public void updateState() {
        this.state = this.checkAndGetFilePath() != null ? AdminImageAttachmentState.IMAGE_DOWNLOADED : (this.checkAndGetThumbnailFilePath() != null ? AdminImageAttachmentState.THUMBNAIL_DOWNLOADED : AdminImageAttachmentState.DOWNLOAD_NOT_STARTED);
    }

    public String checkAndGetThumbnailFilePath() {
        if (!this.doesFilePathExistAndCanRead(this.thumbnailFilePath)) {
            this.state = AdminImageAttachmentState.DOWNLOAD_NOT_STARTED;
            this.thumbnailFilePath = null;
        }
        return this.thumbnailFilePath;
    }

    public String checkAndGetFilePath() {
        if (!this.doesFilePathExistAndCanRead(this.filePath)) {
            if (this.checkAndGetThumbnailFilePath() != null) {
                this.state = AdminImageAttachmentState.THUMBNAIL_DOWNLOADED;
            }
            this.filePath = null;
        }
        return this.filePath;
    }

    public void setState(AdminImageAttachmentState state) {
        this.state = state;
        this.notifyUpdated();
    }

    public void downloadThumbnailImage(final Platform platform) {
        if (this.state == AdminImageAttachmentState.DOWNLOAD_NOT_STARTED) {
            this.setState(AdminImageAttachmentState.THUMBNAIL_DOWNLOADING);
            platform.getDownloader().startDownload(this.thumbnailUrl, SupportDownloader.StorageDirType.EXTERNAL_OR_INTERNAL, new SupportDownloadStateChangeListener(){

                @Override
                public void onFailure(String url) {
                    AdminImageAttachmentMessageDM.this.setState(AdminImageAttachmentState.DOWNLOAD_NOT_STARTED);
                }

                @Override
                public void onSuccess(String url, String filePath) {
                    AdminImageAttachmentMessageDM.this.thumbnailFilePath = filePath;
                    platform.getConversationDAO().insertOrUpdateMessage(AdminImageAttachmentMessageDM.this);
                    AdminImageAttachmentMessageDM.this.setState(AdminImageAttachmentState.THUMBNAIL_DOWNLOADED);
                }

                @Override
                public void onProgressChange(String url, int progress) {
                }
            });
        }
    }

    public void handleClick(final Platform platform, final ConversationVMCallback conversationVMCallback) {
        if (this.state == AdminImageAttachmentState.IMAGE_DOWNLOADED) {
            if (conversationVMCallback != null) {
                conversationVMCallback.launchAttachment(this.checkAndGetFilePath(), this.contentType);
            }
        } else if (this.state == AdminImageAttachmentState.THUMBNAIL_DOWNLOADED) {
            this.setState(AdminImageAttachmentState.IMAGE_DOWNLOADING);
            platform.getDownloader().startDownload(this.attachmentUrl, SupportDownloader.StorageDirType.EXTERNAL_ONLY, new SupportDownloadStateChangeListener(){

                @Override
                public void onFailure(String url) {
                    AdminImageAttachmentMessageDM.this.setState(AdminImageAttachmentState.THUMBNAIL_DOWNLOADED);
                }

                @Override
                public void onSuccess(String url, String filePath) {
                    AdminImageAttachmentMessageDM.this.filePath = filePath;
                    platform.getConversationDAO().insertOrUpdateMessage(AdminImageAttachmentMessageDM.this);
                    AdminImageAttachmentMessageDM.this.setState(AdminImageAttachmentState.IMAGE_DOWNLOADED);
                    if (conversationVMCallback != null) {
                        conversationVMCallback.launchAttachment(filePath, AdminImageAttachmentMessageDM.this.contentType);
                    }
                }

                @Override
                public void onProgressChange(String url, int progress) {
                }
            });
        }
    }

    @Override
    public boolean isUISupportedMessage() {
        return true;
    }

    public static enum AdminImageAttachmentState {
        DOWNLOAD_NOT_STARTED,
        THUMBNAIL_DOWNLOADING,
        THUMBNAIL_DOWNLOADED,
        IMAGE_DOWNLOADING,
        IMAGE_DOWNLOADED;

    }
}

