/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import java.io.File;
import java.util.Locale;

public abstract class AttachmentMessageDM
extends MessageDM {
    public String contentType;
    public String fileName;
    public String attachmentUrl;
    public int size;
    public String filePath;

    AttachmentMessageDM(String body, String createdAt, String authorName, int size, String contentType, String attachmentUrl, String fileName, boolean isAdminMessage, MessageType messageType) {
        super(body, createdAt, authorName, isAdminMessage, messageType);
        this.size = size;
        this.contentType = contentType;
        this.attachmentUrl = attachmentUrl;
        this.fileName = fileName;
    }

    public String getFormattedFileSize() {
        return this.getFormattedFileSize(this.size);
    }

    String getFormattedFileSize(double fileSizeInBytes) {
        String fileSizeUnit;
        String FILE_SIZE_UNIT_MB = " MB";
        if (fileSizeInBytes < 1024.0) {
            fileSizeUnit = " B";
        } else if (fileSizeInBytes < 1048576.0) {
            fileSizeInBytes /= 1024.0;
            fileSizeUnit = " KB";
        } else {
            fileSizeInBytes /= 1048576.0;
            fileSizeUnit = FILE_SIZE_UNIT_MB;
        }
        String formattedFileSize = FILE_SIZE_UNIT_MB.equals(fileSizeUnit) ? String.format(Locale.US, "%.1f", fileSizeInBytes) + fileSizeUnit : String.format(Locale.US, "%.0f", fileSizeInBytes) + fileSizeUnit;
        return formattedFileSize;
    }

    boolean doesFilePathExistAndCanRead(String filePath) {
        if (filePath != null) {
            File file = new File(filePath);
            return file.exists() && file.canRead();
        }
        return false;
    }

    @Override
    public void merge(MessageDM serverMessageDM) {
        super.merge(serverMessageDM);
        if (serverMessageDM instanceof AttachmentMessageDM) {
            AttachmentMessageDM attachmentMessage = (AttachmentMessageDM)serverMessageDM;
            this.contentType = attachmentMessage.contentType;
            this.fileName = attachmentMessage.fileName;
            this.attachmentUrl = attachmentMessage.attachmentUrl;
            this.size = attachmentMessage.size;
        }
    }
}

