/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.common.domain.network.FailedAPICallNetworkDecorator;
import com.helpshift.common.domain.network.GuardAgainstConversationArchivalNetwork;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;

public abstract class AutoRetriableMessageDM
extends MessageDM {
    AutoRetriableMessageDM(String body, String createdAt, String authorName, boolean isAdminMessage, MessageType messageType) {
        super(body, createdAt, authorName, isAdminMessage, messageType);
    }

    @Override
    Network getSendMessageNetwork(String conversationServerId) {
        String route = "/issues/" + conversationServerId + "/messages/";
        Network sendMessageNetwork = new POSTNetwork(route, this.domain, this.platform);
        sendMessageNetwork = new TSCorrectedNetwork(sendMessageNetwork, this.platform);
        sendMessageNetwork = new FailedAPICallNetworkDecorator(sendMessageNetwork);
        sendMessageNetwork = new GuardAgainstConversationArchivalNetwork(sendMessageNetwork);
        return new GuardOKNetwork(sendMessageNetwork);
    }

    public abstract void send(String var1, String var2);
}

