/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.common.domain.network.Network;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.conversation.activeconversation.message.AutoRetriableMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import java.util.HashMap;

public class FollowupAcceptedMessageDM
extends AutoRetriableMessageDM {
    public String referredMessageId;

    public FollowupAcceptedMessageDM(String body, String createdAt, String authorName, String referredMessageId) {
        super(body, createdAt, authorName, false, MessageType.FOLLOWUP_ACCEPTED);
        this.referredMessageId = referredMessageId;
    }

    @Override
    public void merge(MessageDM serverMessageDM) {
        super.merge(serverMessageDM);
        if (serverMessageDM instanceof FollowupAcceptedMessageDM) {
            FollowupAcceptedMessageDM message = (FollowupAcceptedMessageDM)serverMessageDM;
            this.referredMessageId = message.referredMessageId;
        }
    }

    @Override
    public boolean isUISupportedMessage() {
        return false;
    }

    @Override
    public void send(String profileServerId, String conversationServerId) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("profile-id", profileServerId);
        data.put("message-text", "Accepted the follow-up");
        data.put("type", "ra");
        data.put("refers", this.referredMessageId);
        Network network = this.getSendMessageNetwork(conversationServerId);
        String responseString = network.makeRequest(data).responseString;
        ResponseParser responseParser = this.platform.getResponseParser();
        FollowupAcceptedMessageDM followupAcceptedMessage = responseParser.parseFollowupAcceptedMessage(responseString);
        this.merge(followupAcceptedMessage);
        this.platform.getConversationDAO().insertOrUpdateMessage(this);
    }
}

