/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.common.domain.network.Network;
import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.conversation.activeconversation.message.AutoRetriableMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import java.util.HashMap;

public class FollowupRejectedMessageDM
extends AutoRetriableMessageDM {
    public static final int REASON_CONVERSATION_FILING = 1;
    public static final int REASON_OPEN_ISSUE = 2;
    public static final int REASON_MESSAGE_FILING = 3;
    public String referredMessageId;
    public int reason;
    public String openConversationId;

    public FollowupRejectedMessageDM(String body, String createdAt, String authorName, String referredMessageId) {
        super(body, createdAt, authorName, false, MessageType.FOLLOWUP_REJECTED);
        this.referredMessageId = referredMessageId;
    }

    @Override
    public void merge(MessageDM serverMessageDM) {
        super.merge(serverMessageDM);
        if (serverMessageDM instanceof FollowupRejectedMessageDM) {
            FollowupRejectedMessageDM message = (FollowupRejectedMessageDM)serverMessageDM;
            this.referredMessageId = message.referredMessageId;
        }
    }

    @Override
    public boolean isUISupportedMessage() {
        return false;
    }

    @Override
    public void send(String profileServerId, String conversationServerId) {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("reason", String.valueOf(this.reason));
        if (this.openConversationId != null) {
            metaData.put("open-issue-id", String.valueOf(this.openConversationId));
        }
        String metaString = this.platform.getJsonifier().jsonify(metaData);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("profile-id", profileServerId);
        data.put("message-text", "Rejected the follow-up");
        data.put("type", "rj");
        data.put("refers", this.referredMessageId);
        data.put("message-meta", metaString);
        Network network = this.getSendMessageNetwork(conversationServerId);
        Response response = network.makeRequest(data);
        ResponseParser responseParser = this.platform.getResponseParser();
        FollowupRejectedMessageDM followupRejectedMessage = responseParser.parseFollowupRejectedMessage(response.responseString);
        this.merge(followupRejectedMessage);
        this.platform.getConversationDAO().insertOrUpdateMessage(this);
    }
}

