/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.GuardAgainstConversationArchivalNetwork;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.platform.Platform;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.localeprovider.domainmodel.LocaleProviderDM;
import com.helpshift.util.HSLogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Observable;
import java.util.TimeZone;

public abstract class MessageDM
extends Observable {
    private static final String TAG = "Helpshift_MessageDM";
    public static final int DELIVERY_STATE_UNREAD = 0;
    public static final int DELIVERY_STATE_READ = 1;
    public static final int DELIVERY_STATE_SENT = 2;
    public String serverId;
    public String body;
    public String createdAt;
    public String authorName;
    public Long conversationLocalId;
    public Long localId;
    public String readAt;
    public String chatLaunchSource;
    public String seenAtMessageCursor;
    public int deliveryState;
    public boolean isMessageSeenSynced;
    protected Domain domain;
    protected Platform platform;
    public boolean shouldShowAgentNameForConversation;
    public final boolean isAdminMessage;
    public final MessageType messageType;

    MessageDM(String body, String createdAt, String authorName, boolean isAdminMessage, MessageType messageType) {
        this.body = body;
        this.createdAt = createdAt;
        this.authorName = authorName;
        this.isAdminMessage = isAdminMessage;
        this.messageType = messageType;
    }

    public void setDependencies(Domain domain, Platform platform) {
        this.domain = domain;
        this.platform = platform;
    }

    public String getSubText() {
        Date outputDate;
        SDKConfigurationDM sdkConfigurationDM = this.domain.getSDKConfigurationDM();
        LocaleProviderDM localeProviderDM = this.domain.getLocaleProviderDM();
        Locale locale = localeProviderDM.getCurrentLocale();
        try {
            SimpleDateFormat storageTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", locale);
            storageTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            outputDate = storageTimeFormat.parse(this.createdAt);
        }
        catch (ParseException e) {
            outputDate = new Date();
            HSLogger.d(TAG, "getSubText : ParseException", e);
        }
        String formattedDate = new SimpleDateFormat("dd-MMM-yyyy HH:mm", locale).format(outputDate);
        String subText = this.isAdminMessage && sdkConfigurationDM.getBoolean("showAgentName") && this.shouldShowAgentNameForConversation ? this.authorName + ", " + formattedDate : formattedDate;
        return subText;
    }

    void notifyUpdated() {
        this.setChanged();
        this.notifyObservers();
    }

    public void mergeAndNotify(MessageDM messageDM) {
        this.merge(messageDM);
        this.notifyUpdated();
    }

    public void merge(MessageDM serverMessageDM) {
        this.body = serverMessageDM.body;
        this.createdAt = serverMessageDM.createdAt;
        this.authorName = serverMessageDM.authorName;
    }

    public abstract boolean isUISupportedMessage();

    Network getSendMessageNetwork(String conversationServerId) {
        String route = "/issues/" + conversationServerId + "/messages/";
        Network sendMessageNetwork = new POSTNetwork(route, this.domain, this.platform);
        sendMessageNetwork = new TSCorrectedNetwork(sendMessageNetwork, this.platform);
        sendMessageNetwork = new GuardAgainstConversationArchivalNetwork(sendMessageNetwork);
        return new GuardOKNetwork(sendMessageNetwork);
    }
}

