/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.conversation.activeconversation.message.AcceptedAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import java.util.HashMap;

public class RequestAppReviewMessageDM
extends MessageDM {
    public boolean isAnswered;
    public boolean isReviewButtonClickable;

    public RequestAppReviewMessageDM(String serverId, String body, String createdAt, String authorName, boolean isAnswered) {
        super(body, createdAt, authorName, true, MessageType.REQUESTED_APP_REVIEW);
        this.serverId = serverId;
        this.isAnswered = isAnswered;
        this.isReviewButtonClickable = true;
    }

    public void setIsReviewButtonClickable(boolean isClickable) {
        this.isReviewButtonClickable = isClickable;
        this.notifyUpdated();
    }

    public AcceptedAppReviewMessageDM handleRequestReviewClick(Domain domain, Platform platform) {
        if (this.isAnswered) {
            return null;
        }
        this.setIsReviewButtonClickable(false);
        String createdAt = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(platform);
        AcceptedAppReviewMessageDM acceptedAppReviewMessageDM = new AcceptedAppReviewMessageDM("Accepted review request", createdAt, "mobile", this.serverId);
        acceptedAppReviewMessageDM.conversationLocalId = this.conversationLocalId;
        acceptedAppReviewMessageDM.setDependencies(domain, platform);
        platform.getConversationDAO().insertOrUpdateMessage(acceptedAppReviewMessageDM);
        HashMap<String, Object> analyticsData = new HashMap<String, Object>();
        analyticsData.put("type", "conversation");
        domain.getAnalyticsEventDM().pushEvent(AnalyticsEventType.REVIEWED_APP, analyticsData);
        domain.getDelegate().userRepliedToConversation("User reviewed the app");
        return acceptedAppReviewMessageDM;
    }

    public void handleAcceptedReviewSuccess(Platform platform) {
        this.isReviewButtonClickable = false;
        this.isAnswered = true;
        this.notifyUpdated();
        platform.getConversationDAO().insertOrUpdateMessage(this);
    }

    @Override
    public void merge(MessageDM serverMessageDM) {
        super.merge(serverMessageDM);
        if (serverMessageDM instanceof RequestAppReviewMessageDM) {
            RequestAppReviewMessageDM message = (RequestAppReviewMessageDM)serverMessageDM;
            this.isAnswered = message.isAnswered;
        }
    }

    @Override
    public boolean isUISupportedMessage() {
        return true;
    }
}

