/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.domain.network.GuardAgainstConversationArchivalNetwork;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.UploadNetwork;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.Response;
import com.helpshift.conversation.activeconversation.message.ImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.activeconversation.message.UserMessageState;
import com.helpshift.downloader.SupportDownloadStateChangeListener;
import com.helpshift.downloader.SupportDownloader;
import java.util.HashMap;
import java.util.UUID;

public class ScreenshotMessageDM
extends ImageAttachmentMessageDM {
    public String refersMessageId;
    public UserMessageState state;

    public ScreenshotMessageDM(String body, String createdAt, String authorName, String contentType, String thumbnailUrl, String fileName, String imageUrl, int size) {
        super(body, createdAt, authorName, imageUrl, fileName, thumbnailUrl, contentType, size, false, MessageType.SCREENSHOT);
    }

    public void setRefersMessageId(String refersMessageId) {
        if (refersMessageId == null) {
            refersMessageId = "localRscMessage_" + UUID.randomUUID().toString();
        }
        this.refersMessageId = refersMessageId;
    }

    public void uploadImage(String profileServerId, String conversationServerId, boolean shouldCompressImage) {
        if (this.getFilePath() == null) {
            return;
        }
        if (shouldCompressImage) {
            this.filePath = this.platform.compressAndStoreScreenshot(this.getFilePath(), this.refersMessageId);
            this.platform.getConversationDAO().insertOrUpdateMessage(this);
        }
        this.setState(UserMessageState.SENDING);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("profile-id", profileServerId);
        data.put("message-text", "Screenshot sent");
        data.put("type", "sc");
        data.put("refers", this.refersMessageId);
        data.put("screenshot", this.getFilePath());
        data.put("originalFileName", this.fileName);
        try {
            String route = "/issues/" + conversationServerId + "/messages/";
            Network network = new UploadNetwork(route, this.domain, this.platform);
            network = new GuardAgainstConversationArchivalNetwork(network);
            Response response = new GuardOKNetwork(network).makeRequest(data);
            ScreenshotMessageDM screenshotMessageDM = this.platform.getResponseParser().parseScreenshotMessageDM(response.responseString);
            this.serverId = screenshotMessageDM.serverId;
            this.merge(screenshotMessageDM);
            this.setState(UserMessageState.SENT);
            this.platform.getConversationDAO().insertOrUpdateMessage(this);
            this.notifyUpdated();
            HashMap<String, Object> analyticsData = new HashMap<String, Object>();
            analyticsData.put("id", conversationServerId);
            analyticsData.put("body", screenshotMessageDM.attachmentUrl);
            analyticsData.put("type", "url");
            this.domain.getAnalyticsEventDM().pushEvent(AnalyticsEventType.MESSAGE_ADDED, analyticsData);
            this.domain.getDelegate().userRepliedToConversation("User sent a screenshot");
        }
        catch (RootAPIException e) {
            this.setState(UserMessageState.UNSENT_RETRYABLE);
            throw RootAPIException.wrap(e);
        }
    }

    private void setState(UserMessageState state) {
        this.state = state;
        this.notifyUpdated();
    }

    public void updateState(boolean isClickable) {
        if (this.serverId == null) {
            if (this.state == UserMessageState.SENDING) {
                return;
            }
            if (isClickable) {
                this.setState(UserMessageState.UNSENT_RETRYABLE);
            } else {
                this.setState(UserMessageState.UNSENT_NOT_RETRYABLE);
            }
        } else {
            this.setState(UserMessageState.SENT);
        }
    }

    public String getFilePath() {
        if (!this.doesFilePathExistAndCanRead(this.filePath)) {
            this.filePath = null;
        }
        return this.filePath;
    }

    public void checkAndReDownloadImageIfNotExist(final Platform platform) {
        if (this.state == UserMessageState.SENT && !this.doesFilePathExistAndCanRead(this.getFilePath())) {
            platform.getDownloader().startDownload(this.attachmentUrl, SupportDownloader.StorageDirType.INTERNAL_ONLY, new SupportDownloadStateChangeListener(){

                @Override
                public void onFailure(String url) {
                }

                @Override
                public void onSuccess(String url, String filePath) {
                    ScreenshotMessageDM.this.filePath = filePath;
                    platform.getConversationDAO().insertOrUpdateMessage(ScreenshotMessageDM.this);
                    ScreenshotMessageDM.this.notifyUpdated();
                }

                @Override
                public void onProgressChange(String url, int progress) {
                }
            });
        }
    }

    @Override
    public boolean isUISupportedMessage() {
        return true;
    }
}

