/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.activeconversation.message.UserMessageState;
import java.util.HashMap;

public class UserMessageDM
extends MessageDM {
    public UserMessageState state;

    public UserMessageDM(String body, String createdAt, String authorName) {
        super(body, createdAt, authorName, false, MessageType.USER_TEXT);
    }

    public void send(String profileServerId, String conversationServerId) {
        if (this.state == UserMessageState.SENDING || this.state == UserMessageState.SENT || this.state == UserMessageState.UNSENT_NOT_RETRYABLE) {
            return;
        }
        String replyText = this.body;
        this.state = UserMessageState.SENDING;
        this.notifyUpdated();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("profile-id", profileServerId);
        data.put("message-text", replyText);
        data.put("type", "txt");
        data.put("refers", "");
        try {
            Response response = this.getSendMessageNetwork(conversationServerId).makeRequest(data);
            ResponseParser responseParser = this.platform.getResponseParser();
            UserMessageDM responseMessageDM = responseParser.parseReadableUserMessage(response.responseString);
            this.state = UserMessageState.SENT;
            this.merge(responseMessageDM);
            this.serverId = responseMessageDM.serverId;
            this.platform.getConversationDAO().insertOrUpdateMessage(this);
            this.notifyUpdated();
        }
        catch (RootAPIException e) {
            if (e.exceptionType != NetworkException.CONVERSATION_ARCHIVED) {
                this.state = UserMessageState.UNSENT_RETRYABLE;
                this.notifyUpdated();
            }
            throw RootAPIException.wrap(e);
        }
        finally {
            this.domain.getDelegate().userRepliedToConversation(replyText);
            HashMap<String, Object> analyticsData = new HashMap<String, Object>();
            analyticsData.put("id", conversationServerId);
            analyticsData.put("body", replyText);
            analyticsData.put("type", "txt");
            this.domain.getAnalyticsEventDM().pushEvent(AnalyticsEventType.MESSAGE_ADDED, analyticsData);
        }
    }

    public void updateState(boolean isClickable) {
        if (this.serverId == null) {
            if (this.state == UserMessageState.SENDING) {
                return;
            }
            this.state = isClickable ? UserMessageState.UNSENT_RETRYABLE : UserMessageState.UNSENT_NOT_RETRYABLE;
        } else {
            this.state = UserMessageState.SENT;
        }
    }

    @Override
    public boolean isUISupportedMessage() {
        return true;
    }
}

