/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.domainmodel;

import com.helpshift.account.domainmodel.ProfileDM;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.AutoRetriableDM;
import com.helpshift.common.AutoRetryFailedEventDM;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.One;
import com.helpshift.common.domain.Poller;
import com.helpshift.common.domain.RF;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.conversation.ConversationInboxPoller;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.FetchDataFromThread;
import com.helpshift.conversation.activeconversation.LiveUpdateDM;
import com.helpshift.conversation.dao.ConversationDAO;
import com.helpshift.conversation.dao.ConversationInboxDAO;
import com.helpshift.conversation.dao.PushNotificationData;
import com.helpshift.conversation.dto.ConversationDetailDTO;
import com.helpshift.conversation.dto.ConversationInbox;
import com.helpshift.conversation.dto.ConversationStatus;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.conversation.states.ConversationCSATState;
import com.helpshift.conversation.viewmodel.ConversationVMCallback;
import com.helpshift.faq.domainmodel.FAQSearchDM;
import com.helpshift.util.HSLogger;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class ConversationInboxDM
implements AutoRetriableDM {
    final Platform platform;
    final ProfileDM profileDM;
    final Domain domain;
    final Long profileLocalId;
    private final ConversationInboxDAO conversationInboxDAO;
    final ConversationDAO conversationDAO;
    private final FAQSearchDM faqSearchDM;
    private final SDKConfigurationDM sdkConfigurationDM;
    private final LiveUpdateDM liveUpdateDM;
    private final ConversationInboxPoller conversationInboxPoller;
    private Network fetchConversationUpdatesNetwork;
    private WeakReference<StartNewConversationListener> startNewConversationListenerRef;
    private boolean shouldDropCustomMetadata;
    private boolean isCreateConversationInProgress;
    private boolean userCanReadMessages;
    private int conversationViewState = -1;
    private Map<ConversationDM, Long> inMemoryConversationDMs = Collections.synchronizedMap(new WeakHashMap());
    private long lastActiveConversationLocalId = -1L;
    public AtomicReference<FetchDataFromThread<Integer>> fetchConversationUpdatesListenerReference = null;
    private static final String TAG = "Helpshift_ConvInboxDM";

    public ConversationInboxPoller getConversationInboxPoller() {
        return this.conversationInboxPoller;
    }

    public ConversationInboxDM(Platform platform, Domain domain, ProfileDM profileDM) {
        this.platform = platform;
        this.domain = domain;
        this.profileDM = profileDM;
        this.profileLocalId = profileDM.localId;
        this.conversationInboxDAO = platform.getConversationInboxDAO();
        this.conversationDAO = platform.getConversationDAO();
        this.faqSearchDM = platform.getFAQSearchDM();
        this.sdkConfigurationDM = domain.getSDKConfigurationDM();
        this.conversationInboxPoller = new ConversationInboxPoller(profileDM, this.sdkConfigurationDM, this.getPoller());
        this.liveUpdateDM = new LiveUpdateDM(domain, platform);
        this.domain.getAutoRetryFailedEventDM().register(AutoRetryFailedEventDM.EventType.CONVERSATION, this);
    }

    private Poller getPoller() {
        return new Poller(this.domain, new RF<Integer>(){

            @Override
            public synchronized Integer f() {
                return ConversationInboxDM.this.fetchConversationUpdates();
            }
        });
    }

    @Override
    public void sendFailedApiCalls() {
        List<ConversationDM> conversations = this.conversationDAO.readConversationsWithoutMessages(this.profileLocalId);
        for (ConversationDM conversation : conversations) {
            ConversationDM inMemoryConversationDM = this.getInMemoryConversationDM(conversation.localId);
            if (inMemoryConversationDM != null) {
                this.retryCallsForConversation(inMemoryConversationDM, true);
                continue;
            }
            this.retryCallsForConversation(conversation, false);
        }
    }

    private void retryCallsForConversation(ConversationDM conversation, boolean isActive) {
        conversation.setDependencies(this.platform, this.domain, this.profileDM);
        conversation.retryMessages(isActive);
        if (conversation.csatState == ConversationCSATState.SUBMITTED_NOT_SYNCED) {
            conversation.sendCSATSurveyInternal();
        }
    }

    public void setUserCanReadMessages(boolean userCanReadMessages) {
        this.userCanReadMessages = userCanReadMessages;
    }

    public ConversationDetailDTO getConversationDetail() {
        return this.conversationInboxDAO.getDescriptionDetail(this.profileLocalId);
    }

    public String getConversationArchivalPrefillText() {
        return this.conversationInboxDAO.getConversationArchivalPrefillText(this.profileLocalId);
    }

    public void saveDescriptionDetail(String value, int type) {
        this.conversationInboxDAO.saveDescriptionDetail(this.profileLocalId, new ConversationDetailDTO(value, System.nanoTime(), type));
    }

    public void saveName(String name) {
        this.conversationInboxDAO.saveName(this.profileLocalId, name);
    }

    public void saveEmail(String email) {
        this.conversationInboxDAO.saveEmail(this.profileLocalId, email);
    }

    public String getName() {
        String name = this.conversationInboxDAO.getName(this.profileLocalId);
        if (StringUtils.isEmpty(name)) {
            name = this.profileDM.name;
        }
        return name;
    }

    public String getEmail() {
        String email = this.conversationInboxDAO.getEmail(this.profileLocalId);
        if (StringUtils.isEmpty(email)) {
            email = this.profileDM.email;
        }
        return email;
    }

    public void saveImageAttachmentDraft(ImagePickerFile imageAttachmentDraft) {
        this.conversationInboxDAO.saveImageAttachment(this.profileLocalId, imageAttachmentDraft);
    }

    public ImagePickerFile getImageAttachmentDraft() {
        return this.conversationInboxDAO.getImageAttachment(this.profileLocalId);
    }

    public void saveUserReplyText(String replyText) {
        this.conversationInboxDAO.saveUserReplyDraft(this.profileLocalId, replyText);
    }

    public String getUserReplyText() {
        return this.conversationInboxDAO.getUserReplyDraft(this.profileLocalId);
    }

    public ArrayList getFAQSearchResults(String text) {
        return this.faqSearchDM.getSearchResults(text);
    }

    public void triggerFAQSearchIndexing() {
        this.faqSearchDM.startFAQSearchIndexing();
    }

    public void setShouldDropCustomMetadata(boolean shouldDropCustomMetadata) {
        this.shouldDropCustomMetadata = shouldDropCustomMetadata;
    }

    public void registerStartNewConversationListener(StartNewConversationListener listener) {
        this.startNewConversationListenerRef = new WeakReference<StartNewConversationListener>(listener);
    }

    public void unregisterStartNewConversationListener(StartNewConversationListener listener) {
        if (this.startNewConversationListenerRef != null && this.startNewConversationListenerRef.get() == listener) {
            this.startNewConversationListenerRef = new WeakReference<Object>(null);
        }
    }

    public void startNewConversation(String description, String name, String email, ImagePickerFile imagePickerFile) {
        CreateConversationStateHolder holder = new CreateConversationStateHolder(description, name, email, imagePickerFile);
        this.domain.runParallel(holder.getStartNewConversationInternalF());
    }

    void startNewConversationInternal(String description, String name, String email, ImagePickerFile imagePickerFile) {
        this.isCreateConversationInProgress = true;
        ConversationDM conversationDM = this.tryToStartNewConversation(description, name, email);
        this.setLastActiveConversation(conversationDM);
        this.checkAndTryToUploadImage(conversationDM, imagePickerFile);
        this.isCreateConversationInProgress = false;
        if (this.startNewConversationListenerRef.get() != null) {
            ((StartNewConversationListener)this.startNewConversationListenerRef.get()).onCreateConversationSuccess(conversationDM.localId);
        }
    }

    private synchronized void setLastActiveConversation(ConversationDM conversationDM) {
        this.lastActiveConversationLocalId = conversationDM.localId;
        this.inMemoryConversationDMs.put(conversationDM, conversationDM.localId);
    }

    private ConversationDM tryToStartNewConversation(String description, String name, String email) {
        try {
            ConversationDM conversationDM = this.createConversation(description, name, email);
            this.saveDescriptionDetail("", 0);
            if (!this.sdkConfigurationDM.shouldCreateConversationAnonymously()) {
                this.saveName(name);
                this.saveEmail(email);
            }
            this.conversationInboxDAO.saveConversationArchivalPrefillText(this.profileLocalId, null);
            this.checkAndDropCustomMeta(conversationDM);
            this.sendConversationPostedEvent(conversationDM.serverId);
            this.domain.getDelegate().newConversationStarted(description);
            return conversationDM;
        }
        catch (Exception e) {
            this.isCreateConversationInProgress = false;
            if (this.startNewConversationListenerRef.get() != null) {
                ((StartNewConversationListener)this.startNewConversationListenerRef.get()).onCreateConversationFailure(e);
            }
            throw e;
        }
    }

    private void checkAndDropCustomMeta(ConversationDM conversationDM) {
        if (this.shouldDropCustomMetadata) {
            conversationDM.dropCustomMetaData();
        }
    }

    private void checkAndTryToUploadImage(ConversationDM conversationDM, ImagePickerFile imagePickerFile) {
        if (imagePickerFile != null && imagePickerFile.filePath != null) {
            try {
                conversationDM.sendScreenshot(imagePickerFile, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.saveImageAttachmentDraft(null);
        }
    }

    private void sendConversationPostedEvent(String conversationServerId) {
        this.domain.getAnalyticsEventDM().pushEvent(AnalyticsEventType.CONVERSATION_POSTED, conversationServerId);
    }

    private void ensureProfileCreated(String name, String email) {
        if (this.profileDM.serverId == null) {
            HSLogger.d(TAG, "Create new conversation : Profile not registered. Trying to register profile.");
            this.profileDM.createProfile(name, email);
            this.fetchConversationUpdates();
        }
    }

    public ConversationDM createConversation(String description, String name, String email) {
        this.ensureProfileCreated(name, email);
        ConversationDM conversationDM = new ConversationDM(this.platform, this.domain, this.profileDM, this.liveUpdateDM);
        this.profileDM.updateCampaignUidAndDid();
        conversationDM.createConversation(description, name, email, this.profileDM.uid, this.profileDM.did);
        this.conversationInboxPoller.startOrStopInAppPoller();
        return conversationDM;
    }

    public boolean isCreateConversationInProgress() {
        return this.isCreateConversationInProgress;
    }

    public int fetchConversationUpdates() {
        FetchDataFromThread<Integer> fetchConversationUpdatesListener;
        ProfileDM profileDM = this.profileDM;
        if (StringUtils.isEmpty(profileDM.serverId)) {
            return NetworkErrorCodes.PROFILE_NOT_REGISTERED;
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("profile-id", profileDM.serverId);
        String timestamp = this.conversationInboxDAO.getConversationInboxTimestamp(this.profileLocalId);
        if (timestamp == null) {
            data.put("since", "");
            data.put("mc", "");
        } else {
            data.put("since", timestamp);
            data.put("mc", this.generateMessageCursors());
        }
        ConversationDM activeUIConversationDM = this.getLastActiveConversationDM();
        if (activeUIConversationDM != null) {
            data.put("chat-launch-source", activeUIConversationDM.getConversationLaunchSource());
        }
        data.put("ucrm", String.valueOf(this.userCanReadMessages));
        Response response = this.getFetchConversationUpdatesNetwork().makeRequest(data);
        ResponseParser responseParser = this.platform.getResponseParser();
        ConversationInbox conversationInbox = responseParser.parseConversationInbox(response.responseString);
        this.conversationInboxDAO.saveConversationInboxTimestamp(this.profileLocalId, conversationInbox.timestamp);
        if (conversationInbox.conversations != null && conversationInbox.conversations.size() > 0) {
            List<ConversationDM> localConversations = this.conversationDAO.readConversationsWithoutMessages(this.profileLocalId);
            List<ConversationDM> mergedConversations = this.merge(localConversations, conversationInbox.conversations);
            this.putConversations(mergedConversations);
            this.checkForReOpen(mergedConversations);
            if (!profileDM.isPushTokenSynced && this.sdkConfigurationDM.getBoolean("enableInAppNotification")) {
                this.checkAndGenerateNotification(mergedConversations);
            }
        }
        if (this.fetchConversationUpdatesListenerReference != null && (fetchConversationUpdatesListener = this.fetchConversationUpdatesListenerReference.get()) != null) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    fetchConversationUpdatesListener.onDataFetched(ConversationInboxDM.this.getNotificationCountSync());
                }
            });
        }
        return response.status;
    }

    private ConversationDM getLastActiveConversationDM() {
        return this.getInMemoryConversationDM(this.lastActiveConversationLocalId);
    }

    private void checkAndGenerateNotification(List<ConversationDM> conversationDMs) {
        for (ConversationDM conversationDM : conversationDMs) {
            if (!this.shouldShowNotification(conversationDM)) continue;
            conversationDM.setDependencies(this.platform, this.domain, this.profileDM);
            this.showInAppNotification(conversationDM);
        }
    }

    private void showInAppNotification(ConversationDM conversationDM) {
        if (this.sdkConfigurationDM.getBoolean("enableInAppNotification")) {
            int messageCount = conversationDM.getUnSeenMessageCount();
            this.showNotificationOnUI(conversationDM.localId, conversationDM.serverId, messageCount, "inapp", this.platform.getDevice().getAppName());
        }
    }

    private boolean shouldShowNotification(ConversationDM conversation) {
        if (conversation == null) {
            return false;
        }
        if (this.profileDM.localId == conversation.profileLocalId && !StringUtils.isEmpty(conversation.serverId)) {
            ConversationDM activeConversationDM = this.getLastActiveConversationDM();
            if (this.userCanReadMessages) {
                return activeConversationDM == null || !conversation.serverId.equals(activeConversationDM.serverId);
            }
            return true;
        }
        return false;
    }

    private void showNotificationOnUI(final Long conversationLocalId, final String conversationServerId, final int messageCount, final String source, final String title) {
        if (messageCount > 0) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    ConversationInboxDM.this.platform.showNotification(conversationLocalId, conversationServerId, messageCount, source, title);
                }
            });
        }
    }

    private void checkForReOpen(List<ConversationDM> conversationDMs) {
        ConversationDM conversation = this.getActiveConversationFromStorage();
        String activeConversationId = null;
        if (conversation != null) {
            activeConversationId = conversation.serverId;
        }
        ConversationDM activeConversationDM = this.getLastActiveConversationDM();
        for (ConversationDM conversationDM : conversationDMs) {
            conversationDM.setDependencies(this.platform, this.domain, this.profileDM);
            boolean isConversationStatusChange = conversationDM.checkForReOpen(this.conversationViewState, activeConversationId);
            if (isConversationStatusChange && activeConversationDM != null && conversationDM.serverId.equals(activeConversationDM.serverId)) {
                activeConversationDM.isConversationEndedDelegateSent = false;
                activeConversationDM.updateConversationStatus(conversationDM.status);
            }
            if (!isConversationStatusChange || !this.shouldShowNotification(conversationDM)) continue;
            this.showInAppNotification(conversationDM);
        }
    }

    void putConversations(List<ConversationDM> conversationDMs) {
        for (ConversationDM conversation : conversationDMs) {
            conversation.setDependencies(this.platform, this.domain, this.profileDM);
        }
        this.conversationDAO.insertOrUpdateConversations(conversationDMs);
    }

    private List<ConversationDM> merge(List<ConversationDM> localConversations, List<ConversationDM> serverConversations) {
        HashMap<String, ConversationDM> localConversationsLookup = new HashMap<String, ConversationDM>();
        ArrayList<ConversationDM> mergedConversations = new ArrayList<ConversationDM>();
        for (ConversationDM localConversation : localConversations) {
            localConversationsLookup.put(localConversation.serverId, localConversation);
        }
        for (ConversationDM serverConversation : serverConversations) {
            String serverConversationId = serverConversation.serverId;
            if (localConversationsLookup.containsKey(serverConversationId)) {
                ConversationDM activeConversationFromStorage;
                ConversationDM localConversationDM = (ConversationDM)localConversationsLookup.get(serverConversationId);
                ConversationDM activeConversationDM = this.getInMemoryConversationDM(localConversationDM.localId);
                localConversationDM.setDependencies(this.platform, this.domain, this.profileDM);
                ConversationStatus oldStatus = localConversationDM.status;
                localConversationDM.merge(serverConversation, false);
                mergedConversations.add(localConversationDM);
                if ((activeConversationDM == null || !activeConversationDM.isVisibleOnUI()) && localConversationDM.status == ConversationStatus.REJECTED && (activeConversationFromStorage = this.getActiveConversationFromStorage()) != null && activeConversationFromStorage.localId.equals(localConversationDM.localId)) {
                    localConversationDM.sendConversationEndedDelegate();
                }
                if (activeConversationDM != null && serverConversationId.equals(activeConversationDM.serverId)) {
                    oldStatus = activeConversationDM.status;
                    activeConversationDM.merge(serverConversation, true);
                    activeConversationDM.checkAndIncrementMessageCount(oldStatus);
                    continue;
                }
                localConversationDM.checkAndIncrementMessageCount(oldStatus);
                continue;
            }
            ConversationStatus status = serverConversation.status;
            if (status != null && (status == ConversationStatus.RESOLUTION_ACCEPTED || status == ConversationStatus.RESOLUTION_REJECTED || status == ConversationStatus.REJECTED || status == ConversationStatus.ARCHIVED)) {
                serverConversation.isStartNewConversationClicked = true;
            }
            mergedConversations.add(serverConversation);
        }
        return mergedConversations;
    }

    private Network getFetchConversationUpdatesNetwork() {
        if (this.fetchConversationUpdatesNetwork == null) {
            Network network = new POSTNetwork("/my-issues/", this.domain, this.platform);
            network = new TSCorrectedNetwork(network, this.platform);
            this.fetchConversationUpdatesNetwork = new GuardOKNetwork(network);
        }
        return this.fetchConversationUpdatesNetwork;
    }

    private String generateMessageCursors() {
        HashMap<String, Object> messageCursors = new HashMap<String, Object>();
        List<ConversationDM> conversations = this.conversationDAO.readConversationsWithoutMessages(this.profileLocalId);
        for (ConversationDM conversation : conversations) {
            messageCursors.put(conversation.serverId, conversation.messageCursor);
        }
        return this.platform.getJsonifier().jsonify(messageCursors);
    }

    public ConversationDM getConversationDM(Long conversationLocalId) {
        ConversationDM result = this.getInMemoryConversationDM(conversationLocalId);
        if (result == null) {
            ConversationDM conversationDM = this.conversationDAO.readConversation(conversationLocalId);
            if (conversationDM != null) {
                result = conversationDM;
                result.setDependencies(this.platform, this.domain, this.profileDM);
                result.setLiveUpdateDM(this.liveUpdateDM);
                this.setLastActiveConversation(result);
            }
        } else {
            this.setLastActiveConversation(result);
        }
        return result;
    }

    private ConversationDM getInMemoryConversationDM(Long conversationLocalId) {
        for (Map.Entry<ConversationDM, Long> conversationEntry : this.inMemoryConversationDMs.entrySet()) {
            if (!conversationEntry.getValue().equals(conversationLocalId)) continue;
            return conversationEntry.getKey();
        }
        return null;
    }

    public boolean shouldOpenConversationFromNotification(long conversationLocalId) {
        ConversationDM conversationDM = this.getInMemoryConversationDM(conversationLocalId);
        if (conversationDM == null) {
            conversationDM = this.conversationDAO.readConversation(conversationLocalId);
        }
        if (conversationDM != null) {
            return conversationDM.shouldOpen();
        }
        return false;
    }

    public ConversationDM getActiveConversationFromStorage() {
        ConversationDM activeConversation = null;
        if (!this.sdkConfigurationDM.getBoolean("disableInAppConversation")) {
            List<ConversationDM> conversations = this.conversationDAO.readConversationsWithoutMessages(this.profileLocalId);
            if (conversations.size() == 0) {
                return null;
            }
            ArrayList<ConversationDM> openConversations = new ArrayList<ConversationDM>();
            for (ConversationDM conversation : conversations) {
                if (!conversation.shouldOpen()) continue;
                openConversations.add(conversation);
            }
            if (openConversations.size() > 0) {
                activeConversation = this.findActiveConversation(openConversations);
            }
        }
        return activeConversation;
    }

    public boolean isActiveConversationActionable() {
        ConversationDM activeUIConversationDM = this.getLastActiveConversationDM();
        ConversationDM conversation = activeUIConversationDM == null ? this.getActiveConversationFromStorage() : activeUIConversationDM;
        boolean isActionable = false;
        if (conversation != null) {
            switch (conversation.status) {
                case NEW: 
                case IN_PROGRESS: 
                case RESOLUTION_REQUESTED: {
                    isActionable = true;
                    break;
                }
                case RESOLUTION_REJECTED: {
                    ConversationVMCallback conversationVM = conversation.conversationVMCallback;
                    if (conversationVM == null) {
                        boolean persistMessageBox = this.conversationInboxDAO.getPersistMessageBox(this.profileLocalId);
                        String replyDraft = this.conversationInboxDAO.getUserReplyDraft(this.profileLocalId);
                        isActionable = persistMessageBox || !StringUtils.isEmpty(replyDraft);
                        break;
                    }
                    isActionable = conversationVM.isMessageBoxVisible();
                    break;
                }
                case REJECTED: {
                    isActionable = conversation.isVisibleOnUI();
                }
            }
        }
        return isActionable;
    }

    private ConversationDM findActiveConversation(List<ConversationDM> openConversations) {
        Comparator<ConversationDM> comparator = new Comparator<ConversationDM>(){

            @Override
            public int compare(ConversationDM c1, ConversationDM c2) {
                try {
                    Date m1Date = HSDateFormatSpec.STORAGE_TIME_FORMAT.parse(c1.updatedAt);
                    Date m2Date = HSDateFormatSpec.STORAGE_TIME_FORMAT.parse(c2.updatedAt);
                    if (m1Date.after(m2Date)) {
                        return 1;
                    }
                    if (m1Date.before(m2Date)) {
                        return -1;
                    }
                    return 0;
                }
                catch (ParseException e) {
                    return 0;
                }
            }
        };
        return Collections.max(openConversations, comparator);
    }

    public boolean shouldPersistMessageBox() {
        return this.conversationInboxDAO.getPersistMessageBox(this.profileLocalId);
    }

    public void setPersistMessageBox(boolean value) {
        this.conversationInboxDAO.savePersistMessageBox(this.profileLocalId, value);
    }

    public void setConversationViewState(int conversationViewState) {
        this.conversationViewState = conversationViewState;
    }

    public void handlePushNotification(String conversationServerId, String appName) {
        String notificationTitle;
        int pushCount;
        PushNotificationData pushNotificationData;
        ConversationDM readableConversation = this.conversationDAO.readConversationWithoutMessages(conversationServerId);
        if (StringUtils.isEmpty(appName)) {
            appName = this.platform.getDevice().getAppName();
        }
        if ((pushNotificationData = this.conversationInboxDAO.getPushNotificationData(conversationServerId)) == null) {
            pushCount = 1;
            notificationTitle = appName;
        } else {
            pushCount = pushNotificationData.count + 1;
            notificationTitle = pushNotificationData.title;
        }
        this.conversationInboxDAO.setPushNotificationData(conversationServerId, new PushNotificationData(pushCount, notificationTitle));
        if (this.shouldShowNotification(readableConversation) && pushCount > 0) {
            this.showNotificationOnUI(readableConversation.localId, conversationServerId, pushCount, "push", appName);
        }
    }

    public void resetPushNotificationCount(String conversationServerId) {
        this.conversationInboxDAO.setPushNotificationData(conversationServerId, null);
        this.domain.getDelegate().didReceiveNotification(0);
    }

    public void clearPushNotifications(long profileLocalId) {
        List<ConversationDM> readableConversations = this.conversationDAO.readConversationsWithoutMessages(profileLocalId);
        for (ConversationDM readableConversation : readableConversations) {
            this.clearNotification(readableConversation.serverId);
        }
    }

    public void showPushNotifications(long profileLocalId) {
        List<ConversationDM> conversationDMs = this.conversationDAO.readConversationsWithoutMessages(profileLocalId);
        for (ConversationDM conversationDM : conversationDMs) {
            String conversationServerId = conversationDM.serverId;
            PushNotificationData data = this.conversationInboxDAO.getPushNotificationData(conversationServerId);
            if (data == null || data.count <= 0) continue;
            Long conversationLocalId = conversationDM.localId;
            this.showNotificationOnUI(conversationLocalId, conversationServerId, data.count, "push", data.title);
        }
    }

    public void clearNotification(final String conversationServerId) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                ConversationInboxDM.this.platform.clearNotifications(conversationServerId);
            }
        });
    }

    public int getNotificationCountSync() {
        PushNotificationData data;
        if (this.userCanReadMessages) {
            return 0;
        }
        String conversationServerId = null;
        int unSeenMessageCount = 0;
        ConversationDM conversationDM = this.getActiveConversationFromUIOrStorage();
        if (conversationDM != null) {
            conversationServerId = conversationDM.serverId;
            unSeenMessageCount = conversationDM.getUnSeenMessageCount();
        }
        int pushNotificationCount = 0;
        if (conversationServerId != null && (data = this.conversationInboxDAO.getPushNotificationData(conversationServerId)) != null) {
            pushNotificationCount = data.count;
        }
        return Math.max(unSeenMessageCount, pushNotificationCount);
    }

    public int fetchConversationsAndGetNotificationCount() {
        if (this.profileDM == null || this.profileDM.serverId == null) {
            return -1;
        }
        if (this.userCanReadMessages) {
            return 0;
        }
        this.fetchConversationUpdates();
        int unSeenMessageCount = 0;
        ConversationDM conversationDM = this.getActiveConversationFromUIOrStorage();
        if (conversationDM != null) {
            unSeenMessageCount = conversationDM.getUnSeenMessageCount();
        }
        return unSeenMessageCount;
    }

    private ConversationDM getActiveConversationFromUIOrStorage() {
        ConversationDM readableConversation;
        ConversationDM conversationDM = this.getLastActiveConversationDM();
        if (conversationDM == null && (readableConversation = this.getActiveConversationFromStorage()) != null) {
            conversationDM = readableConversation;
            conversationDM.setDependencies(this.platform, this.domain, this.profileDM);
        }
        return conversationDM;
    }

    public void deleteCachedFilesForResolvedConversations() {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                List<ConversationDM> conversations = ConversationInboxDM.this.conversationDAO.readConversationsWithoutMessages(ConversationInboxDM.this.profileLocalId);
                for (ConversationDM conversationDM : conversations) {
                    if (conversationDM.shouldOpen()) continue;
                    conversationDM.setDependencies(ConversationInboxDM.this.platform, ConversationInboxDM.this.domain, ConversationInboxDM.this.profileDM);
                    conversationDM.deleteCachedScreenshotFiles();
                }
            }
        });
    }

    public static interface StartNewConversationListener {
        public void onCreateConversationSuccess(long var1);

        public void onCreateConversationFailure(Exception var1);
    }

    private class CreateConversationStateHolder {
        final String description;
        final String name;
        final String email;
        final ImagePickerFile imagePickerFile;
        private final F startNewConversationInternalF = new One(new F(){

            @Override
            public void f() {
                ConversationInboxDM.this.startNewConversationInternal(CreateConversationStateHolder.this.description, CreateConversationStateHolder.this.name, CreateConversationStateHolder.this.email, CreateConversationStateHolder.this.imagePickerFile);
            }
        });

        CreateConversationStateHolder(String description, String name, String email, ImagePickerFile imagePickerFile) {
            this.description = description;
            this.name = name;
            this.email = email;
            this.imagePickerFile = imagePickerFile;
        }

        F getStartNewConversationInternalF() {
            return this.startNewConversationInternalF;
        }
    }
}

