/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.dto;

import java.util.HashMap;
import java.util.Map;

public enum ConversationStatus {
    NEW(0),
    IN_PROGRESS(1),
    RESOLUTION_REQUESTED(2),
    REJECTED(3),
    RESOLUTION_ACCEPTED(101),
    RESOLUTION_REJECTED(102),
    ARCHIVED(103),
    UNKNOWN(-1);

    private final int value;
    private static final Map<Integer, ConversationStatus> map;

    private ConversationStatus(int value) {
        this.value = value;
    }

    public static ConversationStatus fromInt(int i) {
        ConversationStatus result = map.get(i);
        if (result == null) {
            return UNKNOWN;
        }
        return result;
    }

    public int getValue() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, ConversationStatus>();
        for (ConversationStatus conversationStatus : ConversationStatus.values()) {
            map.put(conversationStatus.value, conversationStatus);
        }
    }
}

