/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.viewmodel;

import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.conversation.activeconversation.ConversationRenderer;
import com.helpshift.conversation.activeconversation.message.ConversationFooterState;
import com.helpshift.widget.ButtonWidget;
import com.helpshift.widget.ConversationFooterWidget;
import com.helpshift.widget.ReplyFieldWidget;
import com.helpshift.widget.Widget;
import com.helpshift.widget.WidgetMediator;

class ConversationMediator
implements WidgetMediator {
    private ConversationRenderer renderer;
    private Domain domain;
    ButtonWidget attachImageButton;
    ButtonWidget conversationInfoButton;
    ButtonWidget replyButtonWidget;
    ReplyFieldWidget replyFieldWidget;
    ButtonWidget replyBoxWidget;
    ButtonWidget confirmationBoxWidget;
    ConversationFooterWidget conversationFooterWidget;
    private boolean isConversationRejected;

    ConversationMediator(Domain domain) {
        this.domain = domain;
    }

    void setRenderer(ConversationRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public void onChanged(final Widget widget) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (widget == ConversationMediator.this.attachImageButton) {
                    ConversationMediator.this.renderAttachImageButton();
                } else if (widget == ConversationMediator.this.conversationInfoButton) {
                    ConversationMediator.this.renderConversationInfoButton();
                } else if (widget == ConversationMediator.this.replyButtonWidget) {
                    ConversationMediator.this.renderReplyButton();
                } else if (widget == ConversationMediator.this.replyFieldWidget) {
                    ConversationMediator.this.renderReplyButton();
                } else if (widget == ConversationMediator.this.replyBoxWidget) {
                    ConversationMediator.this.renderReplyBoxWidget();
                    ConversationMediator.this.renderAttachImageButton();
                } else if (widget == ConversationMediator.this.confirmationBoxWidget) {
                    ConversationMediator.this.renderConfirmationBoxWidget();
                } else if (widget == ConversationMediator.this.conversationFooterWidget) {
                    ConversationMediator.this.renderConversationFooterWidget();
                }
            }
        });
    }

    void renderAll() {
        this.renderAttachImageButton();
        this.renderConversationInfoButton();
        this.renderReplyButton();
        this.renderReplyBoxWidget();
        this.renderConfirmationBoxWidget();
        this.renderConversationFooterWidget();
    }

    void setAttachImageButton(ButtonWidget attachImageButton) {
        attachImageButton.setMediator(this);
        this.attachImageButton = attachImageButton;
    }

    void setConversationInfoButton(ButtonWidget conversationInfoButton) {
        conversationInfoButton.setMediator(this);
        this.conversationInfoButton = conversationInfoButton;
    }

    void setReplyButtonWidget(ButtonWidget replyButtonWidget) {
        replyButtonWidget.setMediator(this);
        this.replyButtonWidget = replyButtonWidget;
    }

    void setReplyFieldWidget(ReplyFieldWidget replyFieldWidget) {
        replyFieldWidget.setMediator(this);
        this.replyFieldWidget = replyFieldWidget;
    }

    void setReplyBoxWidget(ButtonWidget replyBoxWidget) {
        replyBoxWidget.setMediator(this);
        this.replyBoxWidget = replyBoxWidget;
    }

    void setConfirmationBoxWidget(ButtonWidget confirmationBoxWidget) {
        confirmationBoxWidget.setMediator(this);
        this.confirmationBoxWidget = confirmationBoxWidget;
    }

    void setConversationFooterWidget(ConversationFooterWidget conversationFooterWidget) {
        conversationFooterWidget.setMediator(this);
        this.conversationFooterWidget = conversationFooterWidget;
    }

    void renderAttachImageButton() {
        if (this.renderer != null) {
            if (this.attachImageButton.isVisible() && this.replyBoxWidget.isVisible() && !this.isConversationRejected) {
                this.renderer.showImageAttachmentButton();
            } else {
                this.renderer.hideImageAttachmentButton();
            }
        }
    }

    void renderConversationInfoButton() {
        if (this.renderer != null) {
            if (this.conversationInfoButton.isVisible()) {
                this.renderer.showConversationInformationButton();
            } else {
                this.renderer.hideConversationInformationButton();
            }
        }
    }

    void renderReplyButton() {
        if (StringUtils.isEmpty(this.replyFieldWidget.getReplyText())) {
            if (this.replyButtonWidget.isEnabled()) {
                this.replyButtonWidget.setEnabled(false);
            }
        } else if (!this.replyButtonWidget.isEnabled()) {
            this.replyButtonWidget.setEnabled(true);
        }
        if (this.renderer != null) {
            if (this.replyButtonWidget.isEnabled()) {
                this.renderer.enableSendReplyButton();
            } else {
                this.renderer.disableSendReplyButton();
            }
        }
    }

    void renderReplyBoxWidget() {
        if (this.renderer != null) {
            if (this.replyBoxWidget.isVisible()) {
                this.renderer.showSendReplyUI();
            } else {
                this.renderer.hideSendReplyUI();
            }
        }
    }

    void renderConfirmationBoxWidget() {
        if (this.renderer != null) {
            if (this.confirmationBoxWidget.isVisible()) {
                this.renderer.showConversationResolutionQuestionUI();
            } else {
                this.renderer.hideConversationResolutionQuestionUI();
            }
        }
    }

    void renderConversationFooterWidget() {
        if (this.renderer != null) {
            this.renderer.updateConversationFooterState(this.conversationFooterWidget.getState());
        }
    }

    void showMessageBox() {
        this.replyBoxWidget.setVisible(true);
        this.confirmationBoxWidget.setVisible(false);
        this.conversationFooterWidget.setState(ConversationFooterState.NONE);
    }

    void confirmationBox() {
        this.replyBoxWidget.setVisible(false);
        this.confirmationBoxWidget.setVisible(true);
        this.conversationFooterWidget.setState(ConversationFooterState.CONVERSATION_ENDED_MESSAGE);
    }

    void showStartNewConversation(ConversationFooterState footerState) {
        this.replyBoxWidget.setVisible(false);
        this.confirmationBoxWidget.setVisible(false);
        this.conversationFooterWidget.setState(footerState);
    }

    void setConversationRejected(boolean isConversationRejected) {
        this.isConversationRejected = isConversationRejected;
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                ConversationMediator.this.renderAttachImageButton();
            }
        });
    }
}

