/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.viewmodel;

import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.util.ListObserver;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.ConversationRenderer;
import com.helpshift.conversation.activeconversation.message.AttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.ConversationFooterState;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.RequestAppReviewMessageDM;
import com.helpshift.conversation.domainmodel.ConversationInboxDM;
import com.helpshift.conversation.dto.ConversationStatus;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.conversation.viewmodel.ConversationMediator;
import com.helpshift.conversation.viewmodel.ConversationVMCallback;
import com.helpshift.util.HSLogger;
import com.helpshift.widget.ButtonWidget;
import com.helpshift.widget.ConversationFooterWidget;
import com.helpshift.widget.ReplyFieldWidget;
import com.helpshift.widget.WidgetGateway;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public class ConversationVM
implements ConversationVMCallback,
Observer {
    final ConversationInboxDM conversationInboxDM;
    final ConversationDM conversationDM;
    final SDKConfigurationDM sdkConfigurationDM;
    ConversationRenderer renderer;
    Domain domain;
    private ButtonWidget replyBoxWidget;
    ReplyFieldWidget replyFieldWidget;
    String conversationLaunchSource;
    WidgetGateway widgetGateway;
    private ButtonWidget confirmationBoxWidget;
    private ConversationFooterWidget conversationFooterWidget;
    private ConversationMediator conversationMediator;
    private boolean retainMessageBoxOnUI;
    private static final String TAG = "Helpshift_ConvVM";

    public ConversationVM(Platform platform, Domain domain, ConversationInboxDM conversationInboxDM, ConversationDM conversationDM, ConversationRenderer renderer, boolean retainMessageBoxOnUI) {
        this.domain = domain;
        this.conversationInboxDM = conversationInboxDM;
        this.conversationDM = conversationDM;
        this.sdkConfigurationDM = domain.getSDKConfigurationDM();
        this.retainMessageBoxOnUI = retainMessageBoxOnUI;
        this.sdkConfigurationDM.addObserver(this);
        this.widgetGateway = new WidgetGateway(this.sdkConfigurationDM, conversationInboxDM);
        this.conversationMediator = new ConversationMediator(domain);
        ButtonWidget conversationInfoButton = this.widgetGateway.makeConversationInfoButtonWidget();
        this.conversationMediator.setConversationInfoButton(conversationInfoButton);
        ButtonWidget attachImageButton = this.widgetGateway.makeAttachImageButtonWidget();
        this.conversationMediator.setAttachImageButton(attachImageButton);
        ButtonWidget replyButtonWidget = new ButtonWidget();
        this.replyFieldWidget = this.widgetGateway.makeReplyFieldWidget();
        this.conversationMediator.setReplyButtonWidget(replyButtonWidget);
        this.conversationMediator.setReplyFieldWidget(this.replyFieldWidget);
        boolean shouldShowReplyBoxOnConversationRejected = this.shouldShowReplyBoxOnConversationRejected();
        conversationDM.setEnableMessageClickOnResolutionRejected(shouldShowReplyBoxOnConversationRejected);
        this.replyBoxWidget = this.widgetGateway.makeReplyBoxWidget(conversationDM, shouldShowReplyBoxOnConversationRejected);
        this.conversationMediator.setReplyBoxWidget(this.replyBoxWidget);
        this.confirmationBoxWidget = this.widgetGateway.makeConfirmationBoxWidget(conversationDM);
        this.conversationMediator.setConfirmationBoxWidget(this.confirmationBoxWidget);
        this.conversationFooterWidget = this.widgetGateway.makeConversationFooterWidget(conversationDM, shouldShowReplyBoxOnConversationRejected);
        this.conversationMediator.setConversationFooterWidget(this.conversationFooterWidget);
        if (this.replyBoxWidget.isVisible()) {
            conversationInboxDM.setConversationViewState(2);
        } else {
            conversationInboxDM.setConversationViewState(-1);
        }
        if (!shouldShowReplyBoxOnConversationRejected && conversationDM.status == ConversationStatus.RESOLUTION_REJECTED) {
            conversationDM.sendConversationEndedDelegate();
        }
        this.conversationDM.conversationVMCallback = this;
        this.renderer = renderer;
        this.conversationMediator.setRenderer(this.renderer);
        this.conversationMediator.renderAll();
        conversationDM.initializeConversationStatusForUI();
        conversationDM.initializeMessagesForUI();
        conversationDM.registerMessagesObserver(this.createMessagesListObserver(renderer));
        this.conversationMediator.setConversationRejected(conversationDM.status == ConversationStatus.REJECTED);
        this.renderer.initializeMessages(conversationDM.messageDMs);
        this.renderer.setReply(this.replyFieldWidget.getReplyText());
    }

    public void refreshVM() {
        boolean shouldShowReplyBoxOnConversationRejected = this.shouldShowReplyBoxOnConversationRejected();
        this.widgetGateway.updateReplyBoxWidget(this.replyBoxWidget, this.conversationDM, shouldShowReplyBoxOnConversationRejected);
        this.widgetGateway.updateConfirmationBoxWidget(this.confirmationBoxWidget, this.conversationDM);
        this.widgetGateway.updateConversationFooterWidget(this.conversationFooterWidget, this.conversationDM, shouldShowReplyBoxOnConversationRejected);
        if (this.replyBoxWidget.isVisible()) {
            this.conversationInboxDM.setConversationViewState(2);
        } else {
            this.conversationInboxDM.setConversationViewState(-1);
        }
        this.conversationDM.registerMessagesObserver(this.createMessagesListObserver(this.renderer));
        this.conversationDM.conversationVMCallback = this;
    }

    public void unregisterRenderer() {
        if (this.conversationDM.status == ConversationStatus.REJECTED) {
            this.conversationDM.sendConversationEndedDelegate();
        }
        this.renderer = null;
        this.conversationMediator.setRenderer(null);
        this.sdkConfigurationDM.deleteObserver(this);
    }

    public void setUserCanReadMessages(boolean value) {
        this.conversationInboxDM.setUserCanReadMessages(value);
        this.onAgentTypingUpdate(this.conversationDM.isAgentTyping());
    }

    public void setConversationLaunchSource(final String launchSource) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                ConversationVM.this.conversationLaunchSource = launchSource;
            }
        });
    }

    private ListObserver createMessagesListObserver(final ConversationRenderer renderer) {
        return new ListObserver(){

            @Override
            public void add(int index, int count) {
                renderer.addMessages(index, count);
            }

            @Override
            public void update(int index, int count) {
                renderer.updateMessages(index, count);
            }
        };
    }

    public void setReply(final String reply) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                ConversationVM.this.replyFieldWidget.setReplyText(reply);
                ConversationVM.this.widgetGateway.saveReplyText(reply);
            }
        });
    }

    public void sendTextMessage() {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                String reply = ConversationVM.this.replyFieldWidget.getReplyText();
                if (!StringUtils.isEmpty(reply)) {
                    final String replyToBeSent = reply;
                    ConversationVM.this.domain.runOnUI(new F(){

                        @Override
                        public void f() {
                            if (ConversationVM.this.renderer != null) {
                                ConversationVM.this.renderer.setReply("");
                            }
                        }
                    });
                    ConversationVM.this.domain.runParallel(new F(){

                        @Override
                        public void f() {
                            ConversationVM.this.conversationInboxDM.setPersistMessageBox(true);
                            ConversationVM.this.conversationDM.sendTextMessage(replyToBeSent);
                        }
                    });
                }
            }
        });
    }

    public void retryMessage(final MessageDM readableMessage) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                ConversationVM.this.domain.runParallel(new F(){

                    @Override
                    public void f() {
                        ConversationVM.this.conversationDM.retryMessage(readableMessage);
                    }
                });
            }
        });
    }

    public void handleAppReviewRequestClick(final RequestAppReviewMessageDM requestAppReviewMessageDM) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                final String reviewUrl = ConversationVM.this.sdkConfigurationDM.getString("reviewUrl").trim();
                if (!StringUtils.isEmpty(reviewUrl)) {
                    ConversationVM.this.sdkConfigurationDM.setAppReviewed(true);
                    ConversationVM.this.domain.runOnUI(new F(){

                        @Override
                        public void f() {
                            if (ConversationVM.this.renderer != null) {
                                ConversationVM.this.renderer.openAppReviewStore(reviewUrl);
                            }
                        }
                    });
                }
                ConversationVM.this.conversationDM.handleAppReviewRequestClick(requestAppReviewMessageDM);
            }
        });
    }

    @Override
    public boolean isMessageBoxVisible() {
        return this.replyBoxWidget.isVisible();
    }

    @Override
    public boolean isVisibleOnUI() {
        return this.renderer != null;
    }

    @Override
    public String getConversationLaunchSource() {
        return this.conversationLaunchSource;
    }

    @Override
    public void onAgentTypingUpdate(final boolean isAgentTyping) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ConversationVM.this.renderer != null) {
                    if (ConversationVM.this.conversationDM.status == ConversationStatus.NEW || ConversationVM.this.conversationDM.status == ConversationStatus.IN_PROGRESS) {
                        ConversationVM.this.renderer.updateAgentTypingIndicator(isAgentTyping);
                    } else {
                        ConversationVM.this.renderer.updateAgentTypingIndicator(false);
                    }
                }
            }
        });
    }

    public void sendScreenShot(final ImagePickerFile imagePickerFile, final String referId) {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                ConversationVM.this.conversationDM.sendScreenshot(imagePickerFile, referId);
            }
        });
    }

    public void handleAdminAttachmentMessageClick(final AttachmentMessageDM message) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                ConversationVM.this.conversationDM.onAdminAttachmentMessageClicked(message);
            }
        });
    }

    @Override
    public void launchAttachment(final String filePath, final String contentType) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ConversationVM.this.renderer != null) {
                    ConversationVM.this.renderer.launchAttachment(filePath, contentType);
                }
            }
        });
    }

    public void markConversationResolutionStatus(final boolean accepted) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                HSLogger.d(ConversationVM.TAG, "Sending resolution event : Accepted? " + accepted);
                if (ConversationVM.this.conversationDM.status == ConversationStatus.RESOLUTION_REQUESTED) {
                    ConversationVM.this.conversationDM.markConversationResolutionStatus(accepted);
                }
            }
        });
    }

    public void markMessagesAsSeen() {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                ConversationVM.this.conversationDM.markMessagesAsSeen(ConversationVM.this.conversationLaunchSource);
            }
        });
    }

    public void renderMenuItems() {
        this.conversationMediator.renderAll();
    }

    public void onConversationInfoButtonClick() {
        if (this.renderer != null) {
            this.renderer.showConversationInfoScreen(this.conversationDM.serverId, this.conversationDM.publishId);
        }
    }

    @Override
    public void onConversationStatusChange(ConversationStatus newStatus) {
        boolean isConversationRejected = false;
        int conversationViewState = -1;
        boolean hideAgentTypingIndicator = true;
        HSLogger.d(TAG, "Changing conversation status to: " + (Object)((Object)newStatus));
        switch (newStatus) {
            case NEW: 
            case IN_PROGRESS: {
                this.conversationMediator.showMessageBox();
                conversationViewState = 2;
                hideAgentTypingIndicator = false;
                break;
            }
            case RESOLUTION_REQUESTED: {
                this.conversationInboxDM.setPersistMessageBox(false);
                if (this.sdkConfigurationDM.getBoolean("showConversationResolutionQuestion")) {
                    this.conversationMediator.confirmationBox();
                    break;
                }
                this.markConversationResolutionStatus(true);
                break;
            }
            case REJECTED: {
                isConversationRejected = true;
                conversationViewState = 2;
                break;
            }
            case RESOLUTION_ACCEPTED: {
                this.widgetGateway.saveReplyText("");
                this.conversationInboxDM.setPersistMessageBox(false);
                if (this.conversationDM.shouldShowCSATInFooter()) {
                    this.conversationMediator.showStartNewConversation(ConversationFooterState.CSAT_RATING);
                    break;
                }
                this.conversationMediator.showStartNewConversation(ConversationFooterState.START_NEW_CONVERSATION);
                break;
            }
            case RESOLUTION_REJECTED: {
                this.conversationMediator.showMessageBox();
                this.conversationDM.setEnableMessageClickOnResolutionRejected(true);
                conversationViewState = 2;
                break;
            }
            case ARCHIVED: {
                this.conversationMediator.showStartNewConversation(ConversationFooterState.ARCHIVAL_MESSAGE);
            }
        }
        if (hideAgentTypingIndicator) {
            this.onAgentTypingUpdate(false);
        }
        this.conversationInboxDM.setConversationViewState(conversationViewState);
        this.conversationMediator.setConversationRejected(isConversationRejected);
    }

    public void onImageAttachmentButtonClick() {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                ConversationVM.this.conversationInboxDM.setPersistMessageBox(true);
            }
        });
    }

    private boolean shouldShowReplyBoxOnConversationRejected() {
        return !StringUtils.isEmpty(this.conversationInboxDM.getUserReplyText()) || this.conversationInboxDM.shouldPersistMessageBox() || this.retainMessageBoxOnUI;
    }

    public void onCSATSurveySubmitted(final int rating, final String feedback) {
        if (this.renderer != null) {
            this.renderer.showCSATSubmittedView();
        }
        if (this.conversationDM.status != ConversationStatus.NEW && this.conversationDM.status != ConversationStatus.IN_PROGRESS) {
            this.conversationMediator.showStartNewConversation(ConversationFooterState.START_NEW_CONVERSATION);
        }
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                HSLogger.d(ConversationVM.TAG, "Sending CSAT rating : " + rating + ", feedback: " + feedback);
                ConversationVM.this.conversationDM.sendCSATSurvey(rating, feedback);
            }
        });
    }

    public void setConversationViewState(int conversationViewState) {
        this.conversationInboxDM.setConversationViewState(conversationViewState);
    }

    public void onNewConversationButtonClicked() {
        this.stopLiveUpdates();
        this.conversationDM.setStartNewConversationButtonClicked(true, true);
    }

    public void clearNotifications() {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                ConversationVM.this.conversationInboxDM.clearNotification(ConversationVM.this.conversationDM.serverId);
                ConversationVM.this.conversationInboxDM.resetPushNotificationCount(ConversationVM.this.conversationDM.serverId);
            }
        });
    }

    public void resetIncrementMessageCountFlag() {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                ConversationVM.this.conversationDM.setShouldIncrementMessageCount(false, true);
            }
        });
    }

    public void pushAnalyticsEvent(AnalyticsEventType type, Map<String, Object> data) {
        switch (type) {
            case OPEN_ISSUE: {
                data = new HashMap<String, Object>();
                data.put("id", this.conversationDM.serverId);
            }
        }
        this.domain.getAnalyticsEventDM().pushEvent(type, data);
    }

    public void onAdminMessageLinkClicked(String url) {
        String protocol = null;
        try {
            URI uri = URI.create(url);
            if (uri != null) {
                protocol = uri.getScheme();
            }
        }
        catch (Exception uri) {
            // empty catch block
        }
        if (!StringUtils.isEmpty(protocol)) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", this.conversationDM.serverId);
            data.put("p", protocol);
            data.put("u", url);
            this.pushAnalyticsEvent(AnalyticsEventType.ADMIN_MESSAGE_DEEPLINK_CLICKED, data);
        }
    }

    public void startLiveUpdates() {
        this.conversationDM.startLiveUpdates();
    }

    public void stopLiveUpdates() {
        this.conversationDM.stopLiveUpdates();
    }

    @Override
    public void update(final Observable observable, Object o) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ConversationVM.this.renderer != null && observable instanceof SDKConfigurationDM) {
                    ConversationVM.this.renderer.updateMessages(0, ConversationVM.this.conversationDM.messageDMs.size());
                }
            }
        });
    }
}

