/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.viewmodel;

import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.conversation.domainmodel.ConversationInboxDM;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.conversation.viewmodel.NewConversationMediator;
import com.helpshift.conversation.viewmodel.NewConversationRenderer;
import com.helpshift.util.HSLogger;
import com.helpshift.widget.ButtonWidget;
import com.helpshift.widget.DescriptionWidget;
import com.helpshift.widget.EmailWidget;
import com.helpshift.widget.ImageAttachmentWidget;
import com.helpshift.widget.NameWidget;
import com.helpshift.widget.ProfileFormWidget;
import com.helpshift.widget.ProgressBarWidget;
import com.helpshift.widget.WidgetGateway;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class NewConversationVM
implements ConversationInboxDM.StartNewConversationListener {
    final Domain domain;
    final SDKConfigurationDM sdkConfigurationDM;
    final ConversationInboxDM conversationInboxDM;
    final WidgetGateway widgetGateway;
    final NewConversationMediator mediator;
    final DescriptionWidget descriptionWidget;
    final NameWidget nameWidget;
    final EmailWidget emailWidget;
    final ImageAttachmentWidget imageAttachmentWidget;
    final ProgressBarWidget progressBarWidget;
    WeakReference<NewConversationRenderer> rendererWeakRef;
    boolean wasSearchPerformed = false;
    private static final String TAG = "Helpshift_NewConvVM";

    public NewConversationVM(Platform platform, Domain domain, ConversationInboxDM conversationInboxDM, NewConversationRenderer renderer) {
        this.domain = domain;
        this.sdkConfigurationDM = domain.getSDKConfigurationDM();
        this.conversationInboxDM = conversationInboxDM;
        this.widgetGateway = new WidgetGateway(this.sdkConfigurationDM, conversationInboxDM);
        this.descriptionWidget = this.widgetGateway.makeDescriptionWidget();
        this.nameWidget = this.widgetGateway.makeNameWidget();
        this.emailWidget = this.widgetGateway.makeEmailWidget();
        this.imageAttachmentWidget = this.widgetGateway.makeImageAttachmentWidget();
        this.progressBarWidget = this.widgetGateway.makeProgressBarWidget();
        ProfileFormWidget profileFormWidget = this.widgetGateway.makeProfileFormWidget(this.nameWidget, this.emailWidget);
        ButtonWidget attachImageButton = this.widgetGateway.makeNewConversationAttachImageButtonWidget(this.imageAttachmentWidget);
        ButtonWidget startConversationButton = this.widgetGateway.makeStartConversationButtonWidget();
        this.mediator = new NewConversationMediator(renderer, domain);
        this.mediator.setDescriptionWidget(this.descriptionWidget);
        this.mediator.setNameWidget(this.nameWidget);
        this.mediator.setEmailWidget(this.emailWidget);
        this.mediator.setImageAttachmentWidget(this.imageAttachmentWidget);
        this.mediator.setStartConversationButton(startConversationButton);
        this.mediator.setAttachImageButton(attachImageButton);
        this.mediator.setProgressBarWidget(this.progressBarWidget);
        this.mediator.setProfileFormWidget(profileFormWidget);
        conversationInboxDM.registerStartNewConversationListener(this);
        this.rendererWeakRef = new WeakReference<NewConversationRenderer>(renderer);
        this.mediator.setRenderer(renderer);
    }

    public void setDescription(final String description) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                String lastText = NewConversationVM.this.descriptionWidget.getText();
                NewConversationVM.this.descriptionWidget.setText(description);
                if (!lastText.equals(description)) {
                    NewConversationVM.this.widgetGateway.save(NewConversationVM.this.descriptionWidget);
                }
            }
        });
    }

    public void setName(final String name) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                NewConversationVM.this.nameWidget.setText(name);
            }
        });
    }

    public void setWasSearchPerformed(final boolean searchPerformed) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                NewConversationVM.this.wasSearchPerformed = searchPerformed;
                if (NewConversationVM.this.shouldShowSearchOnNewConversation()) {
                    NewConversationVM.this.conversationInboxDM.triggerFAQSearchIndexing();
                }
            }
        });
    }

    public void showSearchOrStartNewConversation() {
        this.showSearchOrStartNewConversationInternal(true);
    }

    public void startNewConversation() {
        this.showSearchOrStartNewConversationInternal(false);
    }

    private void showSearchOrStartNewConversationInternal(final boolean checkForShowingSearch) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                if (NewConversationVM.this.isFormValid()) {
                    ArrayList searchResults;
                    if (checkForShowingSearch && NewConversationVM.this.shouldShowSearchOnNewConversation() && (searchResults = NewConversationVM.this.conversationInboxDM.getFAQSearchResults(NewConversationVM.this.descriptionWidget.getText())).size() > 0) {
                        if (NewConversationVM.this.rendererWeakRef.get() != null) {
                            ((NewConversationRenderer)NewConversationVM.this.rendererWeakRef.get()).showSearchResultFragment(searchResults);
                        }
                        return;
                    }
                    HSLogger.d(NewConversationVM.TAG, "Creating new conversation");
                    NewConversationVM.this.progressBarWidget.setVisible(true);
                    NewConversationVM.this.conversationInboxDM.startNewConversation(NewConversationVM.this.descriptionWidget.getText(), NewConversationVM.this.nameWidget.getText(), NewConversationVM.this.emailWidget.getText(), NewConversationVM.this.imageAttachmentWidget.getImagePickerFile());
                }
            }
        });
    }

    boolean shouldShowSearchOnNewConversation() {
        return !this.wasSearchPerformed && this.sdkConfigurationDM.getBoolean("showSearchOnNewConversation");
    }

    @Override
    public void onCreateConversationSuccess(final long conversationId) {
        this.progressBarWidget.setVisible(false);
        this.descriptionWidget.setText(null);
        this.imageAttachmentWidget.setImagePickerFile(null);
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (NewConversationVM.this.rendererWeakRef.get() != null) {
                    NewConversationRenderer renderer = (NewConversationRenderer)NewConversationVM.this.rendererWeakRef.get();
                    if (NewConversationVM.this.sdkConfigurationDM.getBoolean("gotoConversationAfterContactUs") && !NewConversationVM.this.sdkConfigurationDM.getBoolean("disableInAppConversation")) {
                        renderer.gotoConversation(conversationId);
                    } else {
                        renderer.showConversationStartedMessage();
                        renderer.exit();
                    }
                }
            }
        });
    }

    @Override
    public void onCreateConversationFailure(Exception e) {
        this.progressBarWidget.setVisible(false);
        this.handleException(e);
    }

    public void unregisterRenderer(NewConversationRenderer renderer) {
        if (this.rendererWeakRef != null && this.rendererWeakRef.get() == renderer) {
            this.rendererWeakRef = new WeakReference<Object>(null);
        }
        this.conversationInboxDM.unregisterStartNewConversationListener(this);
    }

    private void handleException(final Exception e) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (e instanceof RootAPIException) {
                    RootAPIException ex = (RootAPIException)e;
                    if (NewConversationVM.this.rendererWeakRef.get() != null) {
                        NewConversationRenderer renderer = (NewConversationRenderer)NewConversationVM.this.rendererWeakRef.get();
                        renderer.showErrorView(ex.exceptionType);
                    }
                }
            }
        });
    }

    boolean isFormValid() {
        this.descriptionWidget.validateText();
        this.nameWidget.validateText();
        this.emailWidget.validateText();
        return this.descriptionWidget.getError() == null && this.nameWidget.getError() == null && this.emailWidget.getError() == null;
    }

    public void setEmail(final String email) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                NewConversationVM.this.emailWidget.setText(email);
            }
        });
    }

    public void setSearchQuery(final String searchQuery) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                if (StringUtils.isEmpty(NewConversationVM.this.descriptionWidget.getText()) && !StringUtils.isEmpty(searchQuery)) {
                    String searchDescription = searchQuery.substring(0, 1).toUpperCase() + searchQuery.substring(1);
                    NewConversationVM.this.descriptionWidget.setText(searchDescription);
                }
            }
        });
    }

    public void handleImageAttachmentClearButtonClick() {
        if (this.progressBarWidget.isVisible()) {
            return;
        }
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                ImagePickerFile attachmentDraft = NewConversationVM.this.imageAttachmentWidget.getImagePickerFile();
                if (attachmentDraft != null && attachmentDraft.filePath != null) {
                    NewConversationVM.this.domain.getAttachmentFileManagerDM().deleteAttachmentLocalCopy(attachmentDraft);
                }
            }
        });
        this.setImageAttachment(null);
    }

    public void setImageAttachment(final ImagePickerFile imagePickerFile) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                NewConversationVM.this.imageAttachmentWidget.setImagePickerFile(imagePickerFile);
                NewConversationVM.this.widgetGateway.save(NewConversationVM.this.imageAttachmentWidget);
            }
        });
    }

    public void handleImageAttachmentClick() {
        if (this.progressBarWidget.isVisible()) {
            return;
        }
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                final ImagePickerFile attachmentFile = NewConversationVM.this.imageAttachmentWidget.getImagePickerFile();
                if (attachmentFile != null && !StringUtils.isEmpty(attachmentFile.filePath)) {
                    NewConversationVM.this.domain.runOnUI(new F(){

                        @Override
                        public void f() {
                            if (NewConversationVM.this.rendererWeakRef.get() != null) {
                                ((NewConversationRenderer)NewConversationVM.this.rendererWeakRef.get()).showAttachmentPreviewScreenFromDraft(attachmentFile);
                            }
                        }
                    });
                }
            }
        });
    }

    public void initialize() {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                NewConversationVM.this.domain.runOnUI(new F(){

                    @Override
                    public void f() {
                        NewConversationVM.this.mediator.renderAll();
                    }
                });
            }
        });
    }

    public void setShouldDropCustomMetadata(final boolean dropMetadata) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                NewConversationVM.this.conversationInboxDM.setShouldDropCustomMetadata(dropMetadata);
            }
        });
    }

    public void setConversationViewState(final int conversationViewState) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                NewConversationVM.this.conversationInboxDM.setConversationViewState(conversationViewState);
            }
        });
    }
}

