/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.executors;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.helpshift.R;
import com.helpshift.app.MainLifecycleCallback;
import com.helpshift.enums.ACTION_TYPE;
import com.helpshift.executors.ActionExecutor;
import com.helpshift.support.Support;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.views.HSToast;
import java.util.HashMap;

public class SupportCampaignsActionExecutor
implements ActionExecutor {
    private static final long serialVersionUID = 4544014913056857162L;

    @Override
    public void executeAction(Activity activity, ACTION_TYPE actionType, String actionData) {
        switch (actionType) {
            case OPEN_DEEP_LINK: {
                Intent deepLinkIntent = new Intent("android.intent.action.VIEW");
                deepLinkIntent.setData(Uri.parse((String)actionData));
                if (deepLinkIntent.resolveActivity(activity.getPackageManager()) != null) {
                    activity.startActivity(deepLinkIntent);
                    break;
                }
                HSToast.makeText((Context)activity, activity.getResources().getString(R.string.hs__could_not_open_attachment_msg), 0).show();
                break;
            }
            case SHOW_FAQS: {
                Support.showFAQs(activity);
                break;
            }
            case SHOW_FAQ_SECTION: {
                Support.showFAQSection(activity, actionData);
                break;
            }
            case SHOW_CONVERSATION: {
                HashMap<String, Object> config = new HashMap<String, Object>();
                config.put("conversationPrefillText", actionData);
                Support.showConversation(activity, config);
                break;
            }
            case SHOW_SINGLE_FAQ: {
                Support.showSingleFAQ(activity, actionData);
                break;
            }
            case SHOW_ALERT_TO_RATE_APP: {
                Support.showAlertToRateApp(actionData, null);
                break;
            }
            default: {
                Intent launchIntent;
                if (MainLifecycleCallback.isForeground() || (launchIntent = ApplicationUtil.getLaunchIntent(activity.getApplicationContext(), activity.getPackageName())) == null) break;
                activity.startActivity(launchIntent);
            }
        }
    }
}

