/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.faq;

import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.AutoRetriableDM;
import com.helpshift.common.AutoRetryFailedEventDM;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.network.FailedAPICallNetworkDecorator;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.faq.dao.FaqEventDAO;
import java.util.HashMap;
import java.util.Map;

public class FaqsDM
implements AutoRetriableDM {
    final Domain domain;
    private final Platform platform;
    FaqEventDAO faqEventDAO;

    public FaqsDM(Domain domain, Platform platform) {
        this.domain = domain;
        this.platform = platform;
        this.faqEventDAO = platform.getFaqEventDAO();
        this.domain.getAutoRetryFailedEventDM().register(AutoRetryFailedEventDM.EventType.FAQ, this);
    }

    public void markHelpful(final String faqId, final boolean isHelpful) {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                block2: {
                    try {
                        FaqsDM.this.send(faqId, isHelpful);
                    }
                    catch (RootAPIException e) {
                        if (e.exceptionType == NetworkException.NON_RETRIABLE) break block2;
                        FaqsDM.this.faqEventDAO.insertFaqMarkHelpfulEvent(faqId, isHelpful);
                        FaqsDM.this.domain.getAutoRetryFailedEventDM().scheduleRetryTaskForEventType(AutoRetryFailedEventDM.EventType.FAQ, e.getServerStatusCode());
                        throw e;
                    }
                }
            }
        });
        AnalyticsEventType eventType = isHelpful ? AnalyticsEventType.MARKED_HELPFUL : AnalyticsEventType.MARKED_UNHELPFUL;
        this.domain.getAnalyticsEventDM().pushEvent(eventType, faqId);
    }

    @Override
    public void sendFailedApiCalls() {
        Map<String, Boolean> unSentFaqEvents = this.faqEventDAO.getUnSentFaqMarkHelpfulEvents();
        if (unSentFaqEvents != null) {
            for (String faqId : unSentFaqEvents.keySet()) {
                Boolean isHelpful = unSentFaqEvents.get(faqId);
                try {
                    this.send(faqId, isHelpful);
                    this.faqEventDAO.removeFaqMarkHelpfulEvent(faqId);
                }
                catch (RootAPIException e) {
                    if (e.exceptionType == NetworkException.NON_RETRIABLE) {
                        this.faqEventDAO.removeFaqMarkHelpfulEvent(faqId);
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    void send(String faqId, boolean isHelpful) {
        String route = isHelpful ? "/faqs/" + faqId + "/helpful/" : "/faqs/" + faqId + "/unhelpful/";
        Network sendMessageNetwork = new POSTNetwork(route, this.domain, this.platform);
        sendMessageNetwork = new FailedAPICallNetworkDecorator(sendMessageNetwork);
        sendMessageNetwork = new TSCorrectedNetwork(sendMessageNetwork, this.platform);
        sendMessageNetwork = new GuardOKNetwork(sendMessageNetwork);
        sendMessageNetwork.makeRequest(new HashMap<String, String>());
    }
}

