/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.localeprovider.domainmodel;

import com.helpshift.common.StringUtils;
import com.helpshift.common.platform.Device;
import com.helpshift.common.platform.Platform;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import java.util.Locale;

public class LocaleProviderDM {
    private SDKConfigurationDM sdkConfigurationDM;
    private Device device;
    private Locale previousLocale;

    public LocaleProviderDM(SDKConfigurationDM sdkConfigurationDM, Platform platform) {
        this.sdkConfigurationDM = sdkConfigurationDM;
        this.device = platform.getDevice();
    }

    public void backupApplicationLocale() {
        if (this.previousLocale == null) {
            this.previousLocale = this.device.getLocale();
        }
    }

    public void restoreApplicationLocale() {
        if (this.previousLocale != null) {
            this.device.changeLocale(this.previousLocale);
            this.previousLocale = null;
        }
    }

    public Locale getCurrentLocale() {
        Locale locale;
        String language = this.sdkConfigurationDM.getString("sdkLanguage");
        if (StringUtils.isEmpty(language)) {
            locale = Locale.getDefault();
        } else if (language.contains("_")) {
            String[] languageArray = language.split("_");
            locale = new Locale(languageArray[0], languageArray[1]);
        } else {
            locale = new Locale(language);
        }
        return locale;
    }

    public Locale getCurrentLocaleFromStorage() {
        String language = this.sdkConfigurationDM.getString("sdkLanguage");
        Locale locale = null;
        if (!StringUtils.isEmpty(language)) {
            if (language.contains("_")) {
                String[] languageArray = language.split("_");
                locale = new Locale(languageArray[0], languageArray[1]);
            } else {
                locale = new Locale(language);
            }
        }
        return locale;
    }

    public String getAcceptLanguageHeader() {
        String sdkLanguage = this.sdkConfigurationDM.getString("sdkLanguage");
        if (StringUtils.isEmpty(sdkLanguage)) {
            return Locale.getDefault().toString();
        }
        return sdkLanguage;
    }
}

