/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.logger;

import android.text.TextUtils;
import android.util.Log;
import com.helpshift.logger.LogMessage;
import com.helpshift.logger.database.LogStorage;
import com.helpshift.logger.logmodels.ILogExtrasModel;
import com.helpshift.logger.model.LogModel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

class WorkerThread
implements Runnable {
    private LogMessage logMessage;
    private LogStorage logStorage;
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", Locale.US);

    WorkerThread(LogMessage logMessage, LogStorage logStorage) {
        this.logMessage = logMessage;
        this.logStorage = logStorage;
    }

    @Override
    public void run() {
        try {
            if (this.logMessage != null) {
                Date date = new Date(this.logMessage.timeStamp);
                String formattedDateTime = simpleDateFormat.format(date);
                if (!TextUtils.isEmpty((CharSequence)this.logMessage.message) && this.logMessage.message.length() > 5000) {
                    this.logMessage.message = this.logMessage.message.substring(0, 5000);
                }
                LogModel logModel = new LogModel(formattedDateTime, this.logMessage.level, this.logMessage.message, this.logMessage.stacktrace, this.convertExtrasToJSON(this.logMessage.extras));
                this.logStorage.insert(logModel);
            }
        }
        catch (Exception e) {
            Log.e((String)"LogWorkerThread", (String)"Exception in log messages worker : ", (Throwable)e);
        }
    }

    private String convertExtrasToJSON(ILogExtrasModel[] extras) {
        JSONArray extrasJSONArray = new JSONArray();
        if (extras == null || extras.length == 0) {
            return extrasJSONArray.toString();
        }
        for (ILogExtrasModel extra : extras) {
            if (extra == null) continue;
            if (extrasJSONArray.length() > 20) break;
            JSONObject extraJSON = (JSONObject)extra.toJSONObject();
            if (extraJSON.toString().length() > 5000) continue;
            extrasJSONArray.put((Object)extraJSON);
        }
        return extrasJSONArray.toString();
    }
}

