/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.model;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.util.SchemaUtil;
import java.io.Serializable;

public class AppInfoModel {
    public String apiKey;
    public String domainName;
    public String platformId;
    private String fontPath;
    private KeyValueStorage storage;
    public Integer notificationSoundId;
    public Integer notificationIconId;
    public Integer largeNotificationIconId;
    public Boolean disableHelpshiftBranding;
    public Boolean enableInboxPolling;
    public Boolean muteNotifications;
    public Boolean disableAnimations;
    public Integer screenOrientation;
    public String campaignsNotificationChannelId;

    protected AppInfoModel(KeyValueStorage kvStore) {
        this.storage = kvStore;
        this.apiKey = (String)this.storage.get("apiKey");
        this.domainName = (String)this.storage.get("domainName");
        if (this.domainName != null && !SchemaUtil.validateDomainName(this.domainName)) {
            this.domainName = null;
        }
        this.platformId = (String)this.storage.get("platformId");
        if (this.platformId != null && !SchemaUtil.validatePlatformId(this.platformId)) {
            this.platformId = null;
        }
        this.fontPath = (String)this.storage.get("font");
        this.notificationSoundId = (Integer)this.storage.get("notificationSound");
        this.notificationIconId = (Integer)this.storage.get("notificationIcon");
        this.largeNotificationIconId = (Integer)this.storage.get("largeNotificationIcon");
        this.disableHelpshiftBranding = (Boolean)this.storage.get("disableHelpshiftBranding");
        this.enableInboxPolling = (Boolean)this.storage.get("enableInboxPolling");
        this.muteNotifications = (Boolean)this.storage.get("muteNotifications");
        this.disableAnimations = (Boolean)this.storage.get("disableAnimations");
        this.screenOrientation = (Integer)this.storage.get("screenOrientation");
        this.campaignsNotificationChannelId = (String)this.storage.get("campaignsNotificationChannelId");
    }

    @Nullable
    public String getFontPath() {
        return this.fontPath;
    }

    public void setFontPath(String fontPath) {
        this.fontPath = fontPath;
        this.storage.set("font", (Serializable)((Object)fontPath));
    }

    public void setNotificationSoundId(Integer notificationSoundId) {
        this.notificationSoundId = notificationSoundId;
        this.storage.set("notificationSound", this.notificationSoundId);
    }

    public void setNotificationIconId(Integer notificationIconId) {
        this.notificationIconId = notificationIconId;
        this.storage.set("notificationIcon", this.notificationIconId);
    }

    public void setScreenOrientation(Integer screenOrientation) {
        this.screenOrientation = screenOrientation;
        this.storage.set("screenOrientation", this.screenOrientation);
    }

    public void setLargeNotificationIconId(Integer largeNotificationIconId) {
        this.largeNotificationIconId = largeNotificationIconId;
        this.storage.set("largeNotificationIcon", this.largeNotificationIconId);
    }

    public void setDisableHelpshiftBranding(Boolean disableHelpshiftBranding) {
        this.disableHelpshiftBranding = disableHelpshiftBranding;
        this.storage.set("disableHelpshiftBranding", disableHelpshiftBranding);
    }

    public void setEnableInboxPolling(Boolean enableInboxPolling) {
        this.enableInboxPolling = enableInboxPolling;
        this.storage.set("enableInboxPolling", enableInboxPolling);
    }

    public void setDisableAnimations(Boolean disableAnimations) {
        this.disableAnimations = disableAnimations;
        this.storage.set("disableAnimations", disableAnimations);
    }

    public void setMuteNotifications(Boolean muteNotifications) {
        this.muteNotifications = muteNotifications;
        this.storage.set("muteNotifications", muteNotifications);
    }

    public void setCampaignsNotificationChannelId(String campaignsNotificationChannelId) {
        this.campaignsNotificationChannelId = campaignsNotificationChannelId;
        this.storage.set("campaignsNotificationChannelId", (Serializable)((Object)campaignsNotificationChannelId));
    }

    public void install(String apiKey, String domainName, String platformId) {
        this.apiKey = apiKey;
        this.domainName = domainName;
        this.platformId = platformId;
        if (this.domainName != null && !SchemaUtil.validateDomainName(this.domainName)) {
            this.domainName = null;
        }
        if (this.platformId != null && !SchemaUtil.validatePlatformId(this.platformId)) {
            this.platformId = null;
        }
        this.storage.set("apiKey", (Serializable)((Object)this.apiKey));
        this.storage.set("domainName", (Serializable)((Object)this.domainName));
        this.storage.set("platformId", (Serializable)((Object)this.platformId));
    }

    public boolean isInstalled() {
        return !TextUtils.isEmpty((CharSequence)this.apiKey) && !TextUtils.isEmpty((CharSequence)this.domainName) && !TextUtils.isEmpty((CharSequence)this.platformId);
    }
}

