/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.model;

import android.text.TextUtils;
import com.helpshift.storage.KeyValueStorage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;

public class SdkInfoModel {
    private HashMap<String, String> etags;
    private KeyValueStorage storage;
    private static final String CHANGE_SET_ID_PREFIX = "hs__change_set_id:";

    protected SdkInfoModel(KeyValueStorage kvStore) {
        this.storage = kvStore;
        this.etags = (HashMap)this.storage.get("etags");
        if (this.etags == null) {
            this.etags = new HashMap();
        }
    }

    public void addEtag(String etag, String route) {
        this.etags.put(route, etag);
        this.storage.set("etags", this.etags);
    }

    public String getEtag(String route) {
        return this.etags.get(route);
    }

    public void clearEtag(String route) {
        if (this.etags.containsKey(route)) {
            this.etags.remove(route);
            this.storage.set("etags", this.etags);
        }
    }

    public Float getServerTimeDelta() {
        return (Float)this.storage.get("server-time-delta");
    }

    public void setServerTimeDelta(Float serverTimeDelta) {
        this.storage.set("server-time-delta", serverTimeDelta);
    }

    public String getCurrentLoggedInId() {
        return (String)this.storage.get("current-logged-in-id");
    }

    public void setCurrentLoggedInId(String identifier) throws IllegalArgumentException {
        if (identifier != null) {
            identifier = identifier.trim();
        }
        if (TextUtils.isEmpty((CharSequence)identifier)) {
            throw new IllegalArgumentException();
        }
        this.storage.set("current-logged-in-id", (Serializable)((Object)identifier));
    }

    public void addDeviceId(String deviceId) throws IllegalArgumentException {
        if (deviceId != null) {
            deviceId = deviceId.trim();
        }
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            throw new IllegalArgumentException();
        }
        this.storage.setWithBackup("hs-device-id", (Serializable)((Object)deviceId));
    }

    public String getDeviceId() {
        return (String)this.storage.get("hs-device-id");
    }

    public Boolean getFirstLaunch() {
        return (Boolean)this.storage.get("hs-first-launch");
    }

    public void setFirstLaunch(Boolean firstLaunch) {
        this.storage.set("hs-first-launch", firstLaunch);
    }

    public Boolean getOneCampaignFetchSuccessful() {
        return (Boolean)this.storage.get("hs-one-campaign-fetch-successful");
    }

    public void setOneCampaignFetchSuccessful(Boolean campaignFetchSuccessful) {
        this.storage.set("hs-one-campaign-fetch-successful", campaignFetchSuccessful);
    }

    public Boolean getDevicePropertiesSyncImmediately() {
        Boolean value = (Boolean)this.storage.get("hs-device-properties-sync-immediately");
        if (value == null) {
            value = false;
        }
        return value;
    }

    public void setDevicePropertiesSyncImmediately(Boolean devicePropertiesSyncImmediately) {
        this.storage.set("hs-device-properties-sync-immediately", devicePropertiesSyncImmediately);
    }

    public String getSdkLanguage() {
        return (String)this.storage.get("sdk-language");
    }

    public void setSdkLanguage(String language) {
        this.storage.set("sdk-language", (Serializable)((Object)language));
    }

    public void setChangeSetId(String changeSetId, String campaignId) {
        String key = CHANGE_SET_ID_PREFIX + campaignId;
        this.storage.set(key, (Serializable)((Object)changeSetId));
    }

    public String getChangeSetId(String campaignId) {
        String key = CHANGE_SET_ID_PREFIX + campaignId;
        return (String)this.storage.get(key);
    }

    public void setUserIdSyncedWithBackend(String uid) {
        this.storage.setWithBackup("hs-synced-user-id", (Serializable)((Object)uid));
    }

    public String getUserIdSyncedWithBackend() {
        return (String)this.storage.get("hs-synced-user-id");
    }

    public boolean isDuplicateNotification(String changeSetId, String userIdentifier) {
        HashSet<String> receivedNotifications;
        String receivedPushCampaignsKey = "hs__received_push_campaigns";
        HashMap notificationMappingForAllUsers = (HashMap)this.storage.get(receivedPushCampaignsKey);
        if (notificationMappingForAllUsers == null) {
            notificationMappingForAllUsers = new HashMap();
        }
        if ((receivedNotifications = (HashSet<String>)notificationMappingForAllUsers.get(userIdentifier)) == null) {
            receivedNotifications = new HashSet<String>();
        }
        if (receivedNotifications.contains(changeSetId)) {
            return true;
        }
        receivedNotifications.add(changeSetId);
        notificationMappingForAllUsers.put(userIdentifier, receivedNotifications);
        this.storage.set(receivedPushCampaignsKey, notificationMappingForAllUsers);
        return false;
    }
}

