/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.network;

import com.helpshift.network.Header;
import com.helpshift.network.HttpEntity;
import com.helpshift.network.StatusLine;
import java.util.ArrayList;
import java.util.List;

public class HttpResponse {
    private List<Header> headers;
    private StatusLine statusLine;
    private HttpEntity entity;

    public HttpResponse(StatusLine statusLine) {
        if (statusLine == null) {
            throw new IllegalArgumentException("Status line may not be null.");
        }
        this.statusLine = statusLine;
        this.headers = new ArrayList<Header>(16);
    }

    public void setEntity(HttpEntity entity) {
        this.entity = entity;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public void addHeader(Header header) {
        if (header == null) {
            return;
        }
        this.headers.add(header);
    }

    public Header[] getAllHeaders() {
        return this.headers.toArray(new Header[this.headers.size()]);
    }
}

