/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.network;

import android.os.Build;
import com.helpshift.android.commons.downloader.HelpshiftSSLSocketFactory;
import com.helpshift.common.domain.network.NetworkConstants;
import com.helpshift.exceptions.InstallException;
import com.helpshift.network.Header;
import com.helpshift.network.HttpEntity;
import com.helpshift.network.HttpResponse;
import com.helpshift.network.HttpStack;
import com.helpshift.network.StatusLine;
import com.helpshift.network.request.Request;
import com.helpshift.util.HelpshiftContext;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HurlStack
implements HttpStack {
    @Override
    public HttpResponse performRequest(Request request) throws IOException, InstallException {
        HttpURLConnection connection;
        URL url = request.getParsedURL();
        if ("https://".equals(NetworkConstants.scheme)) {
            connection = (HttpsURLConnection)url.openConnection();
            this.fixSSLSocketProtocols((HttpsURLConnection)connection);
        } else {
            connection = (HttpURLConnection)url.openConnection();
        }
        this.configureConnectionForRequest(connection, request);
        int responseCode = connection.getResponseCode();
        if (responseCode == -1) {
            throw new IOException("Could not retrieve response code from HttpUrlConnection.");
        }
        StatusLine responseStatus = new StatusLine(connection.getResponseCode(), connection.getResponseMessage());
        HttpResponse response = new HttpResponse(responseStatus);
        boolean isContentGzipd = false;
        for (Map.Entry<String, List<String>> header : connection.getHeaderFields().entrySet()) {
            if (header.getKey() == null) continue;
            if (header.getKey().equals("Content-Encoding") && header.getValue().get(0).equalsIgnoreCase("gzip")) {
                isContentGzipd = true;
            }
            Header h = new Header(header.getKey(), header.getValue().get(0));
            response.addHeader(h);
        }
        response.setEntity(HurlStack.entityFromConnection(connection, isContentGzipd));
        return response;
    }

    private void fixSSLSocketProtocols(HttpsURLConnection connection) {
        if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT <= 19) {
            ArrayList<String> enableProtocols = new ArrayList<String>();
            enableProtocols.add("TLSv1.2");
            ArrayList<String> disableProtocols = new ArrayList<String>();
            disableProtocols.add("SSLv3");
            SSLSocketFactory sslSocketFactory = connection.getSSLSocketFactory();
            connection.setSSLSocketFactory(new HelpshiftSSLSocketFactory(sslSocketFactory, enableProtocols, disableProtocols));
        }
    }

    private static HttpEntity entityFromConnection(HttpURLConnection connection, boolean isContentGzipd) {
        InputStream inputStream;
        HttpEntity entity = new HttpEntity();
        try {
            inputStream = isContentGzipd ? new GZIPInputStream(new BufferedInputStream(connection.getInputStream())) : new BufferedInputStream(connection.getInputStream());
        }
        catch (IOException ioe) {
            inputStream = connection.getErrorStream();
        }
        entity.content = inputStream;
        entity.contentLength = connection.getContentLength();
        return entity;
    }

    private void configureConnectionForRequest(HttpURLConnection connection, Request request) throws InstallException, IOException {
        Map<String, String> headerMap = request.getHeaders();
        for (String headerName : headerMap.keySet()) {
            connection.addRequestProperty(headerName, headerMap.get(headerName));
        }
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        String userAgent = String.format(Locale.ENGLISH, "Helpshift-%s/%s/%s", HelpshiftContext.getPlatform().getDevice().getPlatformName(), HelpshiftContext.getPlatform().getDevice().getSDKVersion(), HelpshiftContext.getPlatform().getDevice().getOSVersion());
        connection.setRequestProperty("User-Agent", userAgent);
        connection.setRequestMethod(request.getMethodString());
        if (request.method == 1) {
            connection.setDoOutput(request.isDoOutput());
            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            OutputStream outputStream = connection.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            writer.write(request.getPOSTParametersQuery());
            writer.flush();
            writer.close();
            outputStream.close();
        }
    }
}

