/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.network.response;

import android.os.Handler;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.request.Request;
import com.helpshift.network.response.Response;
import com.helpshift.network.response.ResponseDelivery;
import java.util.concurrent.Executor;

public class ExecutorDelivery
implements ResponseDelivery {
    private final Executor responsePoster;

    public ExecutorDelivery(final Handler handler) {
        this.responsePoster = new Executor(){

            @Override
            public void execute(Runnable command) {
                handler.post(command);
            }
        };
    }

    @Override
    public void postResponse(Request request, Response<?> response) {
        this.responsePoster.execute(new ResponseDeliveryRunnable(request, response, null));
    }

    @Override
    public void postError(Request request, NetworkError error) {
        Response response = Response.error(error, request.getSequence());
        this.responsePoster.execute(new ResponseDeliveryRunnable(request, response, null));
    }

    private class ResponseDeliveryRunnable
    implements Runnable {
        private final Request request;
        private final Response response;
        private final Runnable runnable;

        public ResponseDeliveryRunnable(Request request, Response response, Runnable runnable) {
            this.request = request;
            this.response = response;
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                if (this.response.isSuccess()) {
                    this.request.deliverResponse(this.response.result);
                } else {
                    this.request.deliverError(this.response.error);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.request.markDelivered();
            if (this.runnable != null) {
                this.runnable.run();
            }
        }
    }
}

