/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.network.response;

import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.response.NetworkResponse;
import com.helpshift.network.response.Response;
import com.helpshift.network.response.ResponseParser;
import com.helpshift.network.util.HttpHeaderParser;
import java.io.UnsupportedEncodingException;
import org.json.JSONArray;
import org.json.JSONException;

public class JsonArrayResponseParser
implements ResponseParser<JSONArray> {
    @Override
    public Response<JSONArray> parseResponse(NetworkResponse response) {
        try {
            String jsonString = new String(response.data, HttpHeaderParser.parseCharset(response.headers, "utf-8"));
            return Response.success(new JSONArray(jsonString), response.requestIdentifier);
        }
        catch (UnsupportedEncodingException e) {
            return Response.error(new NetworkError(NetworkErrorCodes.PARSE_ERROR, (Throwable)e), response.requestIdentifier);
        }
        catch (JSONException je) {
            return Response.error(new NetworkError(NetworkErrorCodes.PARSE_ERROR, (Throwable)je), response.requestIdentifier);
        }
    }
}

