/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.network.response;

import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.response.NetworkResponse;
import com.helpshift.network.response.Response;
import com.helpshift.network.response.ResponseParser;
import com.helpshift.network.util.HttpHeaderParser;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonObjectResponseParser
implements ResponseParser<JSONObject> {
    @Override
    public Response<JSONObject> parseResponse(NetworkResponse response) {
        try {
            String jsonString = new String(response.data, HttpHeaderParser.parseCharset(response.headers, "utf-8"));
            return Response.success(new JSONObject(jsonString), response.requestIdentifier);
        }
        catch (UnsupportedEncodingException e) {
            return Response.error(new NetworkError(NetworkErrorCodes.PARSE_ERROR, (Throwable)e), response.requestIdentifier);
        }
        catch (JSONException je) {
            return Response.error(new NetworkError(NetworkErrorCodes.PARSE_ERROR, (Throwable)je), response.requestIdentifier);
        }
    }
}

