/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.network.util;

import com.helpshift.network.util.InetAddressUtils;
import com.helpshift.util.HSPattern;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;

public class IpUtil {
    private static String getInterfaceAddress(boolean useIPv4) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    if (addr.isLoopbackAddress()) continue;
                    String sAddr = addr.getHostAddress().toUpperCase();
                    boolean isIPv4 = InetAddressUtils.isIPv4Address(sAddr);
                    if (useIPv4) {
                        if (!isIPv4) continue;
                        return sAddr;
                    }
                    if (isIPv4) continue;
                    int delim = sAddr.indexOf(37);
                    return delim < 0 ? sAddr : sAddr.substring(0, delim);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private static String validateIPAddress(String address, boolean useIPv4) {
        return !useIPv4 || HSPattern.checkIpv4Address(address) ? address : null;
    }

    public static String getIPAddress(boolean useIPv4) {
        return IpUtil.validateIPAddress(IpUtil.getInterfaceAddress(useIPv4), useIPv4);
    }
}

