/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.notifications;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import com.helpshift.R;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.TextUtils;

public class NotificationChannelsManager {
    private static final String DEFAULT_CHANNEL_ID = "helpshift_default_channel_id";
    private final Context context;

    public NotificationChannelsManager(Context context) {
        this.context = context;
    }

    private String getActiveChannelId(NotificationChannelType type) {
        String channelId;
        switch (type) {
            case SUPPORT: {
                channelId = this.getActiveSupportNotificationChannel();
                break;
            }
            case CAMPAIGN: {
                channelId = this.getActiveCampaignsNotificationChannel();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return channelId;
    }

    private String getActiveSupportNotificationChannel() {
        String channelId = HelpshiftContext.getCoreApi().getSDKConfigurationDM().getString("supportNotificationChannelId");
        if (TextUtils.isEmpty(channelId)) {
            this.ensureDefaultNotificationChannelCreated();
            channelId = DEFAULT_CHANNEL_ID;
        } else {
            this.deleteDefaultNotificationChannel();
        }
        return channelId;
    }

    private String getActiveCampaignsNotificationChannel() {
        String channelId = InfoModelFactory.getInstance().appInfoModel.campaignsNotificationChannelId;
        if (TextUtils.isEmpty(channelId)) {
            this.ensureDefaultNotificationChannelCreated();
            channelId = DEFAULT_CHANNEL_ID;
        } else {
            this.deleteDefaultNotificationChannel();
        }
        return channelId;
    }

    @TargetApi(value=26)
    private void ensureDefaultNotificationChannelCreated() {
        NotificationChannel notificationChannel;
        String id2 = DEFAULT_CHANNEL_ID;
        NotificationManager notificationManager = ApplicationUtil.getNotificationManager(this.context);
        if (notificationManager != null && (notificationChannel = notificationManager.getNotificationChannel(id2)) == null) {
            String name = this.context.getResources().getString(R.string.hs__default_notification_channel_name);
            String description = this.context.getResources().getString(R.string.hs__default_notification_channel_desc);
            NotificationChannel mChannel = new NotificationChannel(id2, (CharSequence)name, 3);
            mChannel.setDescription(description);
            notificationManager.createNotificationChannel(mChannel);
        }
    }

    public void checkAndUpdateDefaultChannelInfo() {
        if (Build.VERSION.SDK_INT >= 26 && ApplicationUtil.getTargetSDKVersion(this.context) >= 26) {
            NotificationChannel notificationChannel;
            String id2 = DEFAULT_CHANNEL_ID;
            NotificationManager notificationManager = ApplicationUtil.getNotificationManager(this.context);
            if (notificationManager != null && (notificationChannel = notificationManager.getNotificationChannel(id2)) != null) {
                CharSequence currentChannelName = notificationChannel.getName();
                String currentChannelDesc = notificationChannel.getDescription();
                String name = this.context.getResources().getString(R.string.hs__default_notification_channel_name);
                String description = this.context.getResources().getString(R.string.hs__default_notification_channel_desc);
                if (!name.equals(currentChannelName) || !description.equals(currentChannelDesc)) {
                    NotificationChannel mChannel = new NotificationChannel(id2, (CharSequence)name, notificationChannel.getImportance());
                    mChannel.setDescription(description);
                    notificationManager.createNotificationChannel(mChannel);
                }
            }
        }
    }

    @TargetApi(value=26)
    private void deleteDefaultNotificationChannel() {
        NotificationManager notificationManager = ApplicationUtil.getNotificationManager(this.context);
        String id2 = DEFAULT_CHANNEL_ID;
        if (notificationManager != null && notificationManager.getNotificationChannel(id2) != null) {
            notificationManager.deleteNotificationChannel(id2);
        }
    }

    public Notification attachChannelId(Notification notification, NotificationChannelType type) {
        if (Build.VERSION.SDK_INT >= 26 && ApplicationUtil.getTargetSDKVersion(this.context) >= 26) {
            Notification.Builder builder = Notification.Builder.recoverBuilder((Context)this.context, (Notification)notification);
            builder.setChannelId(this.getActiveChannelId(type));
            return builder.build();
        }
        return notification;
    }

    public static enum NotificationChannelType {
        SUPPORT,
        CAMPAIGN;

    }
}

