/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.platform.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.helpshift.common.conversation.ConversationDBInfo;
import com.helpshift.util.HSLogger;

public class ConversationDBHelper
extends SQLiteOpenHelper {
    private final ConversationDBInfo dbInfo;
    private static final String TAG = "Helpshift_ConversationDB";

    public ConversationDBHelper(Context context, ConversationDBInfo dbInfo) {
        super(context, "__hs__db_issues", null, ConversationDBInfo.DATABASE_VERSION.intValue());
        this.dbInfo = dbInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate(SQLiteDatabase db) {
        if (db.isOpen()) {
            try {
                db.beginTransaction();
                for (String query : this.dbInfo.getQueriesForOnCreate()) {
                    db.execSQL(query);
                }
                db.setTransactionSuccessful();
            }
            catch (Exception ex) {
                HSLogger.e(TAG, "Exception while creating tables: " + ex + ", version: " + ConversationDBInfo.DATABASE_VERSION);
            }
            finally {
                try {
                    if (db.inTransaction()) {
                        db.endTransaction();
                    }
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error in onCreate inside finally block, ", e);
                }
            }
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.dropAndCreateDatabase(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropAndCreateDatabase(SQLiteDatabase db) {
        if (db.isOpen()) {
            try {
                db.beginTransaction();
                for (String query : this.dbInfo.getQueriesForDropping()) {
                    db.execSQL(query);
                }
                for (String query : this.dbInfo.getQueriesForOnCreate()) {
                    db.execSQL(query);
                }
                db.setTransactionSuccessful();
            }
            catch (Exception ex) {
                HSLogger.e(TAG, "Exception while upgrading tables: " + ex + ", version: " + ConversationDBInfo.DATABASE_VERSION);
            }
            finally {
                try {
                    if (db.inTransaction()) {
                        db.endTransaction();
                    }
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error in dropAndCreateDatabase inside finally block, ", e);
                }
            }
        }
    }
}

