/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.specifications;

import com.helpshift.specifications.SyncSpecification;
import java.util.concurrent.TimeUnit;

public class DecayingIntervalSyncSpecification
implements SyncSpecification {
    private final String dataType;
    private long elapsedTimeThreshold;
    private long maxTimeThresholdLimit = 86400000L;

    public DecayingIntervalSyncSpecification(int seedValue, TimeUnit unit, String dataType) {
        this.elapsedTimeThreshold = TimeUnit.MILLISECONDS.convert(seedValue, unit);
        this.dataType = dataType;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public boolean isSatisfied(int dataChangeCount, long elapsedTimeSinceSync) {
        boolean result = false;
        elapsedTimeSinceSync = Math.abs(elapsedTimeSinceSync);
        if (dataChangeCount > 0 && elapsedTimeSinceSync > this.elapsedTimeThreshold) {
            result = true;
        }
        return result;
    }

    public void decayElapsedTimeThreshold() {
        this.elapsedTimeThreshold = (long)(1.618 * (double)this.elapsedTimeThreshold);
        if (this.elapsedTimeThreshold > this.maxTimeThresholdLimit) {
            this.elapsedTimeThreshold = this.maxTimeThresholdLimit;
        }
    }
}

