/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.util.ByteArrayUtil;
import com.helpshift.util.DBUtil;
import com.helpshift.util.DatabaseUtils;
import com.helpshift.util.HSLogger;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Map;

public class KeyValueDbStorage
implements KeyValueStorage {
    private static final String TAG = "HS_KeyValueDB";
    private SQLiteOpenHelper helper;
    private HashMap<String, Serializable> backupData;
    private String backupFileName;
    private FileLock fileLock;
    private String lockFilePath;

    public KeyValueDbStorage(SQLiteOpenHelper helper, String backupFileName, String lockFilePath) {
        this.helper = helper;
        this.lockFilePath = lockFilePath;
        this.backupFileName = backupFileName;
        if (!StringUtils.isEmpty(backupFileName)) {
            this.backupData = DBUtil.restoreHashMap(backupFileName);
            if (this.backupData == null) {
                this.backupData = new HashMap();
            } else {
                for (Map.Entry<String, Serializable> entry : this.backupData.entrySet()) {
                    this.set(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    private void acquireLock() {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.lockFilePath, "rw");
            this.fileLock = randomAccessFile.getChannel().lock();
        }
        catch (Exception e) {
            HSLogger.e(TAG, "Error in getting file fileLock: " + this.lockFilePath, e);
        }
    }

    private void releaseLock() {
        try {
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.release();
            }
        }
        catch (Exception e) {
            HSLogger.e(TAG, "Error releasing file fileLock: " + this.lockFilePath, e);
            try {
                new File(this.lockFilePath).delete();
            }
            catch (Exception ex) {
                HSLogger.e(TAG, "Error deleting locked file : " + this.lockFilePath, ex);
            }
        }
    }

    @Override
    public void setWithBackup(String key, Serializable value) {
        if (this.set(key, value) && !StringUtils.isEmpty(this.backupFileName)) {
            this.backupData.put(key, value);
            DBUtil.backupHashMap(this.backupFileName, this.backupData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set(String key, Serializable value) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            return false;
        }
        try {
            this.acquireLock();
            SQLiteDatabase db = this.helper.getWritableDatabase();
            String whereClause = "key=?";
            String[] whereArgs = new String[]{key};
            ContentValues values = new ContentValues();
            values.put("key", key);
            try {
                values.put("value", ByteArrayUtil.toByteArray(value));
            }
            catch (IOException e) {
                HSLogger.e(TAG, "Error in serializing value", e);
                boolean bl = false;
                this.releaseLock();
                return bl;
            }
            if (DatabaseUtils.exists(db, "key_value_store", whereClause, whereArgs)) {
                db.update("key_value_store", values, whereClause, whereArgs);
            } else {
                long result = db.insert("key_value_store", null, values);
                if (result == -1L) {
                    throw new SQLiteException("DB insert failed and return -1");
                }
            }
        }
        finally {
            this.releaseLock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        Object value = null;
        Cursor cursor = null;
        try {
            this.acquireLock();
            SQLiteDatabase db = this.helper.getReadableDatabase();
            String whereClause = "key=?";
            String[] whereArgs = new String[]{key};
            cursor = db.query("key_value_store", null, whereClause, whereArgs, null, null, null);
            if (cursor.moveToFirst()) {
                try {
                    value = ByteArrayUtil.toObject(cursor.getBlob(1));
                }
                catch (Exception exception) {
                    value = null;
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.releaseLock();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeKey(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        try {
            this.acquireLock();
            SQLiteDatabase db = this.helper.getWritableDatabase();
            String whereClause = "key=?";
            String[] whereArgs = new String[]{key};
            db.delete("key_value_store", whereClause, whereArgs);
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public void removeAllKeys() {
        try {
            this.acquireLock();
            SQLiteDatabase db = this.helper.getWritableDatabase();
            db.delete("key_value_store", null, null);
        }
        finally {
            this.releaseLock();
        }
    }
}

