/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.storage;

import android.content.Context;
import android.database.sqlite.SQLiteOpenHelper;
import com.helpshift.storage.BaseRetryKeyValueStorage;
import com.helpshift.storage.KeyValueDbStorage;
import com.helpshift.storage.KeyValueDbStorageHelper;
import com.helpshift.util.HSLogger;
import java.io.File;

public class RetryKeyValueDbStorage
extends BaseRetryKeyValueStorage {
    private final Context context;
    private static final String LOCK_FILE_NAME = "__hs_kvdb_lock";
    private static final String backupFileName = "__hs__kv_backup";
    private SQLiteOpenHelper sqLiteOpenHelper;
    private final String lockFilePath;

    RetryKeyValueDbStorage(Context context) {
        this.context = context;
        this.sqLiteOpenHelper = new KeyValueDbStorageHelper(context);
        this.lockFilePath = context.getFilesDir() + File.separator + LOCK_FILE_NAME;
        this.keyValueStorage = new KeyValueDbStorage(this.sqLiteOpenHelper, backupFileName, this.lockFilePath);
    }

    @Override
    protected void reInitiateDbInstance() {
        try {
            if (this.sqLiteOpenHelper != null) {
                this.sqLiteOpenHelper.close();
            }
        }
        catch (Exception e) {
            HSLogger.e("Helpshift_RetryKeyValue", "Error in closing DB", e);
        }
        this.sqLiteOpenHelper = new KeyValueDbStorageHelper(this.context);
        this.keyValueStorage = new KeyValueDbStorage(this.sqLiteOpenHelper, backupFileName, this.lockFilePath);
    }
}

