/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class Faq
implements Parcelable {
    public long id;
    private String qId;
    public final String title;
    public final String publish_id;
    private String type;
    public final String section_publish_id;
    public final String body;
    public final int is_helpful;
    public final Boolean is_rtl;
    public ArrayList<String> searchTerms;
    private List<String> tags;
    private List<String> categoryTags;
    public static final Parcelable.Creator<Faq> CREATOR = new Parcelable.Creator<Faq>(){

        public Faq createFromParcel(Parcel source) {
            return new Faq(source);
        }

        public Faq[] newArray(int size) {
            return new Faq[size];
        }
    };

    public Faq() {
        this.title = "";
        this.publish_id = "";
        this.type = "";
        this.body = "";
        this.section_publish_id = "";
        this.is_helpful = 0;
        this.is_rtl = false;
        this.tags = new ArrayList<String>();
        this.categoryTags = new ArrayList<String>();
    }

    public Faq(long id2, String qId, String publish_id, String sectionId, String title, String body, int isHelpful, Boolean isRtl, List<String> tags, List<String> categoryTags) {
        this.id = id2;
        this.qId = qId;
        this.title = title;
        this.publish_id = publish_id;
        this.type = "faq";
        this.section_publish_id = sectionId;
        this.body = body;
        this.is_helpful = isHelpful;
        this.is_rtl = isRtl;
        this.tags = tags;
        this.categoryTags = categoryTags;
    }

    Faq(Parcel in) {
        this.qId = in.readString();
        this.title = in.readString();
        this.publish_id = in.readString();
        this.type = in.readString();
        this.section_publish_id = in.readString();
        this.body = in.readString();
        this.is_helpful = in.readInt();
        this.is_rtl = in.readByte() != 0;
        if (this.searchTerms == null) {
            this.searchTerms = new ArrayList();
        }
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        if (this.categoryTags == null) {
            this.categoryTags = new ArrayList<String>();
        }
        in.readStringList(this.searchTerms);
        in.readStringList(this.tags);
        in.readStringList(this.categoryTags);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.qId);
        dest.writeString(this.title);
        dest.writeString(this.publish_id);
        dest.writeString(this.type);
        dest.writeString(this.section_publish_id);
        dest.writeString(this.body);
        dest.writeInt(this.is_helpful);
        dest.writeByte((byte)(this.is_rtl != false ? 1 : 0));
        dest.writeStringList(this.searchTerms);
        dest.writeStringList(this.tags);
        dest.writeStringList(this.categoryTags);
    }

    public String toString() {
        return this.title;
    }

    public String getId() {
        return this.qId;
    }

    public List<String> getTags() {
        if (this.tags == null) {
            return new ArrayList<String>();
        }
        return this.tags;
    }

    public List<String> getCategoryTags() {
        if (this.categoryTags == null) {
            return new ArrayList<String>();
        }
        return this.categoryTags;
    }

    protected void clearSearchTerms() {
        this.searchTerms = null;
    }

    protected void addSearchTerms(ArrayList<String> searchTerms) {
        this.searchTerms = Faq.mergeSearchTerms(this.searchTerms, searchTerms);
    }

    private static ArrayList<String> mergeSearchTerms(ArrayList<String> searchTerms1, ArrayList<String> searchTerms2) {
        HashSet<String> searchTermsSet = new HashSet<String>();
        if (searchTerms1 != null) {
            searchTermsSet.addAll(searchTerms1);
        }
        if (searchTerms2 != null) {
            searchTermsSet.addAll(searchTerms2);
        }
        return new ArrayList<String>(searchTermsSet);
    }

    public boolean equals(Object otherObj) {
        Faq other = (Faq)otherObj;
        return this.qId.equals(other.qId) && this.title.equals(other.title) && this.body.equals(other.body) && this.publish_id.equals(other.publish_id) && this.section_publish_id.equals(other.section_publish_id) && this.is_rtl == other.is_rtl && this.is_helpful == other.is_helpful && this.tags.equals(other.tags) && this.categoryTags.equals(other.categoryTags);
    }
}

