/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.helpshift.android.commons.downloader.HelpshiftSSLSocketFactory;
import com.helpshift.common.domain.network.NetworkConstants;
import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.exceptions.InstallException;
import com.helpshift.logger.logmodels.LogExtrasModelProvider;
import com.helpshift.logger.model.LogModel;
import com.helpshift.network.NameValuePair;
import com.helpshift.support.HSStorage;
import com.helpshift.support.network.dataproviders.ErrorLogRequestData;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.TimeUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class HSApiClient {
    private static final String TAG = "Helpshift_ApiClient";
    public static final String apiVersion = "2";
    public static final String libraryVersion = "6.3.0";
    private static final int timeStampMaxRetries = 3;
    static int timeStampErrorReplies = 0;
    private final String appId;
    private final String domain;
    private final String apiKey;
    private HSStorage storage;

    protected HSApiClient(String domain, String appId, String apiKey, HSStorage storage) {
        this.domain = domain;
        this.appId = appId;
        this.apiKey = apiKey;
        this.storage = storage;
    }

    static void addHeadersToConnection(HttpURLConnection connection) {
        String userAgent = "Helpshift-Android/6.3.0/" + Build.VERSION.RELEASE;
        String acceptLangHead = String.format("%s;q=1.0", HelpshiftContext.getCoreApi().getLocaleProviderDM().getAcceptLanguageHeader());
        connection.setConnectTimeout(5000);
        connection.setRequestProperty("User-Agent", userAgent);
        connection.setRequestProperty("Accept-Language", acceptLangHead);
        connection.setRequestProperty("Accept-Encoding", "gzip");
        connection.setRequestProperty("X-HS-V", "Helpshift-Android/6.3.0");
    }

    static String constructPostParamsQuery(List<NameValuePair> params) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (NameValuePair pair : params) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            try {
                result.append(URLEncoder.encode(pair.name, "UTF-8"));
                result.append("=");
                result.append(URLEncoder.encode(pair.value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                HSLogger.e(TAG, "Exception Unsupported Encoding", e);
            }
        }
        return result.toString();
    }

    String getQuestionRoute(String publishId) {
        return "/faqs/" + publishId + "/";
    }

    private String getSignature(String sigString, String key) throws GeneralSecurityException, InstallException {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new InstallException("apiKey Missing");
        }
        return HelpshiftContext.getCoreApi().getCryptoDM().getSignature(sigString, key);
    }

    private String getApiUri(String route) {
        return "/api/lib/2" + route;
    }

    String getApiUrl(String route) throws InstallException {
        if (TextUtils.isEmpty((CharSequence)this.domain)) {
            throw new InstallException("domain Missing");
        }
        return NetworkConstants.scheme + this.domain + this.getApiUri(route);
    }

    String constructGetParams(HashMap<String, String> data) {
        ArrayList<String> dataList = new ArrayList<String>();
        ArrayList<String> mapKeys = new ArrayList<String>(data.keySet());
        for (String key : mapKeys) {
            dataList.add(key + "=" + Uri.encode((String)data.get(key)));
        }
        return TextUtils.join((CharSequence)"&", dataList);
    }

    private String getStringValue(Object value) {
        String dataString = null;
        if (value != null) {
            dataString = value instanceof String ? (String)value : (value instanceof ArrayList ? new JSONArray((Collection)((ArrayList)value)).toString() : value.toString());
        }
        return dataString;
    }

    List<NameValuePair> constructPostParams(HashMap<String, String> data) {
        ArrayList<String> mapKeys = new ArrayList<String>(data.keySet());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(mapKeys.size());
        for (String key : mapKeys) {
            String dataString = this.getStringValue(data.get(key));
            if (dataString == null) continue;
            params.add(new NameValuePair(key, dataString));
        }
        return params;
    }

    HashMap<String, String> addAuthErrorLog(HashMap<String, String> data) throws InstallException, GeneralSecurityException {
        ArrayList<String> dataList = new ArrayList<String>();
        dataList.add("platform-id=sdk");
        String token = UUID.randomUUID().toString();
        dataList.add("token=" + token);
        data.put("token", token);
        data.put("sm", this.getSdkMeta());
        dataList.add("sm=" + this.getSdkMeta());
        data.put("signature", this.getSignature(TextUtils.join((CharSequence)"&", dataList), "sdk"));
        return data;
    }

    HashMap<String, String> addAuth(HashMap<String, String> data, String route, String method) throws InstallException, GeneralSecurityException {
        String uriStr = this.getApiUri(route);
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            throw new InstallException("appId Missing");
        }
        data.put("platform-id", this.appId);
        data.put("method", method);
        data.put("uri", uriStr);
        float serverTimeDelta = HelpshiftContext.getPlatform().getNetworkRequestDAO().getServerTimeDelta();
        String ts = TimeUtil.getAdjustedTimestamp(Float.valueOf(serverTimeDelta));
        data.put("timestamp", ts);
        data.put("sm", this.getSdkMeta());
        ArrayList<String> mapKeys = new ArrayList<String>(data.keySet());
        ArrayList<String> dataList = new ArrayList<String>();
        Collections.sort(mapKeys);
        for (String key : mapKeys) {
            String dataString;
            if (key.equals("screenshot") || key.equals("meta") || (dataString = this.getStringValue(data.get(key))) == null) continue;
            dataList.add(key + "=" + dataString);
        }
        String signature = this.getSignature(TextUtils.join((CharSequence)"&", dataList), this.apiKey);
        data.put("signature", signature);
        data.remove("method");
        data.remove("uri");
        return data;
    }

    void fixSSLSocketProtocols(HttpsURLConnection connection) {
        if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT <= 19) {
            ArrayList<String> enableProtocols = new ArrayList<String>();
            enableProtocols.add("TLSv1.2");
            ArrayList<String> disableProtocols = new ArrayList<String>();
            disableProtocols.add("SSLv3");
            SSLSocketFactory sslSocketFactory = connection.getSSLSocketFactory();
            connection.setSSLSocketFactory(new HelpshiftSSLSocketFactory(sslSocketFactory, enableProtocols, disableProtocols));
        }
    }

    private String getSdkMeta() {
        JSONObject sdkMetaObject = new JSONObject();
        try {
            sdkMetaObject.put("ia", true);
            sdkMetaObject.put("rs", true);
            sdkMetaObject.put("clc", true);
            sdkMetaObject.put("atai", true);
            sdkMetaObject.put("fp", true);
        }
        catch (JSONException e) {
            HSLogger.e(TAG, "getSdkMeta : ", e);
        }
        return sdkMetaObject.toString();
    }

    void sendFailMessage(String route, Handler failure, int status, Throwable tr) {
        Throwable[] throwables = new Throwable[]{tr};
        HSLogger.e(TAG, "Network error", throwables, LogExtrasModelProvider.fromString("route", route), LogExtrasModelProvider.fromString("status", status + ""));
        Message result = failure.obtainMessage();
        HashMap<String, Integer> messageResponse = new HashMap<String, Integer>();
        messageResponse.put("status", status);
        result.obj = messageResponse;
        failure.sendMessage(result);
    }

    void makeRequest(String method, String route, HashMap data, Handler success, Handler failure) {
        this.makeRequest(method, route, data, success, failure, false);
    }

    private void makeRequest(final String method, final String route, final HashMap data, final Handler success, final Handler failure, final boolean forErrorLog) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block48: {
                    try {
                        URL urlObj;
                        HashMap dataCopy = new HashMap(data);
                        String url = HSApiClient.this.getApiUrl(route);
                        HttpURLConnection connection = null;
                        if (method.equals("GET")) {
                            String requestStr = HSApiClient.this.constructGetParams(HSApiClient.this.addAuth(data, route, method));
                            urlObj = new URL(url + "?" + requestStr);
                            if ("https://".equals(NetworkConstants.scheme)) {
                                connection = (HttpsURLConnection)urlObj.openConnection();
                                HSApiClient.this.fixSSLSocketProtocols((HttpsURLConnection)connection);
                            } else {
                                connection = (HttpURLConnection)urlObj.openConnection();
                            }
                            connection.setRequestMethod("GET");
                            HSApiClient.addHeadersToConnection(connection);
                            String etag = HelpshiftContext.getPlatform().getNetworkRequestDAO().getETag(route);
                            if (!TextUtils.isEmpty((CharSequence)etag)) {
                                connection.setRequestProperty("If-None-Match", etag);
                            }
                        } else if (method.equals("POST")) {
                            List<NameValuePair> params = forErrorLog ? HSApiClient.this.constructPostParams(HSApiClient.this.addAuthErrorLog(data)) : HSApiClient.this.constructPostParams(HSApiClient.this.addAuth(data, route, method));
                            urlObj = new URL(url);
                            if ("https://".equals(NetworkConstants.scheme)) {
                                connection = (HttpsURLConnection)urlObj.openConnection();
                                HSApiClient.this.fixSSLSocketProtocols((HttpsURLConnection)connection);
                            } else {
                                connection = (HttpURLConnection)urlObj.openConnection();
                            }
                            connection.setRequestMethod("POST");
                            connection.setDoOutput(true);
                            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                            HSApiClient.addHeadersToConnection(connection);
                            OutputStream outputStream = connection.getOutputStream();
                            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                            writer.write(HSApiClient.constructPostParamsQuery(params));
                            writer.flush();
                            writer.close();
                            outputStream.close();
                        }
                        try {
                            if (connection != null) {
                                Object result;
                                int status = connection.getResponseCode();
                                if (status >= 300) {
                                    HSLogger.d(HSApiClient.TAG, "Api : " + route + " \t Status : " + status + "\t Thread Id : " + Thread.currentThread().getId());
                                }
                                Set<Map.Entry<String, List<String>>> headers = connection.getHeaderFields().entrySet();
                                StringBuilder responseStr = new StringBuilder();
                                if (status >= 200 && status < 300) {
                                    FilterInputStream response = new BufferedInputStream(connection.getInputStream());
                                    for (Map.Entry<String, List<String>> header : headers) {
                                        if (header.getKey() == null || !header.getKey().equals("ETag")) continue;
                                        HelpshiftContext.getPlatform().getNetworkRequestDAO().storeETag(route, header.getValue().get(0));
                                    }
                                    for (Map.Entry<String, List<String>> header : headers) {
                                        if (header.getKey() == null || !header.getKey().equals("Content-Encoding") || !header.getValue().get(0).equalsIgnoreCase("gzip")) continue;
                                        response = new GZIPInputStream(response);
                                    }
                                    InputStreamReader inputStream = new InputStreamReader(response);
                                    try (BufferedReader rd = new BufferedReader(inputStream);){
                                        String line;
                                        while ((line = rd.readLine()) != null) {
                                            responseStr.append(line);
                                        }
                                    }
                                }
                                HashMap<String, Integer> messageResponse = new HashMap<String, Integer>();
                                messageResponse.put("status", status);
                                if (status >= 200 && status < 300) {
                                    timeStampErrorReplies = 0;
                                    try {
                                        messageResponse.put("response", (Integer)new JSONArray(responseStr.toString()));
                                    }
                                    catch (JSONException earr) {
                                        messageResponse.put("response", (Integer)new JSONObject(responseStr.toString()));
                                    }
                                    result = success.obtainMessage();
                                    ((Message)result).obj = messageResponse;
                                    success.sendMessage((Message)result);
                                } else if (status == NetworkErrorCodes.CONTENT_UNCHANGED) {
                                    ++timeStampErrorReplies;
                                    result = success.obtainMessage();
                                    ((Message)result).obj = null;
                                    success.sendMessage((Message)result);
                                } else if (status == NetworkErrorCodes.TIMESTAMP_MISMATCH) {
                                    if (++timeStampErrorReplies <= 3) {
                                        for (Map.Entry<String, List<String>> header : headers) {
                                            if (header.getKey() == null || !((String)header.getKey()).equals("HS-UEpoch")) continue;
                                            HelpshiftContext.getPlatform().getNetworkRequestDAO().storeServerTimeDelta(HSDateFormatSpec.calculateTimeDelta((String)((List)header.getValue()).get(0)));
                                            HSApiClient.this.makeRequest(method, route, dataCopy, success, failure);
                                        }
                                    } else {
                                        timeStampErrorReplies = 0;
                                        result = failure.obtainMessage();
                                        ((Message)result).obj = messageResponse;
                                        failure.sendMessage((Message)result);
                                    }
                                } else if (status == NetworkErrorCodes.GONE_ERROR) {
                                    HSApiClient.this.sendFailMessage(route, failure, NetworkErrorCodes.GONE_ERROR, null);
                                } else {
                                    timeStampErrorReplies = 0;
                                    result = failure.obtainMessage();
                                    ((Message)result).obj = messageResponse;
                                    failure.sendMessage((Message)result);
                                }
                                connection.disconnect();
                                break block48;
                            }
                            HSApiClient.this.sendFailMessage(route, failure, NetworkErrorCodes.UNKNOWN_HOST_ERROR, null);
                        }
                        catch (JSONException e) {
                            HSApiClient.this.sendFailMessage(route, failure, NetworkErrorCodes.GENERIC_NETWORK_ERROR, e);
                        }
                        catch (UnknownHostException e) {
                            HSApiClient.this.sendFailMessage(route, failure, NetworkErrorCodes.UNKNOWN_HOST_ERROR, e);
                        }
                        catch (SocketException e) {
                            HSApiClient.this.sendFailMessage(route, failure, NetworkErrorCodes.NO_CONNECTION, e);
                        }
                        catch (SocketTimeoutException e) {
                            HSLogger.e(HSApiClient.TAG, "Exception Socket timeout", new Throwable[]{e}, LogExtrasModelProvider.fromString("route", route));
                        }
                    }
                    catch (InstallException | MalformedURLException | ProtocolException | GeneralSecurityException e) {
                        HSApiClient.this.sendFailMessage(route, failure, NetworkErrorCodes.GENERIC_NETWORK_ERROR, e);
                    }
                    catch (SecurityException e) {
                        HSApiClient.this.sendFailMessage(route, failure, NetworkErrorCodes.NO_CONNECTION, e);
                    }
                    catch (UnknownHostException e) {
                        HSApiClient.this.sendFailMessage(route, failure, NetworkErrorCodes.UNKNOWN_HOST_ERROR, e);
                    }
                    catch (SSLPeerUnverifiedException e) {
                        HSApiClient.this.sendFailMessage(route, failure, NetworkErrorCodes.SSL_PEER_UNVERIFIED_ERROR, e);
                    }
                    catch (SSLHandshakeException e) {
                        HSApiClient.this.sendFailMessage(route, failure, NetworkErrorCodes.SSL_HANDSHAKE_ERROR, e);
                    }
                    catch (IOException e) {
                        HSApiClient.this.sendFailMessage(route, failure, NetworkErrorCodes.GENERIC_NETWORK_ERROR, e);
                    }
                }
            }
        }, "HS-ApiClient").start();
    }

    protected void fetchFaqs(Handler success, Handler failure) {
        HSLogger.d(TAG, "Fetching FAQs");
        HashMap<String, String> data = new HashMap<String, String>();
        boolean enableDefaultFallbackLanguage = HelpshiftContext.getCoreApi().getSDKConfigurationDM().getBoolean("defaultFallbackLanguageEnable");
        data.put("edfl", String.valueOf(enableDefaultFallbackLanguage));
        this.makeRequest("GET", "/faqs/", data, success, failure);
    }

    protected void sendErrorReport(Handler success, Handler failure, List<LogModel> logs, String profileId, String domain) {
        HashMap requestData = ErrorLogRequestData.getRequestData(this.storage, logs, profileId, domain, apiVersion);
        this.makeRequest("POST", "/events/crash-log", requestData, success, failure, true);
    }

    protected void getQuestion(String publishId, Handler success, Handler failure) {
        HashMap<String, String> data = new HashMap<String, String>();
        boolean enableDefaultFallbackLanguage = HelpshiftContext.getCoreApi().getSDKConfigurationDM().getBoolean("defaultFallbackLanguageEnable");
        data.put("edfl", String.valueOf(enableDefaultFallbackLanguage));
        String route = this.getQuestionRoute(publishId);
        this.makeRequest("GET", route, data, success, failure);
    }
}

