/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.content.Context;
import android.database.SQLException;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.helpshift.account.domainmodel.ProfileDM;
import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.configuration.response.PeriodicReview;
import com.helpshift.logger.model.LogModel;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.support.Faq;
import com.helpshift.support.FaqTagFilter;
import com.helpshift.support.HSApiClient;
import com.helpshift.support.HSFaqSyncStatusEvents;
import com.helpshift.support.HSSearch;
import com.helpshift.support.HSStorage;
import com.helpshift.support.Section;
import com.helpshift.support.constants.GetSectionsCallBackStatus;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.support.model.FaqSearchIndex;
import com.helpshift.support.model.FuzzySearchToken;
import com.helpshift.support.res.values.HSConsts;
import com.helpshift.support.storage.FaqDAO;
import com.helpshift.support.storage.FaqsDataSource;
import com.helpshift.support.storage.SectionDAO;
import com.helpshift.support.storage.SectionsDataSource;
import com.helpshift.util.HSJSONUtils;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.TimeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class HSApiData {
    public static final String TAG = "Helpshift_ApiData";
    public static ArrayList<HSFaqSyncStatusEvents> observers = null;
    public HSStorage storage;
    public HSApiClient client;
    private Iterator failedApiKeys = null;
    SectionDAO sectionDAO;
    FaqDAO faqDAO;
    private ArrayList<Faq> flatFaqList = null;
    private static final Object flatFaqListSyncLock = new Object();

    public HSApiData(Context c) {
        this.storage = new HSStorage(c);
        this.client = new HSApiClient(this.storage.getDomain(), this.storage.getAppId(), this.storage.getApiKey(), this.storage);
        this.sectionDAO = new SectionsDataSource();
        this.faqDAO = new FaqsDataSource();
    }

    protected static void addFaqSyncStatusObserver(HSFaqSyncStatusEvents observer) {
        if (observers == null) {
            observers = new ArrayList();
        }
        observers.add(observer);
    }

    protected static void removeFaqSyncStatusObserver(HSFaqSyncStatusEvents observer) {
        if (observers != null) {
            observers.remove(observer);
        }
    }

    protected static void signalFaqsUpdated() {
        if (observers != null) {
            for (int i = 0; i < observers.size(); ++i) {
                HSFaqSyncStatusEvents observer = observers.get(i);
                if (observer == null) continue;
                observer.faqsUpdated();
            }
        }
    }

    protected static void signalSearchIndexesUpdated() {
        if (observers != null) {
            for (int i = 0; i < observers.size(); ++i) {
                HSFaqSyncStatusEvents observer = observers.get(i);
                if (observer == null) continue;
                observer.searchIndexesUpdated();
            }
        }
    }

    protected void install(String apiKey, String domain, String appId) {
        this.storage.setApiKey(apiKey);
        this.storage.setDomain(domain);
        this.storage.setAppId(appId);
        this.client = new HSApiClient(domain, appId, apiKey, this.storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFlatList() {
        ArrayList<Section> sections = this.getSections();
        ArrayList<Faq> tempFlatFaqList = new ArrayList<Faq>();
        for (int i = 0; i < sections.size(); ++i) {
            Section sectionItem = sections.get(i);
            ArrayList<Faq> faqs = this.getFaqsDataForSection(sectionItem.getPublishId());
            tempFlatFaqList.addAll(faqs);
        }
        Object object = flatFaqListSyncLock;
        synchronized (object) {
            this.flatFaqList = new ArrayList(tempFlatFaqList);
        }
    }

    private void getAndStoreSections(final Handler callback, final Handler failure, final FaqTagFilter faqTagFilter) throws SQLException {
        Handler localSuccess = new Handler(){

            public void handleMessage(Message msg) {
                HashMap result = (HashMap)msg.obj;
                Message msgToPost = callback.obtainMessage();
                if (result != null) {
                    HSLogger.d(HSApiData.TAG, "FAQ fetch success, updating new data.");
                    JSONArray faqs = (JSONArray)result.get("response");
                    HSApiData.this.storeSections(faqs);
                    msgToPost.obj = HSApiData.this.sectionDAO.getAllSections(faqTagFilter);
                    msgToPost.what = GetSectionsCallBackStatus.API_SUCCESS_NEW_DATA;
                    callback.sendMessage(msgToPost);
                    HSApiData.this.startSearchIndexing();
                } else {
                    HSLogger.d(HSApiData.TAG, "FAQ fetch success, no new data.");
                    msgToPost.what = GetSectionsCallBackStatus.API_SUCCESS_NO_NEW_DATA;
                    callback.sendMessage(msgToPost);
                }
                HSApiData.signalFaqsUpdated();
            }
        };
        Handler localFailure = new Handler(){

            public void handleMessage(Message msg) {
                HSLogger.d(HSApiData.TAG, "FAQ fetch failed.");
                HashMap result = (HashMap)msg.obj;
                Message msgToPost = failure.obtainMessage();
                msgToPost.obj = result;
                msgToPost.what = GetSectionsCallBackStatus.API_FAILURE;
                failure.sendMessage(msgToPost);
            }
        };
        this.client.fetchFaqs(localSuccess, localFailure);
    }

    void storeSections(JSONArray faqs) {
        HSLogger.d(TAG, "Updating " + (faqs == null ? 0 : faqs.length()) + " FAQ sections in DB");
        this.sectionDAO.clearSectionsData();
        this.sectionDAO.storeSections(faqs);
    }

    void startSearchIndexing() {
        Thread indexThread = new Thread(new Runnable(){

            @Override
            public void run() {
                HSApiData.this.updateIndex();
            }
        }, "HS-search-index");
        indexThread.setDaemon(true);
        indexThread.start();
    }

    public void getSections(Handler callback, Handler failure, FaqTagFilter faqTagFilter) {
        ArrayList sections = null;
        try {
            sections = (ArrayList)this.sectionDAO.getAllSections(faqTagFilter);
        }
        catch (SQLException s) {
            HSLogger.e(TAG, "Database exception in getting sections data ", s);
        }
        if (sections != null) {
            Message result = callback.obtainMessage();
            result.what = GetSectionsCallBackStatus.DATABASE_SUCCESS;
            result.obj = sections;
            callback.sendMessage(result);
        } else {
            Message result = failure.obtainMessage();
            result.what = GetSectionsCallBackStatus.DATABASE_FAILURE;
            failure.sendMessage(result);
        }
        this.getAndStoreSections(callback, failure, faqTagFilter);
    }

    protected ArrayList<Section> getSections() {
        ArrayList sections = null;
        try {
            sections = (ArrayList)this.sectionDAO.getAllSections();
        }
        catch (SQLException s) {
            HSLogger.e(TAG, "Database exception in getting sections data ", s);
        }
        return sections;
    }

    public ArrayList<Section> getPopulatedSections(ArrayList<Section> sections, FaqTagFilter faqTagFilter) {
        ArrayList<Section> sectionsList = new ArrayList<Section>();
        for (int i = 0; i < sections.size(); ++i) {
            if (this.isSectionEmpty(sections.get(i), faqTagFilter)) continue;
            sectionsList.add(sections.get(i));
        }
        return sectionsList;
    }

    protected ArrayList<Section> getPopulatedSections(FaqTagFilter faqTagFilter) {
        ArrayList sections = null;
        try {
            sections = (ArrayList)this.sectionDAO.getAllSections(faqTagFilter);
        }
        catch (SQLException s) {
            HSLogger.e(TAG, "Database exception in getting sections data ", s);
        }
        ArrayList<Section> sectionsList = this.getPopulatedSections(sections, faqTagFilter);
        return sectionsList;
    }

    protected boolean isSectionEmpty(Section section, FaqTagFilter faqTagFilter) {
        ArrayList<Faq> faqs = this.getFaqsForSection(section.getPublishId(), faqTagFilter);
        return faqs.isEmpty();
    }

    public ArrayList<Faq> getFaqsForSection(String publishId, FaqTagFilter faqTagFilter) {
        ArrayList faqs = new ArrayList();
        try {
            faqs = (ArrayList)this.faqDAO.getFaqsForSection(publishId, faqTagFilter);
        }
        catch (SQLException s) {
            HSLogger.e(TAG, "Database exception in getting faqs for section", s);
        }
        return faqs;
    }

    protected ArrayList<Faq> getFaqsDataForSection(String publishId) {
        ArrayList faqs = new ArrayList();
        try {
            faqs = (ArrayList)this.faqDAO.getFaqsDataForSection(publishId);
        }
        catch (SQLException s) {
            HSLogger.e(TAG, "Database exception in getting faqs for section", s);
        }
        return faqs;
    }

    public void markFaqInDB(String faqId, boolean isHelpful) {
        this.faqDAO.setIsHelpful(faqId, isHelpful);
    }

    public ArrayList<Faq> localFaqSearch(String query, HSSearch.HS_SEARCH_OPTIONS options) {
        return this.localFaqSearch(query, options, null);
    }

    public ArrayList<Faq> localFaqSearch(String query, HSSearch.HS_SEARCH_OPTIONS options, FaqTagFilter faqTagFilter) {
        if (this.flatFaqList == null) {
            this.updateFlatList();
        } else {
            for (Faq faq : this.flatFaqList) {
                faq.clearSearchTerms();
            }
        }
        LinkedHashSet<Faq> result = new LinkedHashSet<Faq>();
        String lcQuery = query.toLowerCase();
        if (!this.storage.isCacheSearchIndexNull() && this.storage.getDBFlag().booleanValue()) {
            Faq faq;
            int docIdValue;
            String docId;
            FaqSearchIndex fullIndex = this.storage.readIndex();
            Map<String, List<FuzzySearchToken>> fuzzyIndex = null;
            if (fullIndex != null) {
                fuzzyIndex = fullIndex.fuzzyIndex;
            }
            ArrayList<HashMap> tfidfResults = HSSearch.queryDocs(query, options);
            ArrayList<HashMap> fuzzyMatches = HSSearch.getFuzzyMatches(query, fuzzyIndex);
            for (HashMap docIdTermsMap : tfidfResults) {
                docId = (String)docIdTermsMap.get("f");
                docIdValue = Integer.decode(docId);
                if (docIdValue >= this.flatFaqList.size()) continue;
                faq = this.flatFaqList.get(docIdValue);
                faq.addSearchTerms((ArrayList)docIdTermsMap.get("t"));
                result.add(faq);
            }
            for (HashMap docIdTermsMap : fuzzyMatches) {
                docId = (String)docIdTermsMap.get("f");
                docIdValue = Integer.decode(docId);
                if (docIdValue >= this.flatFaqList.size()) continue;
                faq = this.flatFaqList.get(docIdValue);
                faq.addSearchTerms((ArrayList)docIdTermsMap.get("t"));
                result.add(faq);
            }
        } else {
            for (int i = 0; i < this.flatFaqList.size(); ++i) {
                Faq faq = this.flatFaqList.get(i);
                String title = faq.title.toLowerCase();
                if (title.contains(lcQuery)) continue;
                result.add(faq);
            }
        }
        if (faqTagFilter != null) {
            return new ArrayList<Faq>(this.faqDAO.getFilteredFaqs(new ArrayList<Faq>(result), faqTagFilter));
        }
        return new ArrayList<Faq>(result);
    }

    public List<Faq> getAllFaqs(FaqTagFilter faqTagFilter) {
        if (this.flatFaqList == null) {
            this.updateFlatList();
        } else {
            for (Faq faq : this.flatFaqList) {
                faq.clearSearchTerms();
            }
        }
        if (faqTagFilter != null) {
            return new ArrayList<Faq>(this.faqDAO.getFilteredFaqs(new ArrayList<Faq>(this.flatFaqList), faqTagFilter));
        }
        return this.flatFaqList;
    }

    protected Boolean shouldShowReviewPopup() {
        SDKConfigurationDM sdkConfigurationDM = HelpshiftContext.getCoreApi().getSDKConfigurationDM();
        if (!sdkConfigurationDM.getBoolean("app_reviewed")) {
            PeriodicReview periodicReview = sdkConfigurationDM.getPeriodicReview();
            String rurl = sdkConfigurationDM.getString("reviewUrl");
            if (periodicReview.isEnabled && !TextUtils.isEmpty((CharSequence)rurl)) {
                int reviewCount = this.storage.getReviewCounter();
                String type = periodicReview.type;
                int counterInterval = periodicReview.interval;
                if (counterInterval > 0) {
                    if ("l".equals(type) && reviewCount >= counterInterval) {
                        return true;
                    }
                    if ("s".equals(type) && reviewCount != 0 && new Date().getTime() / 1000L - (long)reviewCount >= (long)counterInterval) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected void updateReviewCounter() {
        int reviewCounter = this.storage.getReviewCounter();
        int launchReviewCounter = this.storage.getLaunchReviewCounter();
        if (reviewCounter == 0) {
            launchReviewCounter = reviewCounter;
            reviewCounter = (int)(new Date().getTime() / 1000L);
        }
        this.storage.setLaunchReviewCounter(++launchReviewCounter);
        PeriodicReview periodicReview = HelpshiftContext.getCoreApi().getSDKConfigurationDM().getPeriodicReview();
        String type = periodicReview.type;
        if ("l".equals(type)) {
            reviewCounter = this.storage.getLaunchReviewCounter();
        }
        this.storage.setReviewCounter(reviewCounter);
    }

    protected void resetReviewCounter() {
        int reviewCounter = this.storage.getReviewCounter();
        PeriodicReview periodicReview = HelpshiftContext.getCoreApi().getSDKConfigurationDM().getPeriodicReview();
        String counterType = periodicReview.type;
        if (counterType.equals("s")) {
            reviewCounter = (int)(new Date().getTime() / 1000L);
        } else if (counterType.equals("l")) {
            reviewCounter = 0;
        }
        this.storage.setReviewCounter(reviewCounter);
        this.storage.setLaunchReviewCounter(0);
    }

    public void storeFile(String fileName) {
        try {
            JSONArray fileJsonList = this.storage.getStoredFiles();
            fileJsonList.put((Object)fileName);
            this.storage.setStoredFiles(fileJsonList);
        }
        catch (JSONException e) {
            HSLogger.d(TAG, "storeFile", e);
        }
    }

    void updateIndex() {
        HSLogger.d(TAG, "Updating search indexes.");
        this.storage.deleteIndex();
        this.updateFlatList();
        FaqSearchIndex index = HSSearch.indexDocuments(new ArrayList<Faq>(this.flatFaqList));
        if (index != null) {
            this.storage.storeIndex(index);
        }
        HSApiData.signalSearchIndexesUpdated();
        HSLogger.d(TAG, "Search index update finished.");
    }

    public void loadIndex() {
        Thread loadIndexThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HSApiData.this.storage.loadIndex();
                }
                catch (IOException | ClassCastException | ClassNotFoundException e) {
                    HSLogger.e(HSApiData.TAG, "Exception while loading index: trying to re-create the index", e);
                    HSApiData.this.updateIndex();
                    try {
                        HSApiData.this.storage.loadIndex();
                    }
                    catch (Exception clingy) {
                        HSLogger.e(HSApiData.TAG, "Exception caught again, while loading index: ", clingy);
                    }
                }
            }
        }, "HS-load-index");
        loadIndexThread.setDaemon(true);
        loadIndexThread.start();
    }

    public void getSection(final String publishId, final Handler success, Handler failure, FaqTagFilter faqTagFilter) {
        try {
            if (TextUtils.isEmpty((CharSequence)publishId)) {
                failure.sendMessage(failure.obtainMessage());
                return;
            }
            Section section = this.sectionDAO.getSection(publishId);
            if (section != null) {
                Message msgToPost = success.obtainMessage();
                msgToPost.obj = section;
                success.sendMessage(msgToPost);
            }
            Handler localSuccess = new Handler(){

                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    Section toReturn = HSApiData.this.sectionDAO.getSection(publishId);
                    Message msgToPost = success.obtainMessage();
                    msgToPost.obj = toReturn;
                    success.sendMessage(msgToPost);
                }
            };
            this.getAndStoreSections(localSuccess, failure, faqTagFilter);
        }
        catch (SQLException s) {
            HSLogger.e(TAG, "Database exception in getting section data ", s);
        }
    }

    public Section getSection(String publishId) {
        return this.sectionDAO.getSection(publishId);
    }

    public void getSectionSync(String publishId, Handler success, Handler failure) {
        if (TextUtils.isEmpty((CharSequence)publishId)) {
            failure.sendMessage(failure.obtainMessage());
            return;
        }
        try {
            Section section = this.sectionDAO.getSection(publishId);
            if (section != null) {
                Message msgToPost = success.obtainMessage();
                msgToPost.obj = section;
                success.sendMessage(msgToPost);
            } else {
                Message msgToPost = failure.obtainMessage();
                failure.sendMessage(msgToPost);
            }
        }
        catch (SQLException s) {
            HSLogger.e(TAG, "Database exception in getting section data ", s);
        }
    }

    String getPublishIdFromSectionId(String sectionId) {
        ArrayList<Section> sections = this.getSections();
        String sectionPublishId = "";
        for (int i = 0; i < sections.size(); ++i) {
            Section sectionItem = sections.get(i);
            if (!sectionItem.getSectionId().equals(sectionId)) continue;
            sectionPublishId = sectionItem.getPublishId();
        }
        return sectionPublishId;
    }

    private void getQuestionAsync(final String publishId, final Handler success, final Handler failure) {
        Handler localSuccess = new Handler(){

            public void handleMessage(Message msg) {
                Message msgToPost = success.obtainMessage();
                HashMap result = (HashMap)msg.obj;
                try {
                    if (result != null) {
                        JSONObject question = (JSONObject)result.get("response");
                        Faq newFaq = new Faq(0L, question.getString("id"), question.getString("publish_id"), HSApiData.this.getPublishIdFromSectionId(question.getString("section_id")), question.getString("title"), question.getString("body"), 0, question.getString("is_rtl") == "true", question.has("stags") ? HSJSONUtils.jsonToStringArrayList(question.getString("stags")) : new ArrayList(), question.has("issue_tags") ? HSJSONUtils.jsonToStringArrayList(question.getString("issue_tags")) : new ArrayList());
                        msgToPost.obj = newFaq;
                        success.sendMessage(msgToPost);
                        HSApiData.this.faqDAO.addFaq(newFaq);
                    }
                }
                catch (JSONException e) {
                    HSLogger.d(HSApiData.TAG, "Exception in getting question " + (Object)((Object)e));
                }
            }
        };
        Handler localFailure = new Handler(){

            public void handleMessage(Message msg) {
                int status;
                Message msgToPost = failure.obtainMessage();
                HashMap response = (HashMap)msg.obj;
                if (response != null && ((status = ((Integer)response.get("status")).intValue()) == NetworkErrorCodes.FORBIDDEN_ACCESS || status == NetworkErrorCodes.CONTENT_NOT_FOUND)) {
                    HSApiData.this.faqDAO.removeFaq(publishId);
                    String eTagUrl = HSApiData.this.client.getQuestionRoute(publishId);
                    HelpshiftContext.getPlatform().getNetworkRequestDAO().storeETag(eTagUrl, "");
                    InfoModelFactory.getInstance().sdkInfoModel.clearEtag(eTagUrl);
                }
                failure.sendMessage(msgToPost);
            }
        };
        this.client.getQuestion(publishId, localSuccess, localFailure);
    }

    public void getQuestion(String publishId, Handler success, Handler failure, boolean shouldFetchFromNetwork) {
        if (TextUtils.isEmpty((CharSequence)publishId)) {
            failure.sendMessage(failure.obtainMessage());
            return;
        }
        Faq question = null;
        try {
            question = this.faqDAO.getFaq(publishId);
        }
        catch (SQLException s) {
            HSLogger.e(TAG, "Database exception in getting faq ", s);
        }
        Message msgToPost = success.obtainMessage();
        msgToPost.obj = question;
        success.sendMessage(msgToPost);
        if (question == null || shouldFetchFromNetwork) {
            this.getQuestionAsync(publishId, success, failure);
        }
    }

    Boolean isStatusCodeRetriable(Integer status) {
        if (status >= 400 && status < 600 && status != 503 && status != 504) {
            return false;
        }
        return true;
    }

    protected boolean login(String identifier) {
        if (SupportFragment.isForeground()) {
            HSLogger.d(TAG, "Login should be called before starting a Helpshift session");
            return false;
        }
        if (Arrays.asList(HSConsts.invalidLogins).contains(identifier)) {
            this.logout();
            return false;
        }
        ProfileDM profileDM = HelpshiftContext.getCoreApi().getAccountManagerDM().getProfileDM();
        String previousLogin = profileDM.identifier;
        return previousLogin.equals(identifier) || HelpshiftContext.getCoreApi().login(identifier, null, null);
    }

    protected boolean logout() {
        if (SupportFragment.isForeground()) {
            HSLogger.d(TAG, "Logout should be called before starting a Helpshift session");
            return false;
        }
        return HelpshiftContext.getCoreApi().logout();
    }

    public String getProfileId() {
        ProfileDM profileDM = HelpshiftContext.getCoreApi().getAccountManagerDM().getProfileDM();
        return profileDM.serverId;
    }

    void sendErrorReports(List<LogModel> logs) {
        if (logs == null || logs.isEmpty()) {
            return;
        }
        Handler.Callback handlerCallbackSuccess = new Handler.Callback(){

            public boolean handleMessage(Message message) {
                HSLogger.deleteAll();
                return true;
            }
        };
        Handler.Callback handlerCallbackFailure = new Handler.Callback(){

            public boolean handleMessage(Message message) {
                float serverTimeDelta = HelpshiftContext.getPlatform().getNetworkRequestDAO().getServerTimeDelta();
                long currentElapsedTime = TimeUtil.getAdjustedTimeInMillis(Float.valueOf(serverTimeDelta));
                HSApiData.this.storage.setLastErrorReportedTime(currentElapsedTime - 86400000L - 1L);
                return true;
            }
        };
        Handler success = new Handler(handlerCallbackSuccess);
        Handler failure = new Handler(handlerCallbackFailure);
        this.client.sendErrorReport(success, failure, logs, this.getProfileId(), this.storage.getDomain());
    }

    void clearETagsForFaqs() {
        List<String> allFaqPublishIds = this.faqDAO.getAllFaqPublishIds();
        for (String publishId : allFaqPublishIds) {
            String eTagUrl = this.client.getQuestionRoute(publishId);
            HelpshiftContext.getPlatform().getNetworkRequestDAO().storeETag(eTagUrl, "");
            InfoModelFactory.getInstance().sdkInfoModel.clearEtag(eTagUrl);
        }
        HelpshiftContext.getPlatform().getNetworkRequestDAO().storeETag("/faqs/", null);
    }
}

